/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.affix.impl.ranged;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import shadows.apotheosis.deadly.affix.Affix;
import shadows.apotheosis.deadly.affix.EquipmentType;
import shadows.apotheosis.deadly.affix.modifiers.AffixModifier;

public class SnareHitAffix
extends Affix {
    public SnareHitAffix(int weight) {
        super(weight);
    }

    @Override
    public float generateLevel(ItemStack stack, Random rand, AffixModifier modifier) {
        int lvl = 2 + rand.nextInt(5);
        if (modifier != null) {
            lvl = (int)modifier.editLevel(this, lvl);
        }
        return lvl;
    }

    @Override
    public boolean canApply(EquipmentType type) {
        return type == EquipmentType.RANGED;
    }

    @Override
    public void onArrowImpact(AbstractArrowEntity arrow, RayTraceResult res, RayTraceResult.Type type, float level) {
        Entity hit;
        if (type == RayTraceResult.Type.ENTITY && (hit = ((EntityRayTraceResult)res).func_216348_a()) instanceof LivingEntity) {
            ((LivingEntity)hit).func_195064_c(new EffectInstance(Effects.field_76421_d, 20 * (int)level, 10));
        }
    }

    @Override
    public float getMin() {
        return 1.0f;
    }

    @Override
    public float getMax() {
        return 10.0f;
    }
}

