/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.affix.recipe;

import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.affix.AffixHelper;
import shadows.apotheosis.deadly.affix.LootRarity;
import shadows.apotheosis.deadly.affix.recipe.SoulfireCookingRecipe;

public class AffixShardingRecipe
extends SoulfireCookingRecipe {
    public static final IRecipeSerializer<AffixShardingRecipe> SERIALIZER = new Serializer();
    protected final LootRarity rarity;
    protected final Ingredient ing;

    public AffixShardingRecipe(ResourceLocation id, LootRarity rarity) {
        super(id, "", Ingredient.field_193370_a, new ItemStack((IItemProvider)DeadlyModule.RARITY_SHARDS.get((Object)rarity)), 0.0f, 200);
        this.rarity = rarity;
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151048_u);
        AffixHelper.addLore(stack, (ITextComponent)new TranslationTextComponent("info.apotheosis.any_of_rarity", new Object[]{new TranslationTextComponent("rarity.apoth." + rarity.name().toLowerCase(Locale.ROOT))}));
        this.ing = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
    }

    @Override
    protected boolean matches(ItemStack stack) {
        return AffixHelper.getRarity(stack) == this.rarity;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.ing});
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AffixShardingRecipe> {
        public AffixShardingRecipe read(ResourceLocation recipeId, JsonObject json) {
            LootRarity rarity = LootRarity.valueOf(JSONUtils.func_151200_h((JsonObject)json, (String)"rarity"));
            return new AffixShardingRecipe(recipeId, rarity);
        }

        public AffixShardingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            LootRarity rarity = LootRarity.values()[buffer.readByte()];
            return new AffixShardingRecipe(recipeId, rarity);
        }

        public void write(PacketBuffer buffer, AffixShardingRecipe recipe) {
            buffer.writeByte(recipe.rarity.ordinal());
        }
    }
}

