/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.world.ISeedReader;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.placebo.config.Configuration;

public class DeadlyConfig {
    public static final List<ResourceLocation> DIM_WHITELIST = new ArrayList<ResourceLocation>();
    public static final List<ResourceLocation> BIOME_BLACKLIST = new ArrayList<ResourceLocation>();
    public static Configuration config;
    public static int surfaceBossChance;
    public static int randomAffixItem;
    public static boolean surfaceBossLightning;
    public static int bossDungeonAttempts;
    public static int bossDungeon2Attempts;
    public static int rogueSpawnerAttempts;
    public static int troveAttempts;
    public static int tomeTowerChance;
    public static boolean affixTrades;
    public static int spawnerValueChance;

    public static void loadConfigs() {
        String[] biomes;
        Configuration c = config;
        String[] dims = c.getStringList("Generation Dimension Whitelist", "general", new String[]{"overworld"}, "The dimensions that the deadly module will generate in.");
        DIM_WHITELIST.clear();
        for (String s : dims) {
            try {
                DIM_WHITELIST.add(new ResourceLocation(s.trim()));
            }
            catch (ResourceLocationException e) {
                DeadlyModule.LOGGER.error("Invalid dim whitelist entry: " + s + " will be ignored");
            }
        }
        for (String s : biomes = c.getStringList("Generation Biome Blacklist", "general", new String[]{"minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:cold_ocean", "minecraft:frozen_ocean", "minecraft:deep_warm_ocean", "minecraft:deep_frozen_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:deep_cold_ocean", "minecraft:ocean", "minecraft:deep_ocean"}, "The biomes that the deadly module will not generate in.")) {
            try {
                BIOME_BLACKLIST.add(new ResourceLocation(s.trim()));
            }
            catch (ResourceLocationException e) {
                DeadlyModule.LOGGER.error("Invalid biome blacklist entry: " + s + " will be ignored!");
            }
        }
        surfaceBossChance = c.getInt("Surface Boss Chance", "bosses", surfaceBossChance, 1, 500000, "The 1/n chance that a naturally spawned mob that can see the sky is transformed into a boss.");
        randomAffixItem = c.getInt("Random Affix Chance", "affixes", randomAffixItem, 1, 500000, "The 1/n chance that a naturally spawned mob will be granted an affix item.");
        surfaceBossLightning = c.getBoolean("Surface Boss Lightning", "bosses", true, "If a lightning bolt strikes when a surface boss spawn occurs.");
        bossDungeonAttempts = c.getInt("Boss Dungeon", "frequency", bossDungeonAttempts, 0, 50000, "The number of generation attempts (per chunk) for boss dungeons.");
        bossDungeon2Attempts = c.getInt("Boss Dungeon Variant 2", "frequency", bossDungeon2Attempts, 0, 50000, "The number of generation attempts (per chunk) for boss dungeon variant 2.");
        rogueSpawnerAttempts = c.getInt("Rogue Spawners", "frequency", rogueSpawnerAttempts, 0, 50000, "The number of generation attempts (per chunk) for rogue spawners.");
        troveAttempts = c.getInt("Ore Troves", "frequency", troveAttempts, 0, 50000, "The number of generation attempts (per chunk) for ore troves.");
        tomeTowerChance = c.getInt("Tome Tower", "frequency", tomeTowerChance, 0, 50000, "The 1/n chance (per chunk) that a tome tower may attempt generation. 0 = disabled, lower = more chances.");
        affixTrades = c.getBoolean("Affix Trades", "wanderer", true, "If the wandering trader may sell affix loot items as a rare trade.");
        spawnerValueChance = c.getInt("Spawner Rare Loot Chance", "general", spawnerValueChance, 0, 80000, "The 1/n chance that a rogue spawner will generate with a CHEST_VALUABLE instead of it's default chest.  0 to disable.");
    }

    public static boolean canGenerateIn(ISeedReader world) {
        RegistryKey key = world.func_201672_e().func_234923_W_();
        return DIM_WHITELIST.contains(key.func_240901_a_());
    }

    static {
        surfaceBossChance = 85;
        randomAffixItem = 125;
        surfaceBossLightning = true;
        bossDungeonAttempts = 8;
        bossDungeon2Attempts = 8;
        rogueSpawnerAttempts = 4;
        troveAttempts = 8;
        tomeTowerChance = 125;
        affixTrades = true;
        spawnerValueChance = 9;
    }
}

