/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.loot.LootTables;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.config.DeadlyConfig;
import shadows.apotheosis.deadly.objects.BossSpawnerBlock;
import shadows.apotheosis.deadly.reload.BossItemManager;

public class BossDungeonFeature2
extends Feature<NoFeatureConfig> {
    public static final ResourceLocation TEMPLATE_ID = new ResourceLocation("apotheosis", "boss_1");
    public static final BossDungeonFeature2 INSTANCE = new BossDungeonFeature2();
    protected static int xRadius = 4;
    protected static int floor = -1;
    protected static int roof = 3;
    protected static int roofTop = 6;
    protected static int zRadius = 4;

    public BossDungeonFeature2() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator gen, Random rand, BlockPos pos, NoFeatureConfig cfg) {
        if (!DeadlyConfig.canGenerateIn(world)) {
            return false;
        }
        BlockState[][][] states = new BlockState[9][8][9];
        int doors = 0;
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int y = floor; y <= roofTop; ++y) {
                for (int z = -zRadius; z <= zRadius; ++z) {
                    BlockPos blockpos = pos.func_177982_a(x, y, z);
                    BlockState state = world.func_180495_p(blockpos);
                    Material material = state.func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (y == floor && !flag) {
                        return false;
                    }
                    if (y == roof && !flag) {
                        return false;
                    }
                    if (y == roof + 1 && Math.abs(x) < xRadius && Math.abs(z) < zRadius && !flag) {
                        return false;
                    }
                    if (BossDungeonFeature2.isDoorSpace(x, z) && y == 1 && state.func_196958_f() && states[x + xRadius][y - 1 + 1][z + zRadius].func_196958_f()) {
                        ++doors;
                    }
                    states[x + BossDungeonFeature2.xRadius][y + 1][z + BossDungeonFeature2.zRadius] = state;
                }
            }
        }
        if (doors >= 3) {
            Template template = ServerLifecycleHooks.getCurrentServer().func_240792_aT_().func_200219_b(TEMPLATE_ID);
            template.func_237152_b_((IServerWorld)world, pos.func_177982_a(-4, -1, -4), new PlacementSettings(), rand);
            boolean rand1 = rand.nextBoolean();
            boolean rand2 = rand.nextBoolean();
            BlockPos chest1 = pos.func_177982_a(rand1 ? xRadius - 1 : -xRadius + 1, 0, rand2 ? zRadius - 1 : -zRadius + 1);
            BlockPos chest2 = pos.func_177982_a(!rand1 ? xRadius - 1 : -xRadius + 1, 0, !rand2 ? zRadius - 1 : -zRadius + 1);
            world.func_180501_a(chest1, StructurePiece.func_197528_a((IBlockReader)world, (BlockPos)chest1, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)chest1, (ResourceLocation)LootTables.field_186422_d);
            world.func_180501_a(chest2, StructurePiece.func_197528_a((IBlockReader)world, (BlockPos)chest2, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)chest2, (ResourceLocation)LootTables.field_186422_d);
            world.func_180501_a(pos, ApotheosisObjects.BOSS_SPAWNER.func_176223_P(), 2);
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof BossSpawnerBlock.BossSpawnerTile) {
                ((BossSpawnerBlock.BossSpawnerTile)tileentity).setBossItem(BossItemManager.INSTANCE.getRandomItem(rand));
            } else {
                DeadlyModule.LOGGER.error("Failed to fetch boss spawner entity at ({}, {}, {})", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
            }
            DeadlyModule.debugLog(pos, "Boss Dungeon (Variant 2)");
            return true;
        }
        return false;
    }

    static boolean isDoorSpace(int x, int z) {
        return Math.abs(z) == zRadius && x >= -1 && x <= 1 || Math.abs(x) == xRadius && z >= -1 && z <= 1;
    }
}

