/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.deadly.affix.LootRarity;
import shadows.apotheosis.deadly.reload.AffixLootManager;
import shadows.apotheosis.deadly.reload.BossArmorManager;
import shadows.apotheosis.ench.asm.EnchHooks;
import shadows.apotheosis.util.ChancedEffectInstance;
import shadows.apotheosis.util.GearSet;
import shadows.apotheosis.util.NameHelper;
import shadows.apotheosis.util.RandomAttributeModifier;

public class BossItem
extends WeightedRandom.Item {
    public static final Predicate<Goal> IS_VILLAGER_ATTACK = a -> a instanceof NearestAttackableTargetGoal && ((NearestAttackableTargetGoal)a).field_75307_b == VillagerEntity.class;
    @Expose(deserialize=false)
    protected ResourceLocation id;
    protected final EntityType<?> entity;
    protected final AxisAlignedBB size;
    @SerializedName(value="enchant_chance")
    protected final float enchantChance;
    @SerializedName(value="rarity_offset")
    protected final int rarityOffset;
    @SerializedName(value="enchantment_levels")
    protected final int[] enchLevels;
    protected final List<ChancedEffectInstance> effects;
    @SerializedName(value="valid_gear_sets")
    protected final List<GearSet.SetPredicate> armorSets;
    @SerializedName(value="attribute_modifiers")
    protected final List<RandomAttributeModifier> modifiers;

    public BossItem(int weight, EntityType<?> entity, AxisAlignedBB size, float enchantChance, int rarityOffset, int[] enchLevels, List<ChancedEffectInstance> effects, List<GearSet.SetPredicate> armorSets, List<RandomAttributeModifier> modifiers) {
        super(weight);
        this.entity = entity;
        this.size = size;
        this.enchantChance = enchantChance;
        this.rarityOffset = rarityOffset;
        this.enchLevels = enchLevels;
        this.effects = effects;
        this.armorSets = armorSets;
        this.modifiers = modifiers;
    }

    public void setId(ResourceLocation id) {
        if (this.id != null) {
            throw new IllegalStateException("Cannot set the id of this boss item, it is already set!");
        }
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public AxisAlignedBB getSize() {
        return this.size;
    }

    public EntityType<?> getEntity() {
        return this.entity;
    }

    public MobEntity createBoss(IServerWorld world, BlockPos pos, Random rand) {
        MobEntity entity = (MobEntity)this.entity.func_200721_a((World)world.func_201672_e());
        this.initBoss(rand, entity);
        entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        return entity;
    }

    public void initBoss(Random rand, MobEntity entity) {
        int duration = entity instanceof CreeperEntity ? 6000 : Integer.MAX_VALUE;
        for (ChancedEffectInstance inst : this.effects) {
            if (!(rand.nextFloat() <= inst.getChance())) continue;
            entity.func_195064_c(inst.createInstance(rand, duration));
        }
        for (RandomAttributeModifier modif : this.modifiers) {
            modif.apply(rand, entity);
        }
        entity.func_70606_j(entity.func_110138_aP());
        entity.field_70714_bg.field_220892_d.removeIf(IS_VILLAGER_ATTACK);
        String name = NameHelper.setEntityName(rand, entity);
        BossArmorManager.INSTANCE.getRandomSet(rand, this.armorSets).apply((LivingEntity)entity);
        int guaranteed = rand.nextInt(6);
        while (entity.func_184582_a(EquipmentSlotType.values()[guaranteed]).func_190926_b()) {
            guaranteed = rand.nextInt(6);
        }
        for (EquipmentSlotType s : EquipmentSlotType.values()) {
            ItemStack stack = entity.func_184582_a(s);
            if (s.ordinal() == guaranteed) {
                entity.func_184642_a(s, 2.0f);
            } else {
                entity.func_184642_a(s, ThreadLocalRandom.current().nextFloat() / 2.0f);
            }
            if (s.ordinal() == guaranteed) {
                entity.func_184201_a(s, this.modifyBossItem(stack, rand, name));
                continue;
            }
            if (!(rand.nextFloat() < this.enchantChance)) continue;
            List ench = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)stack, (int)(Apotheosis.enableEnch ? this.enchLevels[0] : this.enchLevels[1]), (boolean)true);
            EnchantmentHelper.func_82782_a((Map)ench.stream().filter(d -> !d.field_76302_b.func_190936_d()).collect(Collectors.toMap(d -> d.field_76302_b, d -> d.field_76303_c, Math::max, HashMap::new)), (ItemStack)stack);
            entity.func_184201_a(s, stack);
        }
    }

    public ItemStack modifyBossItem(ItemStack stack, Random random, String bossName) {
        List ench = EnchantmentHelper.func_77513_b((Random)random, (ItemStack)stack, (int)(Apotheosis.enableEnch ? this.enchLevels[2] : this.enchLevels[3]), (boolean)true);
        EnchantmentHelper.func_82782_a(ench.stream().filter(d -> !d.field_76302_b.func_190936_d()).collect(Collectors.toMap(d -> d.field_76302_b, d -> d.field_76303_c, Math::max)), (ItemStack)stack);
        LootRarity rarity = LootRarity.random(random, this.rarityOffset);
        NameHelper.setItemName(random, stack, bossName);
        stack = AffixLootManager.genLootItem(stack, random, rarity);
        stack.func_200302_a((ITextComponent)new TranslationTextComponent("%s %s", new Object[]{TextFormatting.RESET + rarity.getColor().toString() + String.format(NameHelper.ownershipFormat, bossName), stack.func_200301_q()}).func_240699_a_(rarity.getColor()));
        HashMap<Enchantment, Integer> enchMap = new HashMap<Enchantment, Integer>();
        for (Map.Entry e : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
            if (e.getKey() == null) continue;
            enchMap.put((Enchantment)e.getKey(), Math.min(EnchHooks.getMaxLevel((Enchantment)e.getKey()), (Integer)e.getValue() + random.nextInt(2)));
        }
        EnchantmentHelper.func_82782_a(enchMap, (ItemStack)stack);
        stack.func_77978_p().func_74757_a("apoth_boss", true);
        return stack;
    }
}

