/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.config.DeadlyConfig;

public class TomeTowerFeature
extends Feature<NoFeatureConfig> {
    public static final ResourceLocation TEMPLATE_ID = new ResourceLocation("apotheosis", "tome_tower");
    public static final TomeTowerFeature INSTANCE = new TomeTowerFeature();

    public TomeTowerFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator gen, Random rand, BlockPos pos, NoFeatureConfig cfg) {
        if (!DeadlyConfig.canGenerateIn(world)) {
            return false;
        }
        if (world.func_180495_p(pos = pos.func_177982_a(rand.nextInt(5), -1, rand.nextInt(5))).func_177230_c() == Blocks.field_150433_aE) {
            pos = pos.func_177977_b();
        }
        for (int x = 0; x < 9; ++x) {
            for (int z = 0; z < 9; ++z) {
                for (int y = 0; y < 4; ++y) {
                    BlockPos blockpos = pos.func_177982_a(x, y, z);
                    BlockState state = world.func_180495_p(blockpos);
                    Material material = state.func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (y == 0 && !flag) {
                        return false;
                    }
                    if (y <= 0 || !flag) continue;
                    return false;
                }
            }
        }
        Template template = ServerLifecycleHooks.getCurrentServer().func_240792_aT_().func_200219_b(TEMPLATE_ID);
        Rotation rot = Rotation.func_222466_a((Random)rand);
        int rotOrd = rot.ordinal();
        pos = pos.func_177982_a(rotOrd > 0 && rotOrd < 3 ? 8 : 0, 0, rotOrd > 1 ? 8 : 0);
        template.func_237152_b_((IServerWorld)world, pos, new PlacementSettings().func_186220_a(rot), rand);
        DeadlyModule.debugLog(pos, "Tome Tower");
        return true;
    }
}

