/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.gen;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.config.DeadlyConfig;

public class TroveFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final Block[] ORES = new Block[]{Blocks.field_150366_p, Blocks.field_150365_q, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150450_ax, Blocks.field_150369_x};
    public static final Predicate<BlockState> STONE_TEST = s -> OreFeatureConfig.FillerBlockType.field_241882_a.func_215181_a(s, null);
    public static final TroveFeature INSTANCE = new TroveFeature();

    public TroveFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator gen, Random rand, BlockPos pos, NoFeatureConfig cfg) {
        BlockState state;
        BlockPos blockpos;
        int z;
        int y;
        int x;
        if (!DeadlyConfig.canGenerateIn(world)) {
            return false;
        }
        int xRadius = 2 + rand.nextInt(2);
        int floor = -1;
        int tntLevel = -2;
        int undercoat = -3;
        int roof = 3;
        int zRadius = 2 + rand.nextInt(2);
        int doors = 0;
        BlockState[][][] states = new BlockState[xRadius * 2 + 1][7][zRadius * 2 + 1];
        for (x = -xRadius; x <= xRadius; ++x) {
            for (y = undercoat; y <= roof; ++y) {
                for (z = -zRadius; z <= zRadius; ++z) {
                    boolean flag;
                    blockpos = pos.func_177982_a(x, y, z);
                    state = world.func_180495_p(blockpos);
                    Material material = state.func_185904_a();
                    boolean bl = flag = material.func_76220_a() && material.func_76218_k();
                    if (y <= floor && !flag) {
                        return false;
                    }
                    if (y == roof && !flag) {
                        return false;
                    }
                    if ((Math.abs(x) == xRadius && Math.abs(z) != zRadius || Math.abs(z) == zRadius && Math.abs(x) != xRadius) && y == 1 && state.func_196958_f() && states[x + xRadius][y - 1 + 3][z + zRadius].func_196958_f()) {
                        ++doors;
                    }
                    states[x + xRadius][y + 3][z + zRadius] = state;
                }
            }
        }
        if (doors >= 1 && doors <= 2) {
            for (x = -xRadius; x <= xRadius; ++x) {
                for (y = tntLevel; y < roof; ++y) {
                    for (z = -zRadius; z <= zRadius; ++z) {
                        blockpos = pos.func_177982_a(x, y, z);
                        state = states[x + xRadius][y + 3][z + zRadius];
                        if (y == tntLevel && Math.abs(x) <= 1 && Math.abs(z) <= 1) {
                            if (state.func_203425_a(Blocks.field_150486_ae)) continue;
                            world.func_180501_a(blockpos, Blocks.field_150335_W.func_176223_P(), 2);
                            continue;
                        }
                        if (Math.abs(x) == xRadius || Math.abs(z) == zRadius) {
                            if (y == 0 && state.isAir((IBlockReader)world, blockpos) && states[x + xRadius][y + 1 + 3][z + zRadius].isAir((IBlockReader)world, blockpos.func_177984_a())) {
                                int xModif;
                                world.func_180501_a(blockpos, Blocks.field_196553_aF.func_176223_P(), 2);
                                states[x + xRadius][y + 3][z + zRadius] = Blocks.field_196553_aF.func_176223_P();
                                world.func_180501_a(blockpos.func_177984_a(), Blocks.field_196553_aF.func_176223_P(), 2);
                                states[x + xRadius][y + 1 + 3][z + zRadius] = Blocks.field_196553_aF.func_176223_P();
                                int n = x == xRadius ? -1 : (xModif = x == -xRadius ? 1 : 0);
                                int zModif = z == zRadius ? -1 : (z == -zRadius ? 1 : 0);
                                BlockPos inward = blockpos.func_177982_a(xModif, 0, zModif);
                                world.func_180501_a(inward, Blocks.field_150456_au.func_176223_P(), 2);
                                states[x + xModif + xRadius][y + 3][z + zModif + zRadius] = Blocks.field_150456_au.func_176223_P();
                                if (x <= 2 && z <= 2) continue;
                                world.func_180501_a(inward.func_177979_c(2), Blocks.field_150335_W.func_176223_P(), 2);
                                continue;
                            }
                            if (!STONE_TEST.test(state) && !state.isAir((IBlockReader)world, blockpos)) continue;
                            if (rand.nextFloat() < 0.75f) {
                                world.func_180501_a(blockpos, ORES[rand.nextInt(ORES.length)].func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(blockpos, Blocks.field_150348_b.func_176223_P(), 2);
                            continue;
                        }
                        if (y < 0 || y >= roof || state.func_177230_c() == Blocks.field_150456_au) continue;
                        world.func_180501_a(blockpos, CAVE_AIR, 2);
                    }
                }
            }
            DeadlyModule.debugLog(pos, "Ore Trove");
            return true;
        }
        return false;
    }
}

