/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AnvilUpdateEvent;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.affix.Affix;
import shadows.apotheosis.deadly.affix.AffixHelper;
import shadows.apotheosis.deadly.affix.EquipmentType;
import shadows.apotheosis.deadly.affix.IAffixSensitiveItem;
import shadows.apotheosis.deadly.affix.LootRarity;

public class AffixTomeItem
extends BookItem
implements IAffixSensitiveItem {
    static Random rand = new Random();
    protected final LootRarity field_208075_l;

    public AffixTomeItem(LootRarity rarity, Item.Properties props) {
        super(props);
        this.field_208075_l = rarity;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!this.func_77636_d(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.apotheosis.affix_tome"));
            tooltip.add((ITextComponent)new TranslationTextComponent("info.apotheosis.affix_tome2", new Object[]{new TranslationTextComponent("rarity.apoth." + this.field_208075_l.name().toLowerCase(Locale.ROOT))}));
        } else {
            Map<Affix, Float> afx = AffixHelper.getAffixes(stack);
            afx.forEach((a, l) -> tooltip.add(a.getDisplayName(l.floatValue())));
        }
    }

    public ITextComponent func_200296_o() {
        return ((IFormattableTextComponent)super.func_200296_o()).func_240699_a_(this.field_208075_l.getColor());
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent(this.func_77667_c(stack)).func_240699_a_(this.field_208075_l.getColor());
    }

    public boolean func_77636_d(ItemStack stack) {
        return AffixHelper.hasAffixes(stack);
    }

    public LootRarity getRarity() {
        return this.field_208075_l;
    }

    public static boolean updateAnvil(AnvilUpdateEvent ev) {
        ItemStack weapon = ev.getLeft();
        ItemStack book = ev.getRight();
        if (!(book.func_77973_b() instanceof AffixTomeItem)) {
            return false;
        }
        if (!AffixHelper.hasAffixes(book) && AffixHelper.hasAffixes(weapon)) {
            LootRarity rarity = AffixHelper.getRarity(weapon);
            if (rarity == null) {
                return false;
            }
            if (rarity.ordinal() > ((AffixTomeItem)book.func_77973_b()).field_208075_l.ordinal()) {
                return false;
            }
            Map<Affix, Float> wepAfx = AffixHelper.getAffixes(weapon);
            int size = Math.max(1, MathHelper.func_76143_f((double)((double)wepAfx.size() / 2.0)));
            ArrayList<Affix> keys = new ArrayList<Affix>(wepAfx.keySet());
            long seed = 1831L;
            for (Affix e : keys) {
                seed ^= (long)e.getRegistryName().hashCode();
            }
            rand.setSeed(seed ^= (long)ev.getPlayer().func_175138_ci());
            while (keys.size() > size) {
                Affix lost = (Affix)((Object)keys.get(rand.nextInt(keys.size())));
                wepAfx.remove((Object)lost);
                keys.remove((Object)lost);
            }
            ItemStack out = new ItemStack((IItemProvider)DeadlyModule.RARITY_TOMES.get((Object)rarity));
            AffixHelper.setAffixes(out, wepAfx);
            ev.setMaterialCost(1);
            ev.setCost(wepAfx.size() * 18);
            ev.setOutput(out);
        } else if (AffixHelper.hasAffixes(book)) {
            Map<Affix, Float> bookAfx = AffixHelper.getAffixes(book);
            Map<Affix, Float> wepAfx = AffixHelper.getAffixes(weapon);
            EquipmentType type = EquipmentType.getTypeFor(weapon);
            if (type == null) {
                return false;
            }
            ITextComponent name = weapon.func_200301_q();
            ItemStack out = weapon.func_77946_l();
            int baseCost = wepAfx.size() * 4;
            int cost = 0;
            for (Map.Entry<Affix, Float> e : bookAfx.entrySet()) {
                Affix afx = e.getKey();
                if (!afx.canApply(type)) continue;
                float curLvl = wepAfx.getOrDefault((Object)afx, Float.valueOf(0.0f)).floatValue();
                if (curLvl == 0.0f) {
                    name = afx.chainName(name, null);
                    AffixHelper.applyAffix(out, afx, e.getValue().floatValue());
                    cost += 18;
                    continue;
                }
                if (!(curLvl < e.getValue().floatValue())) continue;
                AffixHelper.applyAffix(out, afx, e.getValue().floatValue());
                cost += 9;
            }
            if (cost == 0) {
                return false;
            }
            cost += baseCost;
            out.func_200302_a((ITextComponent)((IFormattableTextComponent)name).func_240699_a_(((AffixTomeItem)book.func_77973_b()).field_208075_l.getColor()));
            out.func_190920_e(1);
            AffixTomeItem.setTypeConsumed(out, type);
            ev.setMaterialCost(1);
            ev.setCost(cost);
            ev.setOutput(out);
        }
        return true;
    }

    public static void setTypeConsumed(ItemStack stack, EquipmentType type) {
        stack.func_196082_o().func_74768_a("equipment_type", type.ordinal());
    }

    @Nullable
    public static EquipmentType getTypeConsumed(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("equipment_type") ? EquipmentType.values()[stack.func_77978_p().func_74762_e("equipment_type")] : null;
    }

    @Override
    public boolean receivesAttributes(ItemStack stack) {
        return false;
    }

    @Override
    public boolean receivesTooltips(ItemStack stack) {
        return false;
    }
}

