/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.reload;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import shadows.apotheosis.deadly.DeadlyModule;
import shadows.apotheosis.deadly.affix.Affix;
import shadows.apotheosis.deadly.affix.AffixHelper;
import shadows.apotheosis.deadly.affix.AffixLootEntry;
import shadows.apotheosis.deadly.affix.Affixes;
import shadows.apotheosis.deadly.affix.EquipmentType;
import shadows.apotheosis.deadly.affix.LootRarity;
import shadows.apotheosis.deadly.affix.modifiers.AffixModifier;
import shadows.apotheosis.deadly.affix.modifiers.Modifiers;
import shadows.apotheosis.deadly.reload.BossArmorManager;

public class AffixLootManager
extends JsonReloadListener {
    public static final Gson GSON = BossArmorManager.GSON;
    public static final AffixLootManager INSTANCE = new AffixLootManager();
    private static final List<AffixLootEntry> ENTRIES = new ArrayList<AffixLootEntry>();

    private AffixLootManager() {
        super(GSON, "affix_loot_entries");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, IResourceManager mgr, IProfiler profiler) {
        ENTRIES.clear();
        for (Map.Entry<ResourceLocation, JsonElement> obj : objects.entrySet()) {
            try {
                AffixLootEntry ent = (AffixLootEntry)((Object)GSON.fromJson(obj.getValue(), AffixLootEntry.class));
                ENTRIES.add(ent);
            }
            catch (Exception e) {
                DeadlyModule.LOGGER.error("Failed to load affix loot entry {}.", (Object)obj.getKey());
                e.printStackTrace();
            }
        }
        Collections.shuffle(ENTRIES);
        DeadlyModule.LOGGER.info("Loaded {} affix loot entries from resources.", (Object)ENTRIES.size());
    }

    public static List<AffixLootEntry> getEntries() {
        return ENTRIES;
    }

    public static ItemStack getRandomEntry(Random rand, LootRarity rarity) {
        AffixLootEntry entry = (AffixLootEntry)WeightedRandom.func_76271_a((Random)rand, ENTRIES);
        ItemStack stack = rarity == LootRarity.ANCIENT ? AffixLootManager.genUnique(rand) : entry.getStack().func_77946_l();
        return stack;
    }

    public static ItemStack getRandomEntry(Random rand, LootRarity rarity, EquipmentType type) {
        if (type == null) {
            return AffixLootManager.getRandomEntry(rand, rarity);
        }
        AffixLootEntry entry = (AffixLootEntry)WeightedRandom.func_76271_a((Random)rand, ENTRIES.stream().filter(p -> p.getType() == type).collect(Collectors.toList()));
        ItemStack stack = rarity == LootRarity.ANCIENT ? AffixLootManager.genUnique(rand) : entry.getStack().func_77946_l();
        return stack;
    }

    public static ItemStack genLootItem(ItemStack stack, Random rand, LootRarity rarity) {
        ITextComponent name = stack.func_200301_q();
        EquipmentType type = EquipmentType.getTypeFor(stack);
        if (type == null) {
            AffixHelper.addLore(stack, (ITextComponent)new StringTextComponent("ERROR - ATTEMPTED TO GENERATE LOOT ITEM WITH INVALID EQUIPMENT TYPE."));
            return stack;
        }
        HashMap<Affix, AffixModifier> affixes = new HashMap<Affix, AffixModifier>();
        AffixHelper.setRarity(stack, rarity);
        if (type == EquipmentType.AXE) {
            AffixHelper.applyAffix(stack, Affixes.PIERCING, Affixes.PIERCING.generateLevel(stack, rand, null));
        }
        List<Affix> afxList = AffixHelper.getAffixesFor(type);
        int affixCount = rarity.getAffixes();
        while (affixes.size() < Math.min(affixCount, afxList.size())) {
            affixes.put((Affix)WeightedRandom.func_76271_a((Random)rand, afxList), rarity == LootRarity.COMMON ? Modifiers.getBadModifier() : null);
        }
        if (rarity.ordinal() >= LootRarity.EPIC.ordinal()) {
            float modifChance = rarity == LootRarity.EPIC ? 0.3f : 0.65f;
            for (Affix a : affixes.keySet()) {
                if (!(rand.nextFloat() <= modifChance)) continue;
                affixes.put(a, Modifiers.getRandomModifier(rand));
            }
        }
        for (Affix a : affixes.keySet()) {
            name = a.chainName(name, (AffixModifier)((Object)affixes.get((Object)a)));
            AffixHelper.applyAffix(stack, a, a.generateLevel(stack, rand, (AffixModifier)((Object)affixes.get((Object)a))));
        }
        if (rarity.ordinal() >= LootRarity.MYTHIC.ordinal()) {
            CompoundNBT tag = stack.func_196082_o();
            tag.func_74757_a("Unbreakable", true);
        }
        stack.func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.RESET + rarity.getColor().toString() + name.getString().replace(TextFormatting.RESET.toString(), "")));
        return stack;
    }

    public static ItemStack genUnique(Random rand) {
        return ItemStack.field_190927_a;
    }
}

