/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.advancements.EnchantedTrigger;
import shadows.apotheosis.ench.objects.TomeItem;
import shadows.apotheosis.ench.table.ApothEnchantTile;
import shadows.apotheosis.ench.table.EnchantingStatManager;
import shadows.apotheosis.ench.table.RealEnchantmentHelper;
import shadows.apotheosis.util.FloatReferenceHolder;

public class ApothEnchantContainer
extends EnchantmentContainer {
    protected FloatReferenceHolder eterna = new FloatReferenceHolder(0.0f, 0.0f, EnchantingStatManager.getAbsoluteMaxEterna());
    protected FloatReferenceHolder quanta = new FloatReferenceHolder(0.0f, 0.0f, 10.0f);
    protected FloatReferenceHolder arcana = new FloatReferenceHolder(0.0f, 0.0f, 10.0f);

    public ApothEnchantContainer(int id, PlayerInventory inv) {
        super(id, inv, IWorldPosCallable.field_221489_a);
        this.field_75151_b.clear();
        this.func_75146_a(new Slot(this.field_75168_e, 0, 15, 47){

            public boolean func_75214_a(ItemStack stack) {
                return true;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot(this.field_75168_e, 1, 35, 47){

            public boolean func_75214_a(ItemStack stack) {
                return Tags.Items.GEMS_LAPIS.func_230235_a_((Object)stack.func_77973_b());
            }
        });
        this.initCommon(inv);
    }

    public ApothEnchantContainer(int id, PlayerInventory inv, IWorldPosCallable wPos, ApothEnchantTile te) {
        super(id, inv, wPos);
        this.field_75151_b.clear();
        this.func_75146_a(new Slot(this.field_75168_e, 0, 15, 47){

            public boolean func_75214_a(ItemStack stack) {
                return true;
            }

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)te.inv, 0, 35, 47){

            public boolean func_75214_a(ItemStack stack) {
                return Tags.Items.GEMS_LAPIS.func_230235_a_((Object)stack.func_77973_b());
            }
        });
        this.initCommon(inv);
    }

    private void initCommon(PlayerInventory inv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 31));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)inv, k, 8 + k * 18, 173));
        }
        this.func_216961_a((IIntArray)this.eterna.getArray());
        this.func_216961_a((IIntArray)this.quanta.getArray());
        this.func_216961_a((IIntArray)this.arcana.getArray());
    }

    public boolean func_75140_a(PlayerEntity player, int id) {
        int level = this.field_75167_g[id];
        ItemStack toEnchant = this.field_75168_e.func_70301_a(0);
        ItemStack lapis = this.func_75139_a(1).func_75211_c();
        int i = id + 1;
        if ((lapis.func_190926_b() || lapis.func_190916_E() < i) && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (this.field_75167_g[id] <= 0 || toEnchant.func_190926_b() || (player.field_71068_ca < i || player.field_71068_ca < this.field_75167_g[id]) && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        this.field_217006_g.func_221486_a((world, pos) -> {
            ItemStack enchanted = toEnchant;
            List<EnchantmentData> list = this.getEnchantmentList(toEnchant, id, this.field_75167_g[id]);
            if (!list.isEmpty()) {
                boolean flag;
                player.func_192024_a(toEnchant, i);
                boolean bl = flag = toEnchant.func_77973_b() == Items.field_151122_aG || toEnchant.func_77973_b() instanceof TomeItem;
                if (flag) {
                    enchanted = new ItemStack((IItemProvider)Items.field_151134_bR);
                    this.field_75168_e.func_70299_a(0, enchanted);
                }
                for (int j = 0; j < list.size(); ++j) {
                    EnchantmentData enchantmentdata = list.get(j);
                    if (flag) {
                        EnchantedBookItem.func_92115_a((ItemStack)enchanted, (EnchantmentData)enchantmentdata);
                        continue;
                    }
                    enchanted.func_77966_a(enchantmentdata.field_76302_b, enchantmentdata.field_76303_c);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    lapis.func_190918_g(i);
                    if (lapis.func_190926_b()) {
                        this.field_75168_e.func_70299_a(1, ItemStack.field_190927_a);
                    }
                }
                player.func_195066_a(Stats.field_188091_Y);
                if (player instanceof ServerPlayerEntity) {
                    ((EnchantedTrigger)CriteriaTriggers.field_192129_i).trigger((ServerPlayerEntity)player, enchanted, level, this.eterna.get(), this.quanta.get(), this.arcana.get());
                }
                this.field_75168_e.func_70296_d();
                this.field_178149_f.func_221494_a(player.func_175138_ci());
                this.func_75130_a(this.field_75168_e);
                world.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        });
        return true;
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.field_217006_g.func_221484_a((world, pos) -> {
            if (inventoryIn == this.field_75168_e) {
                ItemStack itemstack = inventoryIn.func_70301_a(0);
                if (itemstack.func_190916_E() == 1 && itemstack.func_77973_b().func_77616_k(itemstack) && this.isEnchantableEnough(itemstack)) {
                    this.gatherStats();
                    float power = this.eterna.get();
                    if ((double)power < 1.5) {
                        power = 1.5f;
                    }
                    this.field_75169_l.setSeed(this.field_178149_f.func_221495_b());
                    for (int num = 0; num < 3; ++num) {
                        this.field_75167_g[num] = RealEnchantmentHelper.calcSlotLevel(this.field_75169_l, num, power, itemstack);
                        this.field_185001_h[num] = -1;
                        this.field_185002_i[num] = -1;
                        if (this.field_75167_g[num] < num + 1) {
                            this.field_75167_g[num] = 0;
                        }
                        this.field_75167_g[num] = ForgeEventFactory.onEnchantmentLevelSet((World)world, (BlockPos)pos, (int)num, (int)((int)power), (ItemStack)itemstack, (int)this.field_75167_g[num]);
                    }
                    for (int j1 = 0; j1 < 3; ++j1) {
                        List<EnchantmentData> list;
                        if (this.field_75167_g[j1] <= 0 || (list = this.getEnchantmentList(itemstack, j1, this.field_75167_g[j1])) == null || list.isEmpty()) continue;
                        EnchantmentData enchantmentdata = list.get(this.field_75169_l.nextInt(list.size()));
                        this.field_185001_h[j1] = Registry.field_212628_q.func_148757_b((Object)enchantmentdata.field_76302_b);
                        this.field_185002_i[j1] = enchantmentdata.field_76303_c;
                    }
                    this.func_75142_b();
                } else {
                    for (int i = 0; i < 3; ++i) {
                        this.field_75167_g[i] = 0;
                        this.field_185001_h[i] = -1;
                        this.field_185002_i[i] = -1;
                    }
                    this.eterna.set(0.0f);
                    this.quanta.set(0.0f);
                    this.arcana.set(0.0f);
                }
            }
            return this;
        });
    }

    private List<EnchantmentData> getEnchantmentList(ItemStack stack, int enchantSlot, int level) {
        this.field_75169_l.setSeed(this.field_178149_f.func_221495_b() + enchantSlot);
        List<EnchantmentData> list = RealEnchantmentHelper.buildEnchantmentList(this.field_75169_l, stack, level, this.quanta.get(), this.arcana.get(), false);
        return list;
    }

    public void gatherStats() {
        this.field_217006_g.func_221484_a((world, pos) -> {
            Float2FloatOpenHashMap eternaMap = new Float2FloatOpenHashMap();
            float[] stats = new float[]{0.0f, 1.0f, 0.0f};
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (j == 0 && k == 0 || !world.func_175623_d(pos.func_177982_a(k, 0, j)) || !world.func_175623_d(pos.func_177982_a(k, 1, j))) continue;
                    this.gatherStats((Float2FloatMap)eternaMap, stats, (World)world, pos.func_177982_a(k * 2, 0, j * 2));
                    this.gatherStats((Float2FloatMap)eternaMap, stats, (World)world, pos.func_177982_a(k * 2, 1, j * 2));
                    if (k == 0 || j == 0) continue;
                    this.gatherStats((Float2FloatMap)eternaMap, stats, (World)world, pos.func_177982_a(k * 2, 0, j));
                    this.gatherStats((Float2FloatMap)eternaMap, stats, (World)world, pos.func_177982_a(k * 2, 1, j));
                    this.gatherStats((Float2FloatMap)eternaMap, stats, (World)world, pos.func_177982_a(k, 0, j * 2));
                    this.gatherStats((Float2FloatMap)eternaMap, stats, (World)world, pos.func_177982_a(k, 1, j * 2));
                }
            }
            ArrayList entries = new ArrayList(eternaMap.float2FloatEntrySet());
            Collections.sort(entries, Comparator.comparing(Float2FloatMap.Entry::getFloatKey));
            for (Float2FloatMap.Entry e : entries) {
                if (e.getFloatKey() > 0.0f) {
                    stats[0] = Math.min(e.getFloatKey(), stats[0] + e.getFloatValue());
                    continue;
                }
                stats[0] = stats[0] + e.getFloatValue();
            }
            this.eterna.set(stats[0]);
            this.quanta.set(stats[1]);
            this.arcana.set(stats[2]);
            return this;
        }).orElse(this);
    }

    public void gatherStats(Float2FloatMap eternaMap, float[] stats, World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockReader)world, pos)) {
            return;
        }
        float max = EnchantingStatManager.getMaxEterna(state, world, pos);
        float eterna = EnchantingStatManager.getEterna(state, world, pos);
        eternaMap.put(max, eternaMap.getOrDefault(max, 0.0f) + eterna);
        float quanta = EnchantingStatManager.getQuanta(state, world, pos);
        stats[1] = stats[1] + quanta;
        float arcana = EnchantingStatManager.getArcana(state, world, pos);
        stats[2] = stats[2] + arcana;
    }

    public ContainerType<?> func_216957_a() {
        return ApotheosisObjects.ENCHANTING;
    }

    public boolean isEnchantableEnough(ItemStack stack) {
        if (!stack.func_77948_v()) {
            return true;
        }
        return EnchantmentHelper.func_82781_a((ItemStack)stack).keySet().stream().allMatch(Enchantment::func_190936_d);
    }

    public static enum Arcana {
        EMPTY(0.0f, 10, 5, 2, 1),
        LITTLE(1.0f, 8, 5, 3, 1),
        FEW(2.0f, 7, 5, 4, 2),
        SOME(3.0f, 5, 5, 4, 2),
        LESS(4.0f, 5, 5, 4, 3),
        MEDIUM(5.0f, 5, 5, 5, 5),
        MORE(6.0f, 3, 4, 5, 5),
        VALUE(7.0f, 2, 4, 5, 5),
        EXTRA(8.0f, 2, 4, 5, 7),
        ALMOST(9.0f, 1, 3, 5, 8),
        MAX(9.9f, 1, 2, 5, 10);

        final float threshold;
        final int[] rarities;
        static Arcana[] VALUES;

        private Arcana(float threshold, int ... rarities) {
            this.threshold = threshold;
            this.rarities = rarities;
        }

        public int[] getRarities() {
            return this.rarities;
        }

        public static Arcana getForThreshold(float threshold) {
            for (int i = VALUES.length - 1; i >= 0; --i) {
                if (!(threshold >= Arcana.VALUES[i].threshold)) continue;
                return VALUES[i];
            }
            return EMPTY;
        }

        static {
            VALUES = Arcana.values();
        }
    }
}

