/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion;

import java.io.File;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolderRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;
import shadows.apotheosis.potion.LuckyFootItem;
import shadows.apotheosis.potion.PotionCharmItem;
import shadows.apotheosis.potion.PotionCharmRecipe;
import shadows.apotheosis.potion.PotionModuleClient;
import shadows.apotheosis.potion.TrueInfinityEnchant;
import shadows.apotheosis.potion.compat.CuriosCompat;
import shadows.apotheosis.potion.potions.KnowledgeEffect;
import shadows.apotheosis.potion.potions.PotionSundering;
import shadows.placebo.config.Configuration;

public class PotionModule {
    public static final Logger LOG = LogManager.getLogger((String)"Apotheosis : Potion");
    public static final ResourceLocation POTION_TEX = new ResourceLocation("apotheosis", "textures/potions.png");
    static int knowledgeMult = 4;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        this.reload(null);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().register((Object)new PotionModuleClient()));
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)Items.field_190930_cZ, (Potion)ApotheosisObjects.RESISTANCE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.RESISTANCE, (Item)Items.field_151137_ax, (Potion)ApotheosisObjects.LONG_RESISTANCE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.RESISTANCE, (Item)Items.field_151114_aO, (Potion)ApotheosisObjects.STRONG_RESISTANCE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.RESISTANCE, (Item)Items.field_151071_bq, (Potion)ApotheosisObjects.T_SUNDERING);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.LONG_RESISTANCE, (Item)Items.field_151071_bq, (Potion)ApotheosisObjects.LONG_SUNDERING);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.STRONG_RESISTANCE, (Item)Items.field_151071_bq, (Potion)ApotheosisObjects.STRONG_SUNDERING);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.T_SUNDERING, (Item)Items.field_151137_ax, (Potion)ApotheosisObjects.LONG_SUNDERING);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.T_SUNDERING, (Item)Items.field_151114_aO, (Potion)ApotheosisObjects.STRONG_SUNDERING);
        PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)Items.field_151153_ao, (Potion)ApotheosisObjects.ABSORPTION);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.ABSORPTION, (Item)Items.field_151137_ax, (Potion)ApotheosisObjects.LONG_ABSORPTION);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.ABSORPTION, (Item)Items.field_151114_aO, (Potion)ApotheosisObjects.STRONG_ABSORPTION);
        PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)Items.field_151009_A, (Potion)ApotheosisObjects.HASTE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.HASTE, (Item)Items.field_151137_ax, (Potion)ApotheosisObjects.LONG_HASTE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.HASTE, (Item)Items.field_151114_aO, (Potion)ApotheosisObjects.STRONG_HASTE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.HASTE, (Item)Items.field_151071_bq, (Potion)ApotheosisObjects.FATIGUE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.LONG_HASTE, (Item)Items.field_151071_bq, (Potion)ApotheosisObjects.LONG_FATIGUE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.STRONG_HASTE, (Item)Items.field_151071_bq, (Potion)ApotheosisObjects.STRONG_FATIGUE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.FATIGUE, (Item)Items.field_151137_ax, (Potion)ApotheosisObjects.LONG_FATIGUE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.FATIGUE, (Item)Items.field_151114_aO, (Potion)ApotheosisObjects.STRONG_FATIGUE);
        if (ApotheosisObjects.SKULL_FRAGMENT != null) {
            PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)ApotheosisObjects.SKULL_FRAGMENT, (Potion)ApotheosisObjects.WITHER);
        } else {
            PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)Items.field_196183_dw, (Potion)ApotheosisObjects.WITHER);
        }
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.WITHER, (Item)Items.field_151137_ax, (Potion)ApotheosisObjects.LONG_WITHER);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.WITHER, (Item)Items.field_151114_aO, (Potion)ApotheosisObjects.STRONG_WITHER);
        PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)Items.field_151062_by, (Potion)ApotheosisObjects.T_KNOWLEDGE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.T_KNOWLEDGE, (Item)Items.field_151137_ax, (Potion)ApotheosisObjects.LONG_KNOWLEDGE);
        PotionBrewing.func_193357_a((Potion)ApotheosisObjects.T_KNOWLEDGE, (Item)Items.field_151062_by, (Potion)ApotheosisObjects.STRONG_KNOWLEDGE);
        PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)ApotheosisObjects.LUCKY_FOOT, (Potion)Potions.field_222126_O);
        Ingredient fireRes = Apotheosis.potionIngredient(Potions.field_185241_m);
        Ingredient abs = Apotheosis.potionIngredient(ApotheosisObjects.STRONG_ABSORPTION);
        Ingredient res = Apotheosis.potionIngredient(ApotheosisObjects.RESISTANCE);
        Ingredient regen = Apotheosis.potionIngredient(Potions.field_185222_E);
        Apotheosis.HELPER.addShaped((Object)Items.field_196100_at, 3, 3, new Object[]{fireRes, regen, fireRes, abs, Items.field_151153_ao, abs, res, abs, res});
        MinecraftForge.EVENT_BUS.addListener(this::drops);
        MinecraftForge.EVENT_BUS.addListener(this::xp);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Enchantment)new TrueInfinityEnchant().setRegistryName("apotheosis", "true_infinity")));
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new LuckyFootItem().setRegistryName("apotheosis", "lucky_foot"), (Item)new PotionCharmItem().setRegistryName("apotheosis", "potion_charm")});
    }

    @SubscribeEvent
    public void types(RegistryEvent.Register<Potion> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Potion[]{(Potion)new Potion("resistance", new EffectInstance[]{new EffectInstance(Effects.field_76429_m, 3600)}).setRegistryName("apotheosis", "resistance"), (Potion)new Potion("resistance", new EffectInstance[]{new EffectInstance(Effects.field_76429_m, 9600)}).setRegistryName("apotheosis", "long_resistance"), (Potion)new Potion("resistance", new EffectInstance[]{new EffectInstance(Effects.field_76429_m, 1800, 1)}).setRegistryName("apotheosis", "strong_resistance"), (Potion)new Potion("absorption", new EffectInstance[]{new EffectInstance(Effects.field_76444_x, 1200, 1)}).setRegistryName("apotheosis", "absorption"), (Potion)new Potion("absorption", new EffectInstance[]{new EffectInstance(Effects.field_76444_x, 3600, 1)}).setRegistryName("apotheosis", "long_absorption"), (Potion)new Potion("absorption", new EffectInstance[]{new EffectInstance(Effects.field_76444_x, 600, 3)}).setRegistryName("apotheosis", "strong_absorption"), (Potion)new Potion("haste", new EffectInstance[]{new EffectInstance(Effects.field_76422_e, 3600)}).setRegistryName("apotheosis", "haste"), (Potion)new Potion("haste", new EffectInstance[]{new EffectInstance(Effects.field_76422_e, 9600)}).setRegistryName("apotheosis", "long_haste"), (Potion)new Potion("haste", new EffectInstance[]{new EffectInstance(Effects.field_76422_e, 1800, 1)}).setRegistryName("apotheosis", "strong_haste"), (Potion)new Potion("fatigue", new EffectInstance[]{new EffectInstance(Effects.field_76419_f, 3600)}).setRegistryName("apotheosis", "fatigue"), (Potion)new Potion("fatigue", new EffectInstance[]{new EffectInstance(Effects.field_76419_f, 9600)}).setRegistryName("apotheosis", "long_fatigue"), (Potion)new Potion("fatigue", new EffectInstance[]{new EffectInstance(Effects.field_76419_f, 1800, 1)}).setRegistryName("apotheosis", "strong_fatigue"), (Potion)new Potion("wither", new EffectInstance[]{new EffectInstance(Effects.field_82731_v, 3600)}).setRegistryName("apotheosis", "wither"), (Potion)new Potion("wither", new EffectInstance[]{new EffectInstance(Effects.field_82731_v, 9600)}).setRegistryName("apotheosis", "long_wither"), (Potion)new Potion("wither", new EffectInstance[]{new EffectInstance(Effects.field_82731_v, 1800, 1)}).setRegistryName("apotheosis", "strong_wither"), (Potion)new Potion("sundering", new EffectInstance[]{new EffectInstance((Effect)ApotheosisObjects.SUNDERING, 3600)}).setRegistryName("apotheosis", "sundering"), (Potion)new Potion("sundering", new EffectInstance[]{new EffectInstance((Effect)ApotheosisObjects.SUNDERING, 9600)}).setRegistryName("apotheosis", "long_sundering"), (Potion)new Potion("sundering", new EffectInstance[]{new EffectInstance((Effect)ApotheosisObjects.SUNDERING, 1800, 1)}).setRegistryName("apotheosis", "strong_sundering"), (Potion)new Potion("knowledge", new EffectInstance[]{new EffectInstance((Effect)ApotheosisObjects.P_KNOWLEDGE, 2400)}).setRegistryName("apotheosis", "knowledge"), (Potion)new Potion("knowledge", new EffectInstance[]{new EffectInstance((Effect)ApotheosisObjects.P_KNOWLEDGE, 4800)}).setRegistryName("apotheosis", "long_knowledge"), (Potion)new Potion("knowledge", new EffectInstance[]{new EffectInstance((Effect)ApotheosisObjects.P_KNOWLEDGE, 1200, 1)}).setRegistryName("apotheosis", "strong_knowledge")});
    }

    @SubscribeEvent
    public void potions(RegistryEvent.Register<Effect> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Effect)new PotionSundering().setRegistryName("apotheosis", "sundering")));
        e.getRegistry().register((IForgeRegistryEntry)((Effect)new KnowledgeEffect().setRegistryName("apotheosis", "knowledge")));
        ObjectHolderRegistry.applyObjectHolders(r -> r.func_110624_b().equals("apotheosis") && (r.func_110623_a().equals("sundering") || r.func_110623_a().equals("knowledge")));
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((IRecipeSerializer)PotionCharmRecipe.Serializer.INSTANCE.setRegistryName(ApotheosisObjects.POTION_CHARM.getRegistryName())));
    }

    @SubscribeEvent
    public void imcEvent(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.sendIMC();
        }
    }

    public void drops(LivingDropsEvent e) {
        if (e.getEntityLiving() instanceof RabbitEntity) {
            RabbitEntity rabbit = (RabbitEntity)e.getEntityLiving();
            if (rabbit.field_70170_p.field_73012_v.nextFloat() < 0.03f + 0.03f * (float)e.getLootingLevel()) {
                e.getDrops().clear();
                e.getDrops().add(new ItemEntity(rabbit.field_70170_p, rabbit.func_226277_ct_(), rabbit.func_226278_cu_(), rabbit.func_226281_cx_(), new ItemStack((IItemProvider)ApotheosisObjects.LUCKY_FOOT)));
            }
        }
    }

    public void xp(LivingExperienceDropEvent e) {
        if (e.getAttackingPlayer() != null && e.getAttackingPlayer().func_70660_b((Effect)ApotheosisObjects.P_KNOWLEDGE) != null) {
            int level = e.getAttackingPlayer().func_70660_b((Effect)ApotheosisObjects.P_KNOWLEDGE).func_76458_c() + 1;
            int curXp = e.getDroppedExperience();
            int newXp = curXp + e.getOriginalExperience() * level * knowledgeMult;
            e.setDroppedExperience(newXp);
        }
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        Configuration config = new Configuration(new File(Apotheosis.configDir, "potion.cfg"));
        knowledgeMult = config.getInt("Knowledge XP Multiplier", "general", knowledgeMult, 1, Integer.MAX_VALUE, "The strength of Ancient Knowledge.  This multiplier determines how much additional xp is granted.");
        if (e == null && config.hasChanged()) {
            config.save();
        }
    }
}

