/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import shadows.placebo.util.NetHandlerSpaghettiServer;

public class BlockUtil {
    public static boolean breakExtraBlock(ServerWorld world, BlockPos pos, ItemStack mainhand, @Nullable UUID source) {
        boolean removed;
        BlockState blockstate = world.func_180495_p(pos);
        FakePlayer player = source != null ? FakePlayerFactory.get((ServerWorld)world, (GameProfile)new GameProfile(source, UsernameCache.getLastKnownUsername((UUID)source))) : FakePlayerFactory.getMinecraft((ServerWorld)world);
        if (player.field_71135_a == null) {
            player.field_71135_a = new NetHandlerSpaghettiServer(player);
        }
        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)mainhand);
        player.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (blockstate.func_185887_b((IBlockReader)world, pos) < 0.0f || !ForgeHooks.canHarvestBlock((BlockState)blockstate, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos)) {
            return false;
        }
        GameType type = player.field_71075_bZ.field_75098_d ? GameType.CREATIVE : GameType.SURVIVAL;
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)type, (ServerPlayerEntity)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        Block block = blockstate.func_177230_c();
        if ((block instanceof CommandBlockBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.func_195070_dx()) {
            world.func_184138_a(pos, blockstate, blockstate, 3);
            return false;
        }
        if (player.func_184614_ca().onBlockStartBreak(pos, (PlayerEntity)player)) {
            return false;
        }
        if (player.func_223729_a((World)world, pos, type)) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            BlockUtil.removeBlock(world, (ServerPlayerEntity)player, pos, false);
            return true;
        }
        ItemStack itemstack = player.func_184614_ca();
        ItemStack itemstack1 = itemstack.func_77946_l();
        boolean canHarvest = blockstate.canHarvestBlock((IBlockReader)world, pos, (PlayerEntity)player);
        itemstack.func_179548_a((World)world, blockstate, pos, (PlayerEntity)player);
        if (itemstack.func_190926_b() && !itemstack1.func_190926_b()) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)itemstack1, (Hand)Hand.MAIN_HAND);
        }
        if ((removed = BlockUtil.removeBlock(world, (ServerPlayerEntity)player, pos, canHarvest)) && canHarvest) {
            block.func_180657_a((World)world, (PlayerEntity)player, pos, blockstate, tileentity, itemstack1);
        }
        if (removed && exp > 0) {
            blockstate.func_177230_c().func_180637_b(world, pos, exp);
        }
        return true;
    }

    public static boolean removeBlock(ServerWorld world, ServerPlayerEntity player, BlockPos pos, boolean canHarvest) {
        BlockState state = world.func_180495_p(pos);
        boolean removed = state.removedByPlayer((World)world, pos, (PlayerEntity)player, canHarvest, world.func_204610_c(pos));
        if (removed) {
            state.func_177230_c().func_176206_d((IWorld)world, pos, state);
        }
        return removed;
    }
}

