/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import joptsimple.internal.Strings;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.WeightedSpawnerEntity;

public class WeightedSpawnerEntityAdapter
implements JsonDeserializer<WeightedSpawnerEntity>,
JsonSerializer<WeightedSpawnerEntity> {
    public JsonElement serialize(WeightedSpawnerEntity src, Type typeOfSrc, JsonSerializationContext context) {
        String id = src.func_185277_b().func_74779_i("id");
        int weight = src.field_76292_a;
        CompoundNBT nbt = src.func_185277_b();
        JsonObject obj = new JsonObject();
        obj.addProperty("entity", id);
        obj.addProperty("weight", (Number)weight);
        if (nbt.func_186856_d() > 1) {
            obj.add("nbt", context.serialize((Object)nbt));
        }
        return obj;
    }

    public WeightedSpawnerEntity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        String id = obj.get("entity").getAsString();
        if (Strings.isNullOrEmpty((String)id)) {
            throw new JsonParseException("WeightedSpawnerEntity missing \"entity\" attribute!");
        }
        int weight = obj.get("weight").getAsInt();
        CompoundNBT nbt = new CompoundNBT();
        if (obj.has("nbt")) {
            CompoundNBT entityNbt;
            nbt = entityNbt = (CompoundNBT)context.deserialize(obj.get("nbt"), CompoundNBT.class);
        }
        nbt.func_74778_a("id", id);
        return new WeightedSpawnerEntity(weight, nbt);
    }
}

