/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import java.util.Vector;
import net.minecraft.class_1267;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.HUDOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.api.handler.EventHandler;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.util.IntPoint;

public class HUDOverlayHandler {
    private static float unclampedFlashAlpha = 0.0f;
    private static float flashAlpha = 0.0f;
    private static byte alphaDir = 1;
    private static int foodIconsOffset;
    public static int FOOD_BAR_HEIGHT;
    public static final Vector<IntPoint> healthBarOffsets;
    public static final Vector<IntPoint> foodBarOffsets;
    private static final Random random;
    private static final class_2960 modIcons;

    public static void onPreRender(class_4587 matrixStack) {
        foodIconsOffset = FOOD_BAR_HEIGHT;
        if (!ModConfig.INSTANCE.showFoodExhaustionHudUnderlay) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        int right = mc.method_22683().method_4486() / 2 + 91;
        int top = mc.method_22683().method_4502() - foodIconsOffset;
        float exhaustion = player.method_7344().method_35219();
        HUDOverlayEvent.Exhaustion renderEvent = new HUDOverlayEvent.Exhaustion(exhaustion, right, top, matrixStack);
        ((EventHandler)HUDOverlayEvent.Exhaustion.EVENT.invoker()).interact(renderEvent);
        if (!renderEvent.isCanceled) {
            HUDOverlayHandler.drawExhaustionOverlay(renderEvent, mc, 1.0f);
        }
    }

    public static void onRender(class_4587 matrixStack) {
        if (!ModConfig.INSTANCE.showFoodValuesHudOverlay && !ModConfig.INSTANCE.showSaturationHudOverlay) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_1702 stats = player.method_7344();
        int top = mc.method_22683().method_4502() - foodIconsOffset;
        int left = mc.method_22683().method_4486() / 2 - 91;
        int right = mc.method_22683().method_4486() / 2 + 91;
        HUDOverlayHandler.generateBarOffsets(top, left, right, mc.field_1705.method_1738(), (class_1657)player);
        float saturationLevel = stats.method_7589();
        HUDOverlayEvent.Saturation saturationRenderEvent = new HUDOverlayEvent.Saturation(saturationLevel, right, top, matrixStack);
        if (!ModConfig.INSTANCE.showSaturationHudOverlay) {
            saturationRenderEvent.isCanceled = true;
        }
        if (!saturationRenderEvent.isCanceled) {
            ((EventHandler)HUDOverlayEvent.Saturation.EVENT.invoker()).interact(saturationRenderEvent);
        }
        if (!saturationRenderEvent.isCanceled) {
            HUDOverlayHandler.drawSaturationOverlay(saturationRenderEvent, mc, 0.0f, 1.0f);
        }
        class_1799 heldItem = player.method_6047();
        if (ModConfig.INSTANCE.showFoodValuesHudOverlayWhenOffhand && !FoodHelper.isFood(heldItem)) {
            heldItem = player.method_6079();
        }
        if (!ModConfig.INSTANCE.showFoodValuesHudOverlay || heldItem.method_7960() || !FoodHelper.isFood(heldItem)) {
            HUDOverlayHandler.resetFlash();
            return;
        }
        int foodLevel = stats.method_7586();
        FoodValues modifiedFoodValues = FoodHelper.getModifiedFoodValues(heldItem, (class_1657)player);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent((class_1657)player, heldItem, FoodHelper.getDefaultFoodValues(heldItem), modifiedFoodValues);
        ((EventHandler)FoodValuesEvent.EVENT.invoker()).interact(foodValuesEvent);
        modifiedFoodValues = foodValuesEvent.modifiedFoodValues;
        if (HUDOverlayHandler.shouldShowEstimatedHealth(heldItem, modifiedFoodValues)) {
            float foodHealthIncrement = FoodHelper.getEstimatedHealthIncrement(heldItem, modifiedFoodValues, (class_1657)player);
            float currentHealth = player.method_6032();
            float modifiedHealth = Math.min(currentHealth + foodHealthIncrement, player.method_6063());
            HUDOverlayEvent.HealthRestored healthRenderEvent = null;
            if (currentHealth < modifiedHealth) {
                healthRenderEvent = new HUDOverlayEvent.HealthRestored(modifiedHealth, heldItem, modifiedFoodValues, left, top, matrixStack);
            }
            if (healthRenderEvent != null) {
                ((EventHandler)HUDOverlayEvent.HealthRestored.EVENT.invoker()).interact(healthRenderEvent);
            }
            if (healthRenderEvent != null && !healthRenderEvent.isCanceled) {
                HUDOverlayHandler.drawHealthOverlay(healthRenderEvent, mc, flashAlpha);
            }
        }
        HUDOverlayEvent.HungerRestored hungerRenderEvent = new HUDOverlayEvent.HungerRestored(foodLevel, heldItem, modifiedFoodValues, right, top, matrixStack);
        ((EventHandler)HUDOverlayEvent.HungerRestored.EVENT.invoker()).interact(hungerRenderEvent);
        if (hungerRenderEvent.isCanceled) {
            HUDOverlayHandler.resetFlash();
            return;
        }
        int foodHunger = modifiedFoodValues.hunger;
        float foodSaturationIncrement = modifiedFoodValues.getSaturationIncrement();
        HUDOverlayHandler.drawHungerOverlay(hungerRenderEvent, mc, foodHunger, flashAlpha, FoodHelper.isRotten(heldItem));
        int newFoodValue = stats.method_7586() + foodHunger;
        float newSaturationValue = saturationLevel + foodSaturationIncrement;
        if (!saturationRenderEvent.isCanceled) {
            float saturationGained = newSaturationValue > (float)newFoodValue ? (float)newFoodValue - saturationLevel : foodSaturationIncrement;
            HUDOverlayHandler.drawSaturationOverlay(saturationRenderEvent, mc, saturationGained, flashAlpha);
        }
    }

    public static void drawSaturationOverlay(class_4587 matrixStack, float saturationGained, float saturationLevel, class_310 mc, int right, int top, float alpha) {
        if (saturationLevel + saturationGained < 0.0f) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        RenderSystem.setShaderTexture((int)0, (class_2960)modIcons);
        float modifiedSaturation = Math.min(saturationLevel + saturationGained, 20.0f);
        int startSaturationBar = 0;
        int endSaturationBar = (int)Math.ceil(modifiedSaturation / 2.0f);
        if (saturationGained != 0.0f) {
            startSaturationBar = (int)Math.max(saturationLevel / 2.0f, 0.0f);
        }
        int iconSize = 9;
        for (int i = startSaturationBar; i < endSaturationBar; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 0;
            int u = 0;
            float effectiveSaturationOfBar = modifiedSaturation / 2.0f - (float)i;
            if (effectiveSaturationOfBar >= 1.0f) {
                u = 3 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.5) {
                u = 2 * iconSize;
            } else if ((double)effectiveSaturationOfBar > 0.25) {
                u = 1 * iconSize;
            }
            mc.field_1705.method_25302(matrixStack, x, y, u, v, iconSize, iconSize);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_22737);
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawHungerOverlay(class_4587 matrixStack, int hungerRestored, int foodLevel, class_310 mc, int right, int top, float alpha, boolean useRottenTextures) {
        if (hungerRestored == 0) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_22737);
        int modifiedFood = Math.min(20, foodLevel + hungerRestored);
        int startFoodBars = foodLevel / 2;
        int endFoodBars = (int)Math.ceil((float)modifiedFood / 2.0f);
        int iconStartOffset = 16;
        int iconSize = 9;
        for (int i = startFoodBars; i < endFoodBars; ++i) {
            IntPoint offset = foodBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 3 * iconSize;
            int u = iconStartOffset + 4 * iconSize;
            int ub = iconStartOffset + 1 * iconSize;
            if (useRottenTextures) {
                u += 4 * iconSize;
                ub += 12 * iconSize;
            }
            if (i * 2 + 1 == modifiedFood) {
                u += 1 * iconSize;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.25f));
            mc.field_1705.method_25302(matrixStack, x, y, ub, v, iconSize, iconSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            mc.field_1705.method_25302(matrixStack, x, y, u, v, iconSize, iconSize);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawHealthOverlay(class_4587 matrixStack, float health, float modifiedHealth, class_310 mc, int right, int top, float alpha) {
        if (modifiedHealth <= health) {
            return;
        }
        HUDOverlayHandler.enableAlpha(alpha);
        mc.method_1531().method_22813(class_437.field_22737);
        int fixedModifiedHealth = (int)Math.ceil(modifiedHealth);
        boolean isHardcore = mc.field_1724.field_6002 != null && mc.field_1724.field_6002.method_8401().method_152();
        int startHealthBars = (int)(Math.ceil(health) / 2.0);
        int endHealthBars = (int)Math.ceil(modifiedHealth / 2.0f);
        int iconStartOffset = 16;
        int iconSize = 9;
        for (int i = startHealthBars; i < endHealthBars; ++i) {
            IntPoint offset = healthBarOffsets.get(i);
            if (offset == null) continue;
            int x = right + offset.x;
            int y = top + offset.y;
            int v = 0 * iconSize;
            int u = iconStartOffset + 4 * iconSize;
            int ub = iconStartOffset + 1 * iconSize;
            if (i * 2 + 1 == fixedModifiedHealth) {
                u += 1 * iconSize;
            }
            if (isHardcore) {
                v = 5 * iconSize;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha * 0.25f));
            mc.field_1705.method_25302(matrixStack, x, y, ub, v, iconSize, iconSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            mc.field_1705.method_25302(matrixStack, x, y, u, v, iconSize, iconSize);
        }
        HUDOverlayHandler.disableAlpha(alpha);
    }

    public static void drawExhaustionOverlay(class_4587 matrixStack, float exhaustion, class_310 mc, int right, int top, float alpha) {
        RenderSystem.setShaderTexture((int)0, (class_2960)modIcons);
        float maxExhaustion = FoodHelper.MAX_EXHAUSTION;
        float ratio = Math.min(1.0f, Math.max(0.0f, exhaustion / maxExhaustion));
        int width = (int)(ratio * 81.0f);
        int height = 9;
        HUDOverlayHandler.enableAlpha(0.75f);
        mc.field_1705.method_25302(matrixStack, right - width, top, 81 - width, 18, width, height);
        HUDOverlayHandler.disableAlpha(0.75f);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_22737);
    }

    private static void drawSaturationOverlay(HUDOverlayEvent.Saturation event, class_310 mc, float saturationGained, float alpha) {
        HUDOverlayHandler.drawSaturationOverlay(event.matrixStack, saturationGained, event.saturationLevel, mc, event.x, event.y, alpha);
    }

    private static void drawHungerOverlay(HUDOverlayEvent.HungerRestored event, class_310 mc, int hunger, float alpha, boolean useRottenTextures) {
        HUDOverlayHandler.drawHungerOverlay(event.matrixStack, hunger, event.currentFoodLevel, mc, event.x, event.y, alpha, useRottenTextures);
    }

    private static void drawHealthOverlay(HUDOverlayEvent.HealthRestored event, class_310 mc, float alpha) {
        HUDOverlayHandler.drawHealthOverlay(event.matrixStack, mc.field_1724.method_6032(), event.modifiedHealth, mc, event.x, event.y, alpha);
    }

    private static void drawExhaustionOverlay(HUDOverlayEvent.Exhaustion event, class_310 mc, float alpha) {
        HUDOverlayHandler.drawExhaustionOverlay(event.matrixStack, event.exhaustion, mc, event.x, event.y, alpha);
    }

    private static void enableAlpha(float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }

    private static void disableAlpha(float alpha) {
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void onClientTick() {
        if ((unclampedFlashAlpha += (float)alphaDir * 0.125f) >= 1.5f) {
            alphaDir = (byte)-1;
        } else if (unclampedFlashAlpha <= -0.5f) {
            alphaDir = 1;
        }
        flashAlpha = Math.max(0.0f, Math.min(1.0f, unclampedFlashAlpha)) * Math.max(0.0f, Math.min(1.0f, ModConfig.INSTANCE.maxHudOverlayFlashAlpha));
    }

    public static void resetFlash() {
        flashAlpha = 0.0f;
        unclampedFlashAlpha = 0.0f;
        alphaDir = 1;
    }

    private static boolean shouldShowEstimatedHealth(class_1799 hoveredStack, FoodValues modifiedFoodValues) {
        if (!ModConfig.INSTANCE.showFoodHealthHudOverlay) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_1702 stats = player.method_7344();
        if (player.field_6002.method_8407() == class_1267.field_5801) {
            return false;
        }
        if (stats.method_7586() >= 18) {
            return false;
        }
        if (player.method_6059(class_1294.field_5899)) {
            return false;
        }
        if (player.method_6059(class_1294.field_5920)) {
            return false;
        }
        return !player.method_6059(class_1294.field_5924);
    }

    private static void generateBarOffsets(int top, int left, int right, int ticks, class_1657 player) {
        int i;
        int preferHealthBars = 10;
        int preferFoodBars = 10;
        float maxHealth = player.method_6063();
        float absorptionHealth = (float)Math.ceil(player.method_6067());
        int healthBars = (int)Math.ceil((maxHealth + absorptionHealth) / 2.0f);
        int healthRows = (int)Math.ceil((float)healthBars / 10.0f);
        int healthRowHeight = Math.max(10 - (healthRows - 2), 3);
        boolean shouldAnimatedHealth = false;
        boolean shouldAnimatedFood = false;
        if (ModConfig.INSTANCE.showVanillaAnimationsOverlay) {
            class_1702 hungerManager = player.method_7344();
            float saturationLevel = hungerManager.method_7589();
            int foodLevel = hungerManager.method_7586();
            shouldAnimatedFood = saturationLevel <= 0.0f && ticks % (foodLevel * 3 + 1) == 0;
            shouldAnimatedHealth = Math.ceil(player.method_6032()) <= 4.0;
        }
        random.setSeed(ticks * 312871);
        if (healthBarOffsets.size() != healthBars) {
            healthBarOffsets.setSize(healthBars);
        }
        if (foodBarOffsets.size() != 10) {
            foodBarOffsets.setSize(10);
        }
        for (i = healthBars - 1; i >= 0; --i) {
            IntPoint point;
            int row = (int)Math.ceil((float)(i + 1) / 10.0f) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * healthRowHeight;
            if (shouldAnimatedHealth) {
                y += random.nextInt(2);
            }
            if ((point = healthBarOffsets.get(i)) == null) {
                point = new IntPoint();
                healthBarOffsets.set(i, point);
            }
            point.x = x - left;
            point.y = y - top;
        }
        for (i = 0; i < 10; ++i) {
            IntPoint point;
            int x = right - i * 8 - 9;
            int y = top;
            if (shouldAnimatedFood) {
                y += random.nextInt(3) - 1;
            }
            if ((point = foodBarOffsets.get(i)) == null) {
                point = new IntPoint();
                foodBarOffsets.set(i, point);
            }
            point.x = x - right;
            point.y = y - top;
        }
    }

    static {
        FOOD_BAR_HEIGHT = 39;
        healthBarOffsets = new Vector();
        foodBarOffsets = new Vector();
        random = new Random();
        modIcons = new class_2960("appleskin", "textures/icons.png");
    }
}

