/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7417;
import net.minecraft.class_918;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.TooltipOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.api.handler.EventHandler;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.KeyHelper;

public class TooltipOverlayHandler {
    public static TooltipOverlayHandler INSTANCE;
    private static class_2960 modIcons;
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_BOTTOM = 3;
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_TOP = -3;
    public static final int TOOLTIP_REAL_WIDTH_OFFSET_RIGHT = 3;
    private static final TextureOffsets normalBarTextureOffsets;
    private static final TextureOffsets rottenBarTextureOffsets;

    public static void init() {
        INSTANCE = new TooltipOverlayHandler();
    }

    public void onItemTooltip(class_1799 hoveredStack, class_1657 player, class_1836 context, List tooltip) {
        if (hoveredStack == null || tooltip == null || ModConfig.INSTANCE == null) {
            return;
        }
        if (!this.shouldShowTooltip(hoveredStack)) {
            return;
        }
        FoodValues defaultFood = FoodHelper.getDefaultFoodValues(hoveredStack);
        FoodValues modifiedFood = FoodHelper.getModifiedFoodValues(hoveredStack, player);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent(player, hoveredStack, defaultFood, modifiedFood);
        ((EventHandler)FoodValuesEvent.EVENT.invoker()).interact(foodValuesEvent);
        defaultFood = foodValuesEvent.defaultFoodValues;
        modifiedFood = foodValuesEvent.modifiedFoodValues;
        TooltipOverlayEvent.Pre prerenderEvent = new TooltipOverlayEvent.Pre(hoveredStack, defaultFood, modifiedFood);
        ((EventHandler)TooltipOverlayEvent.Pre.EVENT.invoker()).interact(prerenderEvent);
        if (prerenderEvent.isCanceled) {
            return;
        }
        FoodOverlay foodOverlay = new FoodOverlay(prerenderEvent.itemStack, defaultFood, modifiedFood, player);
        if (foodOverlay.shouldRenderHungerBars()) {
            tooltip.add(new FoodOverlayTextComponent(foodOverlay));
        }
    }

    public void onRenderTooltip(class_4587 matrixStack, FoodOverlay foodOverlay, int toolTipX, int toolTipY, int tooltipZ, class_327 textRenderer) {
        if (matrixStack == null || ModConfig.INSTANCE == null) {
            return;
        }
        if (foodOverlay == null) {
            return;
        }
        class_1799 itemStack = foodOverlay.itemStack;
        FoodValues defaultFood = foodOverlay.defaultFood;
        FoodValues modifiedFood = foodOverlay.modifiedFood;
        int x = toolTipX;
        int y = toolTipY;
        TooltipOverlayEvent.Render renderEvent = new TooltipOverlayEvent.Render(itemStack, x, y, matrixStack, defaultFood, modifiedFood);
        ((EventHandler)TooltipOverlayEvent.Render.EVENT.invoker()).interact(renderEvent);
        if (renderEvent.isCanceled) {
            return;
        }
        x = renderEvent.x;
        y = renderEvent.y;
        itemStack = renderEvent.itemStack;
        matrixStack = renderEvent.matrixStack;
        int defaultFoodHunger = defaultFood.hunger;
        int modifiedFoodHunger = modifiedFood.hunger;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        x += (foodOverlay.hungerBars - 1) * 9;
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_22737);
        TextureOffsets offsets = FoodHelper.isRotten(itemStack) ? rottenBarTextureOffsets : normalBarTextureOffsets;
        for (int i = 0; i < foodOverlay.hungerBars * 2; i += 2) {
            if (modifiedFoodHunger < 0) {
                class_332.method_25291((class_4587)matrixStack, (int)x, (int)y, (int)tooltipZ, (float)offsets.containerNegativeHunger, (float)27.0f, (int)9, (int)9, (int)256, (int)256);
            } else if (modifiedFoodHunger > defaultFoodHunger && defaultFoodHunger <= i) {
                class_332.method_25291((class_4587)matrixStack, (int)x, (int)y, (int)tooltipZ, (float)offsets.containerExtraHunger, (float)27.0f, (int)9, (int)9, (int)256, (int)256);
            } else if (modifiedFoodHunger > i + 1 || defaultFoodHunger == modifiedFoodHunger) {
                class_332.method_25291((class_4587)matrixStack, (int)x, (int)y, (int)tooltipZ, (float)offsets.containerNormalHunger, (float)27.0f, (int)9, (int)9, (int)256, (int)256);
            } else if (modifiedFoodHunger == i + 1) {
                class_332.method_25291((class_4587)matrixStack, (int)x, (int)y, (int)tooltipZ, (float)offsets.containerPartialHunger, (float)27.0f, (int)9, (int)9, (int)256, (int)256);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                class_332.method_25291((class_4587)matrixStack, (int)x, (int)y, (int)tooltipZ, (float)offsets.containerMissingHunger, (float)27.0f, (int)9, (int)9, (int)256, (int)256);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            class_332.method_25291((class_4587)matrixStack, (int)x, (int)y, (int)tooltipZ, (float)(defaultFoodHunger - 1 == i ? (float)offsets.shankMissingPartial : (float)offsets.shankMissingFull), (float)27.0f, (int)9, (int)9, (int)256, (int)256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (modifiedFoodHunger > i) {
                class_332.method_25291((class_4587)matrixStack, (int)x, (int)y, (int)tooltipZ, (float)(modifiedFoodHunger - 1 == i ? (float)offsets.shankPartial : (float)offsets.shankFull), (float)27.0f, (int)9, (int)9, (int)256, (int)256);
            }
            x -= 9;
        }
        if (foodOverlay.hungerBarsText != null) {
            matrixStack.method_22903();
            matrixStack.method_46416((float)(x += 18), (float)y, (float)tooltipZ);
            matrixStack.method_22905(0.75f, 0.75f, 0.75f);
            textRenderer.method_1720(matrixStack, foodOverlay.hungerBarsText, 2.0f, 2.0f, -5592406);
            matrixStack.method_22909();
        }
        x = toolTipX;
        y += 10;
        float modifiedSaturationIncrement = modifiedFood.getSaturationIncrement();
        float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
        x += (foodOverlay.saturationBars - 1) * 7;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)modIcons);
        for (int i = 0; i < foodOverlay.saturationBars * 2; i += 2) {
            boolean shouldBeFaded;
            float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
            boolean bl = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
            if (shouldBeFaded) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            class_332.method_25291((class_4587)matrixStack, (int)x, (int)y, (int)tooltipZ, (float)(effectiveSaturationOfBar >= 1.0f ? 21.0f : ((double)effectiveSaturationOfBar > 0.5 ? 14.0f : ((double)effectiveSaturationOfBar > 0.25 ? 7.0f : (effectiveSaturationOfBar > 0.0f ? 0.0f : 28.0f)))), (float)(modifiedSaturationIncrement >= 0.0f ? 27.0f : 34.0f), (int)7, (int)7, (int)256, (int)256);
            if (shouldBeFaded) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            x -= 7;
        }
        if (foodOverlay.saturationBarsText != null) {
            matrixStack.method_22903();
            matrixStack.method_46416((float)(x += 14), (float)y, (float)tooltipZ);
            matrixStack.method_22905(0.75f, 0.75f, 0.75f);
            textRenderer.method_1720(matrixStack, foodOverlay.saturationBarsText, 2.0f, 1.0f, -5592406);
            matrixStack.method_22909();
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
    }

    private boolean shouldShowTooltip(class_1799 hoveredStack) {
        boolean shouldShowTooltip;
        if (hoveredStack.method_7960()) {
            return false;
        }
        boolean bl = shouldShowTooltip = ModConfig.INSTANCE.showFoodValuesInTooltip && KeyHelper.isShiftKeyDown() || ModConfig.INSTANCE.showFoodValuesInTooltipAlways;
        if (!shouldShowTooltip) {
            return false;
        }
        return FoodHelper.isFood(hoveredStack);
    }

    static {
        modIcons = new class_2960("appleskin", "textures/icons.png");
        normalBarTextureOffsets = new TextureOffsets();
        TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger = 43;
        TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger = 133;
        TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger = 16;
        TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger = 124;
        TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger = 34;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull = 70;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.normalBarTextureOffsets.shankFull = 52;
        TooltipOverlayHandler.normalBarTextureOffsets.shankPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankFull + 9;
        rottenBarTextureOffsets = new TextureOffsets();
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNegativeHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerExtraHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNormalHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerPartialHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerMissingHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull = 106;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankFull = 88;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankFull + 9;
    }

    public static class FoodOverlay
    implements class_5684,
    class_5632 {
        private FoodValues defaultFood;
        private FoodValues modifiedFood;
        private int biggestHunger;
        private float biggestSaturationIncrement;
        private int hungerBars;
        private String hungerBarsText;
        private int saturationBars;
        private String saturationBarsText;
        private class_1799 itemStack;

        FoodOverlay(class_1799 itemStack, FoodValues defaultFood, FoodValues modifiedFood, class_1657 player) {
            this.itemStack = itemStack;
            this.defaultFood = defaultFood;
            this.modifiedFood = modifiedFood;
            this.biggestHunger = Math.max(defaultFood.hunger, modifiedFood.hunger);
            this.biggestSaturationIncrement = Math.max(defaultFood.getSaturationIncrement(), modifiedFood.getSaturationIncrement());
            this.hungerBars = (int)Math.ceil((float)Math.abs(this.biggestHunger) / 2.0f);
            if (this.hungerBars > 10) {
                this.hungerBarsText = "x" + (this.biggestHunger < 0 ? -1 : 1) * this.hungerBars;
                this.hungerBars = 1;
            }
            this.saturationBars = (int)Math.ceil(Math.abs(this.biggestSaturationIncrement) / 2.0f);
            if (this.saturationBars > 10 || this.saturationBars == 0) {
                this.saturationBarsText = "x" + (this.biggestSaturationIncrement < 0.0f ? -1 : 1) * this.saturationBars;
                this.saturationBars = 1;
            }
        }

        boolean shouldRenderHungerBars() {
            return this.hungerBars > 0;
        }

        public int method_32661() {
            return 20;
        }

        public int method_32664(class_327 textRenderer) {
            int hungerBarLength = this.hungerBars * 9;
            if (this.hungerBarsText != null) {
                hungerBarLength += textRenderer.method_1727(this.hungerBarsText);
            }
            int saturationBarLength = this.saturationBars * 7;
            if (this.saturationBarsText != null) {
                saturationBarLength += textRenderer.method_1727(this.saturationBarsText);
            }
            return Math.max(hungerBarLength, saturationBarLength);
        }

        public void method_32666(class_327 textRenderer, int x, int y, class_4587 matrices, class_918 itemRenderer, int z) {
            if (INSTANCE != null) {
                INSTANCE.onRenderTooltip(matrices, this, x, y, z, textRenderer);
            }
        }
    }

    public static class FoodOverlayTextComponent
    extends EmptyText
    implements class_5481 {
        public FoodOverlay foodOverlay;

        FoodOverlayTextComponent(FoodOverlay foodOverlay) {
            this.foodOverlay = foodOverlay;
        }

        public class_5481 method_30937() {
            return this;
        }

        public boolean accept(class_5224 visitor) {
            return class_5223.method_27476((class_5348)this, (class_2583)this.method_10866(), (class_5224)visitor);
        }
    }

    static class TextureOffsets {
        int containerNegativeHunger;
        int containerExtraHunger;
        int containerNormalHunger;
        int containerPartialHunger;
        int containerMissingHunger;
        int shankMissingFull;
        int shankMissingPartial;
        int shankFull;
        int shankPartial;

        TextureOffsets() {
        }
    }

    static abstract class EmptyText
    implements class_2561 {
        static List<class_2561> emptySiblings = new ArrayList<class_2561>();

        EmptyText() {
        }

        public class_2583 method_10866() {
            return class_2583.field_24360;
        }

        public class_7417 method_10851() {
            return class_7417.field_39004;
        }

        public List<class_2561> method_10855() {
            return emptySiblings;
        }
    }
}

