/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import squeek.appleskin.network.MessageExhaustionSync;
import squeek.appleskin.network.MessageSaturationSync;

public class SyncHandler {
    private static final int PROTOCOL_VERSION = 1;
    public static final SimpleChannel CHANNEL = ChannelBuilder.named((ResourceLocation)new ResourceLocation("appleskin", "sync")).optional().acceptedVersions((status, version) -> true).networkProtocolVersion(1).simpleChannel();
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();

    public static void init() {
        CHANNEL.messageBuilder(MessageExhaustionSync.class, NetworkDirection.PLAY_TO_CLIENT).encoder(MessageExhaustionSync::encode).decoder(MessageExhaustionSync::decode).consumerNetworkThread(MessageExhaustionSync::handle).add();
        CHANNEL.messageBuilder(MessageSaturationSync.class, NetworkDirection.PLAY_TO_CLIENT).encoder(MessageSaturationSync::encode).decoder(MessageSaturationSync::decode).consumerNetworkThread(MessageSaturationSync::handle).add();
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
    }

    @SubscribeEvent
    public void onLivingTickEvent(LivingEvent.LivingTickEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Float lastSaturationLevel = lastSaturationLevels.get(player.m_20148_());
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.m_20148_());
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != player.m_36324_().m_38722_()) {
            MessageSaturationSync msg = new MessageSaturationSync(player.m_36324_().m_38722_());
            CHANNEL.send((Object)msg, PacketDistributor.PLAYER.with((Object)player));
            lastSaturationLevels.put(player.m_20148_(), Float.valueOf(player.m_36324_().m_38722_()));
        }
        float exhaustionLevel = player.m_36324_().m_150380_();
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            MessageExhaustionSync msg = new MessageExhaustionSync(exhaustionLevel);
            CHANNEL.send((Object)msg, PacketDistributor.PLAYER.with((Object)player));
            lastExhaustionLevels.put(player.m_20148_(), Float.valueOf(exhaustionLevel));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        lastSaturationLevels.remove(event.getEntity().m_20148_());
        lastExhaustionLevels.remove(event.getEntity().m_20148_());
    }
}

