/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.helpers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;

public class FoodHelper {
    public static boolean isFood(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemFood;
    }

    public static BasicFoodValues getDefaultFoodValues(ItemStack itemStack) {
        ItemFood itemFood = (ItemFood)itemStack.func_77973_b();
        int hunger = itemFood.func_150905_g(itemStack);
        float saturationModifier = itemFood.func_150906_h(itemStack);
        return new BasicFoodValues(hunger, saturationModifier);
    }

    public static BasicFoodValues getModifiedFoodValues(ItemStack itemStack, EntityPlayer player) {
        return FoodHelper.getDefaultFoodValues(itemStack);
    }

    public static class BasicFoodValues {
        public final int hunger;
        public final float saturationModifier;

        public BasicFoodValues(int hunger, float saturationModifier) {
            this.hunger = hunger;
            this.saturationModifier = saturationModifier;
        }

        public float getSaturationIncrement() {
            return (float)this.hunger * this.saturationModifier * 2.0f;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BasicFoodValues)) {
                return false;
            }
            BasicFoodValues that = (BasicFoodValues)o;
            return this.hunger == that.hunger && Float.compare(that.saturationModifier, this.saturationModifier) == 0;
        }

        public int hashCode() {
            int result = this.hunger;
            result = 31 * result + (this.saturationModifier != 0.0f ? Float.floatToIntBits(this.saturationModifier) : 0);
            return result;
        }
    }
}

