/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.blocks;

import buildcraft.api.transport.pipe.IPipeHolder;
import cofh.thermaldynamics.duct.tiles.TileDuctEnergy;
import cofh.thermaldynamics.duct.tiles.TileDuctEnergySuper;
import cofh.thermaldynamics.duct.tiles.TileDuctItem;
import com.arkifgames.hoverboardmod.main.Config;
import com.arkifgames.hoverboardmod.main.Main;
import com.arkifgames.hoverboardmod.tileentity.TileEntityMachine;
import com.arkifgames.hoverboardmod.util.Util;
import com.rwtema.extrautils2.transfernodes.BlockTransferPipe;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.conduits.conduit.TileConduitBundle;
import java.util.Collection;
import java.util.Random;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.TransmissionType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.integrateddynamics.block.BlockCable;

public abstract class BlockBaseMachine
extends BlockContainer {
    private int guiID;
    private int maxRF;
    protected boolean usesRf = true;
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    protected BlockBaseMachine(Material material, String name, int harvestLevel, int maxRF, int guiID) {
        super(material);
        this.func_149647_a(Main.TAB_HOVERBOARD);
        this.func_149711_c(4.0f);
        this.setHarvestLevel("pickaxe", harvestLevel);
        this.func_149752_b(20.0f);
        this.func_149663_c(name);
        this.setRegistryName(new ResourceLocation("hoverboardmod", name));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.maxRF = maxRF;
        this.guiID = guiID;
    }

    protected void setUsesRf(boolean usesRf) {
        this.usesRf = usesRf;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        if (this.usesRf) {
            items.add((Object)Util.setDefaultEnergyTag(new ItemStack((Block)this, 1), 0));
            items.add((Object)Util.setDefaultEnergyTag(new ItemStack((Block)this, 1), this.maxRF));
        } else {
            super.func_149666_a(itemIn, items);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (world.func_175625_s(pos) instanceof TileEntityMachine) {
            TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_175625_s(pos);
            if (itemStack.func_82837_s()) {
                tileEntityMachine.setCustomInventoryName(itemStack.func_82833_r());
            }
            if (this.usesRf && itemStack.func_77942_o()) {
                tileEntityMachine.setEnergyStored(itemStack.func_77978_p().func_74762_e("Energy"));
            }
        }
        super.func_180633_a(world, pos, state, placer, itemStack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Main.INSTANCE, (int)this.guiID, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.func_175625_s(pos) instanceof TileEntityMachine) {
            TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_175625_s(pos);
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tileEntityMachine);
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (world.func_175625_s(pos) instanceof TileEntityMachine && !player.field_71075_bZ.field_75098_d && this.canHarvestBlock((IBlockAccess)world, pos, player) && !world.field_72995_K) {
            TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_175625_s(pos);
            NBTTagCompound entityTagCompound = new NBTTagCompound();
            tileEntityMachine.func_189515_b(entityTagCompound);
            ItemStack dropBlock = new ItemStack(Item.func_150898_a((Block)this), 1);
            if (!dropBlock.func_190926_b()) {
                double d0 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                double d1 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                double d2 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
                ItemStack stackCopy = dropBlock.func_77946_l();
                EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stackCopy);
                entityItem.func_174869_p();
                if (entityTagCompound != null && !entityTagCompound.func_82582_d()) {
                    entityItem.func_92059_d().func_77982_d(entityTagCompound.func_74737_b());
                }
                world.func_72838_d((Entity)entityItem);
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityMachine) {
            TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_175625_s(pos);
            return Container.func_94526_b((IInventory)tileEntityMachine);
        }
        return 0;
    }

    protected int getComparatorInputOverrideRf(IBlockState blockState, World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityMachine) {
            TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_175625_s(pos);
            return Util.remap(0, tileEntityMachine.getMaxEnergyStored(), 0, 15, tileEntityMachine.getEnergyStored());
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumFacing = EnumFacing.func_82600_a((int)meta);
        if (enumFacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumFacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumFacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.getConnected(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.getConnected(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.getConnected(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.getConnected(worldIn, pos, EnumFacing.WEST)));
    }

    private boolean getConnected(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos offsetBlockPos = pos.func_177972_a(facing);
        Block offsetBlock = world.func_180495_p(offsetBlockPos).func_177230_c();
        TileEntity offsetTile = world.func_175625_s(offsetBlockPos);
        boolean canConnectEnergyToFace = false;
        if (world.func_175625_s(pos) instanceof TileEntityMachine) {
            canConnectEnergyToFace = ((TileEntityMachine)world.func_175625_s(pos)).canConnectEnergy(facing);
        }
        if (offsetBlock != Blocks.field_150350_a) {
            if (Config.EXTRA_UTILITIES_2_INSTALLED && offsetBlock instanceof BlockTransferPipe) {
                return true;
            }
            if (Config.INTEGRATED_TUNNELS_INSTALLED && offsetBlock instanceof BlockCable) {
                return true;
            }
        }
        if (offsetTile != null) {
            TileConduitBundle conduitBundle;
            ITransmitter transmitter;
            IPipeHolder pipeHolder;
            if (Config.BUILDCRAFT_INSTALLED && offsetTile instanceof IPipeHolder && (pipeHolder = (IPipeHolder)offsetTile).getPipe() != null && pipeHolder.getPipe().isConnected(facing.func_176734_d())) {
                return true;
            }
            if (Config.MEKANISM_INSTALLED && offsetTile instanceof ITransmitter && ((transmitter = (ITransmitter)offsetTile).getTransmissionType() == TransmissionType.ENERGY && canConnectEnergyToFace || transmitter.getTransmissionType() == TransmissionType.ITEM)) {
                return true;
            }
            if (Config.THERMAL_DYNAMICS_INSTALLED && (offsetTile instanceof TileDuctItem || offsetTile instanceof TileDuctEnergy && canConnectEnergyToFace || offsetTile instanceof TileDuctEnergySuper && canConnectEnergyToFace)) {
                return true;
            }
            if (Config.ENDER_IO_INSTALLED && offsetTile instanceof TileConduitBundle && (conduitBundle = (TileConduitBundle)offsetTile).getConnectors().size() > 0) {
                Collection list = conduitBundle.getConduits();
                for (IConduit iterable_element : list) {
                    if (!iterable_element.isConnectedTo(facing.func_176734_d())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, NORTH, EAST, SOUTH, WEST});
    }
}

