/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.gui;

import com.arkifgames.hoverboardmod.client.gui.GuiCheckbox;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardScreen;
import com.arkifgames.hoverboardmod.client.gui.GuiSlider;
import com.arkifgames.hoverboardmod.client.gui.inventory.ButtonData;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketColor;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketDataSync;
import com.arkifgames.hoverboardmod.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;

public class GuiHoverboardColor
extends GuiHoverboardScreen {
    private GuiCheckbox staticColor;

    public GuiHoverboardColor(EntityHoverboard hoverboard, GuiContainer guiHoverboard, ArrayList<GuiHoverboardScreen> hoverboardGuis) {
        super(hoverboard, guiHoverboard, hoverboardGuis);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float f, int x, int y, List buttonList, int guiLeft, int guiTop) {
        if (this.showControls) {
            int left = -114;
            int top = 20;
            int spacing = 25;
            int width = 104;
            int height = 20;
            this.staticColor = new GuiCheckbox(ButtonData.COLOR_STATIC.value, guiLeft + left, guiTop + top, I18n.func_135052_a((String)"container.hoverboard.color.static", (Object[])new Object[0]), this.hoverboard.getStaticColorMode());
            buttonList.add(this.staticColor);
            GuiSlider hue = new GuiSlider(ButtonData.COLOR_HUE.value, guiLeft + left, guiTop + (top += spacing), width, height, I18n.func_135052_a((String)"container.hoverboard.color.hue", (Object[])new Object[0]), "", 0.0f, 1.0f, Util.roundFloat(this.hoverboard.getColorHue(), 2), true, true);
            hue.field_146124_l = this.hoverboard.getStaticColorMode();
            buttonList.add(hue);
            GuiSlider brightness = new GuiSlider(ButtonData.COLOR_BRIGHTNESS.value, guiLeft + left, guiTop + (top += spacing), width, height, I18n.func_135052_a((String)"container.hoverboard.color.brightness", (Object[])new Object[0]), "", 0.0f, 1.0f, Util.round(this.hoverboard.getColorBrightness(), 2), true, true);
            brightness.field_146124_l = this.hoverboard.getStaticColorMode();
            buttonList.add(brightness);
            GuiSlider saturation = new GuiSlider(ButtonData.COLOR_SATURATION.value, guiLeft + left, guiTop + (top += spacing), width, height, I18n.func_135052_a((String)"container.hoverboard.color.saturation", (Object[])new Object[0]), "", 0.0f, 1.0f, Util.round(this.hoverboard.getColorSaturation(), 2), true, true);
            saturation.field_146124_l = this.hoverboard.getStaticColorMode();
            buttonList.add(saturation);
            this.showControls = false;
            this.controlsList = buttonList;
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(int x, int y, FontRenderer fontRendererObj) {
        if (this.show) {
            int left = -116;
            fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.color.title", (Object[])new Object[0]), left, 6, 0);
        }
    }

    @Override
    public void initGui(List buttonList, int guiLeft, int guiTop) {
        buttonList.add(new GuiButton(ButtonData.COLOR.value, guiLeft + 89, guiTop - 20, 50, 20, I18n.func_135052_a((String)"container.hoverboard.button.color", (Object[])new Object[0])));
    }

    @Override
    public void actionPerformed(GuiButton button) {
        if (button.field_146127_k == ButtonData.COLOR.value) {
            if (!this.show) {
                this.show = true;
                this.showControls = true;
            } else {
                this.show = false;
                this.showControls = false;
            }
            this.ShowGui(false);
            this.guiHoverboard.func_73866_w_();
        } else if (button.field_146127_k == ButtonData.COLOR_STATIC.value) {
            GuiCheckbox checkbox = (GuiCheckbox)button;
            ButtonData buttonData = ButtonData.GetValue(checkbox.field_146127_k);
            PacketDispatcher.sendToServer(new PacketDataSync(Minecraft.func_71410_x().field_71439_g.func_145782_y(), this.hoverboard.func_145782_y(), buttonData.hoverboardOptions, checkbox.isChecked()));
            for (int i = 0; i < this.controlsList.size(); ++i) {
                if (!(this.controlsList.get(i) instanceof GuiSlider)) continue;
                GuiSlider slider = (GuiSlider)((Object)this.controlsList.get(i));
                slider.field_146124_l = checkbox.isChecked();
            }
        } else if (button instanceof GuiSlider) {
            GuiSlider slider = (GuiSlider)button;
            PacketDispatcher.sendToServer(new PacketColor(Minecraft.func_71410_x().field_71439_g.func_145782_y(), this.hoverboard.func_145782_y(), slider.field_146127_k, (float)slider.getValue()));
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.show && this.hoverboard.getStaticColorMode()) {
            for (int i = 0; i < this.controlsList.size(); ++i) {
                if (!(this.controlsList.get(i) instanceof GuiSlider)) continue;
                GuiSlider slider = (GuiSlider)((Object)this.controlsList.get(i));
                if (mouseX <= slider.field_146128_h || mouseX >= slider.field_146128_h + slider.field_146120_f || mouseY <= slider.field_146129_i || mouseY >= slider.field_146129_i + slider.field_146121_g) continue;
                PacketDispatcher.sendToServer(new PacketColor(Minecraft.func_71410_x().field_71439_g.func_145782_y(), this.hoverboard.func_145782_y(), slider.field_146127_k, (float)slider.getValue()));
            }
        }
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.show && this.hoverboard.getStaticColorMode()) {
            for (int i = 0; i < this.controlsList.size(); ++i) {
                if (!(this.controlsList.get(i) instanceof GuiSlider)) continue;
                GuiSlider slider = (GuiSlider)((Object)this.controlsList.get(i));
                PacketDispatcher.sendToServer(new PacketColor(Minecraft.func_71410_x().field_71439_g.func_145782_y(), this.hoverboard.func_145782_y(), slider.field_146127_k, (float)slider.getValue()));
            }
        }
    }

    @Override
    public void setChecked(int options, byte add) {
        if (options == ButtonData.COLOR_STATIC.hoverboardOptions.value) {
            this.staticColor.setIsChecked(add == 1);
            for (int i = 0; i < this.controlsList.size(); ++i) {
                if (!(this.controlsList.get(i) instanceof GuiSlider)) continue;
                GuiSlider slider = (GuiSlider)((Object)this.controlsList.get(i));
                slider.field_146124_l = this.staticColor.isChecked();
            }
        }
    }

    @Override
    public void setSliderValue(int sliderId, float sliderValue) {
        if (this.show && this.hoverboard.getStaticColorMode()) {
            for (int i = 0; i < this.controlsList.size(); ++i) {
                if (!(this.controlsList.get(i) instanceof GuiSlider)) continue;
                GuiSlider slider = (GuiSlider)((Object)this.controlsList.get(i));
                if (slider.field_146127_k != sliderId) continue;
                slider.setValue(sliderValue);
                slider.updateSlider();
            }
        }
    }
}

