/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.gui;

import com.arkifgames.hoverboardmod.client.gui.GuiButtonArrow;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardScreen;
import com.arkifgames.hoverboardmod.client.gui.inventory.ButtonData;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardUpgrades;
import com.arkifgames.hoverboardmod.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;

public class GuiHoverboardInformation
extends GuiHoverboardScreen {
    private static int spacingTitle = 14;
    private static int spacingUnderTitle = 12;
    private static int spacing = 10;
    private static int colour = 0x232323;
    private static int colourTitle = 0;
    private static byte INFO_PAGE_MAX = (byte)2;
    private static byte INFO_PAGE_MIN = 1;
    private byte infoPageNumber = 1;

    public GuiHoverboardInformation(EntityHoverboard hoverboard, GuiContainer guiHoverboard, ArrayList<GuiHoverboardScreen> hoverboardGuis) {
        super(hoverboard, guiHoverboard, hoverboardGuis);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float f, int x, int y, List buttonList, int guiLeft, int guiTop) {
        if (this.showControls) {
            buttonList.add(new GuiButtonArrow(ButtonData.PAGE_INFO_MINUS.value, guiLeft - 116, guiTop + 6, "", true, 0));
            buttonList.add(new GuiButtonArrow(ButtonData.PAGE_INFO_ADD.value, guiLeft - 16, guiTop + 6, "", false, 0));
            this.showControls = false;
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(int x, int y, FontRenderer fontRendererObj) {
        if (this.show) {
            int top = 6;
            int leftTitle = -116;
            int left = -114;
            fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.title", (Object[])new Object[]{this.infoPageNumber}), -95, top, colourTitle);
            if (this.infoPageNumber == 1) {
                String name;
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.general.title", (Object[])new Object[0]), leftTitle, top += spacingTitle, colourTitle);
                String string = name = this.hoverboard.getOwnerEntity() != null ? this.hoverboard.getOwnerEntity().func_70005_c_() : I18n.func_135052_a((String)"container.owner.unknown", (Object[])new Object[0]);
                while (fontRendererObj.func_78256_a(name) > 66) {
                    if (fontRendererObj.func_78256_a(name = name.substring(0, name.length() - 1)) > 66) continue;
                    name = name + "...";
                    break;
                }
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.general.owner", (Object[])new Object[]{name}), left, top += spacingUnderTitle, colour);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.general.power", (Object[])new Object[]{this.hoverboard.getCurrentPower(), this.hoverboard.getMaxPower()}), left, top += spacing, colour);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.general.heat", (Object[])new Object[]{this.hoverboard.getCurrentHeat(), 50000}), left, top += spacing, colour);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.general.efficiency", (Object[])new Object[]{Float.valueOf(Util.round(this.hoverboard.getEfficiency(), 1))}), left, top += spacing, colour);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.general.health", (Object[])new Object[]{Float.valueOf(Util.round(this.hoverboard.func_110143_aJ(), 1)), Float.valueOf(this.hoverboard.func_110138_aP())}), left, top += spacing, colour);
                if (this.hoverboard.hasUpgrade(HoverboardUpgrades.rocket)) {
                    fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.general.rockets", (Object[])new Object[]{this.hoverboard.getCurrentRockets(), 256}), left, top += spacing, colour);
                    boolean flag = false;
                    if (this.hoverboard.isBeingRiddenByPlayer()) {
                        flag = this.hoverboard.getPlayerRiding().field_71075_bZ.field_75098_d;
                    }
                    fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.general.rocketsToShoot", (Object[])new Object[]{this.hoverboard.getCurrentRocketsToShoot()}), left, top += spacing, this.hoverboard.getCurrentRocketsToShoot() > this.hoverboard.getCurrentRockets() ? (flag ? colour : 13116195) : colour);
                }
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.averages.title", (Object[])new Object[0]), leftTitle, top += spacingTitle, colourTitle);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.averages.power", (Object[])new Object[]{Float.valueOf(Util.round(this.hoverboard.powerUsageAverage, 1))}), left, top += spacingUnderTitle, colour);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.averages.heat", (Object[])new Object[]{Float.valueOf(Util.round(this.hoverboard.heatGeneratedAverage, 1))}), left, top += spacing, colour);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.status.title", (Object[])new Object[0]), leftTitle, top += spacingTitle, colourTitle);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.status.heat", (Object[])new Object[]{this.hoverboard.getStatusHeat()}), left, top += spacingUnderTitle, colour);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.status.boost", (Object[])new Object[]{this.hoverboard.getStatusBoost()}), left, top += spacing, colour);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.status.rocket", (Object[])new Object[]{this.hoverboard.getStatusRocket()}), left, top += spacing, colour);
            } else if (this.infoPageNumber == 2) {
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.upgrades.title", (Object[])new Object[0]), leftTitle, top += spacingTitle, colourTitle);
                fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.information.upgrades.installed", (Object[])new Object[0]) + " " + this.hoverboard.getAllUpgrades().size() + "/" + HoverboardUpgrades.values().length, left, top += spacingTitle, colour);
                top += spacingUnderTitle;
                for (int i = 0; i < this.hoverboard.getAllUpgrades().size(); ++i) {
                    fontRendererObj.func_78276_b(this.hoverboard.getAllUpgrades().get(i).getName(), -110, top, colour);
                    top += spacing;
                }
            }
        }
    }

    @Override
    public void initGui(List buttonList, int guiLeft, int guiTop) {
        buttonList.add(new GuiButton(ButtonData.INFORMATION.value, guiLeft + 53, guiTop - 20, 37, 20, I18n.func_135052_a((String)"container.hoverboard.button.info", (Object[])new Object[0])));
    }

    @Override
    public void actionPerformed(GuiButton button) {
        if (button.field_146127_k == ButtonData.INFORMATION.value) {
            if (!this.show) {
                this.show = true;
                this.showControls = true;
            } else {
                this.show = false;
                this.showControls = false;
            }
            this.ShowGui(false);
            this.guiHoverboard.func_73866_w_();
        } else if (button.field_146127_k == ButtonData.PAGE_INFO_MINUS.value) {
            this.infoPageNumber = this.infoPageNumber > INFO_PAGE_MIN ? (byte)(this.infoPageNumber - 1) : INFO_PAGE_MAX;
        } else if (button.field_146127_k == ButtonData.PAGE_INFO_ADD.value) {
            this.infoPageNumber = this.infoPageNumber < INFO_PAGE_MAX ? (byte)(this.infoPageNumber + 1) : INFO_PAGE_MIN;
        }
    }
}

