/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.gui;

import com.arkifgames.hoverboardmod.client.gui.GuiButtonArrow;
import com.arkifgames.hoverboardmod.client.gui.GuiCheckbox;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardScreen;
import com.arkifgames.hoverboardmod.client.gui.inventory.ButtonData;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardUpgrades;
import com.arkifgames.hoverboardmod.main.Config;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketDataSync;
import com.arkifgames.hoverboardmod.network.server.PacketGuiRocket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;

public class GuiHoverboardOptions
extends GuiHoverboardScreen {
    public GuiHoverboardOptions(EntityHoverboard hoverboard, GuiContainer guiHoverboard, ArrayList<GuiHoverboardScreen> hoverboardGuis) {
        super(hoverboard, guiHoverboard, hoverboardGuis);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float f, int x, int y, List buttonList, int guiLeft, int guiTop) {
        if (this.showControls) {
            int left = -114;
            int top = 20;
            int spacing = 15;
            GuiCheckbox hoverMode = new GuiCheckbox(ButtonData.OPTIONS_HOVER_MODE.value, guiLeft + left, guiTop + top, I18n.func_135052_a((String)"container.hoverboard.options.hoverMode", (Object[])new Object[0]), this.hoverboard.getHoverMode());
            buttonList.add(hoverMode);
            GuiCheckbox caveLight = new GuiCheckbox(ButtonData.OPTIONS_CAVE_LIGHT.value, guiLeft + left, guiTop + (top += spacing), I18n.func_135052_a((String)"container.hoverboard.options.caveLight", (Object[])new Object[0]), this.hoverboard.getLightSource());
            caveLight.field_146124_l = Config.ALLOW_LIGHT_SOURCE && this.hoverboard.hasUpgrade(HoverboardUpgrades.light);
            buttonList.add(caveLight);
            GuiCheckbox collectItems = new GuiCheckbox(ButtonData.OPTIONS_COLLECT_ITEMS.value, guiLeft + left, guiTop + (top += spacing), I18n.func_135052_a((String)"container.hoverboard.options.collectItems", (Object[])new Object[0]), this.hoverboard.getCollectItems());
            collectItems.field_146124_l = Config.ALLOW_COLLECT_ITEMS && this.hoverboard.hasUpgrade(HoverboardUpgrades.item_collection);
            buttonList.add(collectItems);
            GuiCheckbox shield = new GuiCheckbox(ButtonData.OPTIONS_SHIELD.value, guiLeft + left, guiTop + (top += spacing), I18n.func_135052_a((String)"container.hoverboard.options.shield", (Object[])new Object[0]), this.hoverboard.getShield());
            shield.field_146124_l = Config.ALLOW_SHIELD && this.hoverboard.hasUpgrade(HoverboardUpgrades.shield);
            buttonList.add(shield);
            GuiCheckbox miningMode = new GuiCheckbox(ButtonData.OPTIONS_MINING_MODE.value, guiLeft + left, guiTop + (top += spacing), I18n.func_135052_a((String)"container.hoverboard.options.miningMode", (Object[])new Object[0]), this.hoverboard.getMiningMode());
            miningMode.field_146124_l = Config.ALLOW_MINING && this.hoverboard.hasUpgrade(HoverboardUpgrades.mining);
            buttonList.add(miningMode);
            buttonList.add(new GuiCheckbox(ButtonData.OPTIONS_PARTICLES.value, guiLeft + left, guiTop + (top += spacing), I18n.func_135052_a((String)"container.hoverboard.options.particles", (Object[])new Object[0]), this.hoverboard.getDisplayParticles()));
            buttonList.add(new GuiButtonArrow(ButtonData.ROCKETS_MINUS.value, guiLeft + left - 1, guiTop + 179, "", true, 1));
            buttonList.add(new GuiButtonArrow(ButtonData.ROCKETS_ADD.value, guiLeft - 20, guiTop + 179, "", false, 1));
            top = 130;
            GuiCheckbox privateStorage = new GuiCheckbox(ButtonData.OPTIONS_OWNER_STORAGE.value, guiLeft + left, guiTop + top, I18n.func_135052_a((String)"container.hoverboard.options.owner.storage", (Object[])new Object[0]), this.hoverboard.getPrivateStorage());
            GuiCheckbox privatePilot = new GuiCheckbox(ButtonData.OPTIONS_OWNER_PILOT.value, guiLeft + left, guiTop + (top += spacing), I18n.func_135052_a((String)"container.hoverboard.options.owner.pilot", (Object[])new Object[0]), this.hoverboard.getPrivatePilot());
            GuiCheckbox privateDock = new GuiCheckbox(ButtonData.OPTIONS_OWNER_DOCK.value, guiLeft + left, guiTop + (top += spacing), I18n.func_135052_a((String)"container.hoverboard.options.owner.dock", (Object[])new Object[0]), this.hoverboard.getPrivateDock());
            if (this.hoverboard.getOwnerUUID() == null || !Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId().equals(this.hoverboard.getOwnerUUID())) {
                privateStorage.field_146124_l = false;
                privatePilot.field_146124_l = false;
                privateDock.field_146124_l = false;
            }
            buttonList.add(privateStorage);
            buttonList.add(privatePilot);
            buttonList.add(privateDock);
            this.showControls = false;
            this.controlsList = buttonList;
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(int x, int y, FontRenderer fontRendererObj) {
        if (this.show) {
            int left = -116;
            fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.options.title", (Object[])new Object[0]), left, 6, 0);
            boolean flag = false;
            if (this.hoverboard.hasUpgrade(HoverboardUpgrades.rocket) && this.hoverboard.isBeingRiddenByPlayer()) {
                flag = this.hoverboard.getPlayerRiding().field_71075_bZ.field_75098_d;
            }
            fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.options.rockets", (Object[])new Object[]{this.hoverboard.getCurrentRocketsToShoot()}), -102, 181, this.hoverboard.getCurrentRocketsToShoot() > this.hoverboard.getCurrentRockets() ? (flag ? 0x232323 : 13116195) : 0x232323);
            fontRendererObj.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.options.owner.title", (Object[])new Object[0]), left, 116, 0);
        }
    }

    @Override
    public void initGui(List buttonList, int guiLeft, int guiTop) {
        buttonList.add(new GuiButton(ButtonData.OPTIONS.value, guiLeft + 3, guiTop - 20, 50, 20, I18n.func_135052_a((String)"container.hoverboard.button.options", (Object[])new Object[0])));
    }

    @Override
    public void actionPerformed(GuiButton button) {
        if (button.field_146127_k == ButtonData.OPTIONS.value) {
            if (!this.show) {
                this.show = true;
                this.showControls = true;
            } else {
                this.show = false;
                this.showControls = false;
            }
            this.ShowGui(false);
            this.guiHoverboard.func_73866_w_();
        } else if (button.field_146127_k == ButtonData.ROCKETS_MINUS.value) {
            PacketDispatcher.sendToServer(new PacketGuiRocket(false, this.hoverboard.func_145782_y()));
        } else if (button.field_146127_k == ButtonData.ROCKETS_ADD.value) {
            PacketDispatcher.sendToServer(new PacketGuiRocket(true, this.hoverboard.func_145782_y()));
        } else if (button.field_146127_k == ButtonData.OPTIONS_PARTICLES.value) {
            GuiCheckbox checkbox = (GuiCheckbox)button;
            this.hoverboard.setDisplayParticles(checkbox.isChecked());
        } else if (button instanceof GuiCheckbox) {
            GuiCheckbox checkbox = (GuiCheckbox)button;
            ButtonData buttonData = ButtonData.GetValue(checkbox.field_146127_k);
            PacketDispatcher.sendToServer(new PacketDataSync(Minecraft.func_71410_x().field_71439_g.func_145782_y(), this.hoverboard.func_145782_y(), buttonData.hoverboardOptions, checkbox.isChecked()));
        }
    }

    @Override
    public void setChecked(int options, byte add) {
        for (ButtonData buttonData : ButtonData.values()) {
            if (buttonData.hoverboardOptions == null || buttonData.hoverboardOptions.value != options || this.controlsList == null) continue;
            for (Object object : this.controlsList) {
                if (!(object instanceof GuiCheckbox)) continue;
                GuiCheckbox checkbox = (GuiCheckbox)((Object)object);
                if (checkbox.field_146127_k != buttonData.value) continue;
                checkbox.setIsChecked(add == 1);
            }
        }
    }
}

