/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.gui.inventory;

import com.arkifgames.hoverboardmod.hoverboard.HoverboardOptions;

public enum ButtonData {
    OPTIONS(0),
    INFORMATION(1),
    COLOR(2),
    ROCKETS_ADD(10),
    ROCKETS_MINUS(11),
    PAGE_INFO_MINUS(12),
    PAGE_INFO_ADD(13),
    PAGE_STORAGE_ADD(14),
    PAGE_STORAGE_MINUS(15),
    OPTIONS_HOVER_MODE(20, HoverboardOptions.hoverMode),
    OPTIONS_COLLECT_ITEMS(21, HoverboardOptions.canCollectItems),
    OPTIONS_CAVE_LIGHT(22, HoverboardOptions.lightSource),
    OPTIONS_MINING_MODE(23, HoverboardOptions.miningMode),
    OPTIONS_SHIELD(24, HoverboardOptions.shield),
    OPTIONS_PARTICLES(25, HoverboardOptions.displayParticles),
    OPTIONS_OWNER_STORAGE(30, HoverboardOptions.privateStorage),
    OPTIONS_OWNER_PILOT(31, HoverboardOptions.privatePilot),
    OPTIONS_OWNER_DOCK(32, HoverboardOptions.privateDock),
    COLOR_STATIC(40, HoverboardOptions.colorMode),
    COLOR_HUE(41),
    COLOR_BRIGHTNESS(42),
    COLOR_SATURATION(43);

    public int value;
    public HoverboardOptions hoverboardOptions;

    private ButtonData(int value) {
        this.value = value;
    }

    private ButtonData(int value, HoverboardOptions hoverboardOptions) {
        this.value = value;
        this.hoverboardOptions = hoverboardOptions;
    }

    public boolean Compare(int i) {
        return this.value == i;
    }

    public static ButtonData GetValue(int value) {
        ButtonData[] buttonDatas = ButtonData.values();
        for (int i = 0; i < buttonDatas.length; ++i) {
            if (!buttonDatas[i].Compare(value)) continue;
            return buttonDatas[i];
        }
        return null;
    }
}

