/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.gui.inventory;

import com.arkifgames.hoverboardmod.client.gui.GuiButtonArrow;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardColor;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardInformation;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardOptions;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardScreen;
import com.arkifgames.hoverboardmod.client.gui.inventory.ButtonData;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardUpgrades;
import com.arkifgames.hoverboardmod.inventory.ContainerHoverboard;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import com.arkifgames.hoverboardmod.network.server.PacketHoverboardInventory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiHoverboard
extends GuiContainer {
    private static final long DEGREES_PER_SECOND = 20L;
    private static final long NANO_SECONDS_PER_SECOND = 1000000000L;
    private static final ResourceLocation TEXTURE_MAIN = new ResourceLocation("hoverboardmod", "textures/gui/hoverboard_main.png");
    private static final ResourceLocation TEXTURE_EXTRA = new ResourceLocation("hoverboardmod", "textures/gui/hoverboard_extra.png");
    private static byte STORAGE_PAGE_MAX = (byte)9;
    private static byte STORAGE_PAGE_MIN = 1;
    private float yaw;
    private float roll;
    private boolean rollDown;
    private float rotationAngle;
    private EntityHoverboard hoverboard;
    private byte storagePageNumber = 1;
    private ArrayList<GuiHoverboardScreen> hoverboardGuis = new ArrayList();

    public GuiHoverboard(InventoryPlayer invPlayer, EntityHoverboard entityHoverboard, World world) {
        super((Container)new ContainerHoverboard(invPlayer, entityHoverboard));
        this.hoverboard = entityHoverboard;
        this.field_146999_f = 176;
        this.field_147000_g = 202;
        this.hoverboardGuis.add(new GuiHoverboardInformation(this.hoverboard, this, this.hoverboardGuis));
        this.hoverboardGuis.add(new GuiHoverboardOptions(this.hoverboard, this, this.hoverboardGuis));
        this.hoverboardGuis.add(new GuiHoverboardColor(this.hoverboard, this, this.hoverboardGuis));
    }

    public void func_73863_a(int x, int y, float f) {
        this.func_146276_q_();
        super.func_73863_a(x, y, f);
        this.func_191948_b(x, y);
        if (x >= this.field_147003_i + 30 && y >= this.field_147009_r + 66 && x <= this.field_147003_i + 73 && y <= this.field_147009_r + 81) {
            this.func_146283_a(Collections.singletonList(I18n.func_135052_a((String)"container.hoverboard.hover.power", (Object[])new Object[]{this.hoverboard.getCurrentPower(), this.hoverboard.getMaxPower()})), x, y);
        }
        if (this.hoverboard.hasUpgrade(HoverboardUpgrades.rocket)) {
            String text2 = this.hoverboard.getCurrentRockets() + "/" + 256 + " Rockets";
            if (x >= this.field_147003_i + 30 && y >= this.field_147009_r + 89 && x <= this.field_147003_i + 73 && y <= this.field_147009_r + 105) {
                this.func_146283_a(Collections.singletonList(text2), x, y);
            }
        }
    }

    protected void func_146976_a(float f, int x, int y) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i < this.hoverboardGuis.size(); ++i) {
            if (this.hoverboardGuis.get((int)i).show) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_EXTRA);
                this.func_73729_b(this.field_147003_i - 122, this.field_147009_r, 0, 0, 120, this.field_147000_g);
            }
            this.hoverboardGuis.get(i).drawGuiContainerBackgroundLayer(f, x, y, this.field_146292_n, this.field_147003_i, this.field_147009_r);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_MAIN);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.hoverboard.hasPower()) {
            i = this.hoverboard.getCurrentPower() * 44 / this.hoverboard.getMaxPower();
            this.func_73729_b(this.field_147003_i + 30, this.field_147009_r + 66, 176, 0, i, 16);
        }
        if (this.hoverboard.hasUpgrade(HoverboardUpgrades.rocket)) {
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + 88, 176, 32, 68, 18);
            i = this.hoverboard.getCurrentRockets() * 44 / 256;
            this.func_73729_b(this.field_147003_i + 30, this.field_147009_r + 89, 176, 16, i, 16);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_EXTRA);
        if (this.hoverboard.func_70301_a(0).func_190926_b()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 66, 160, 0, 16, 16);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.hoverboard.hasUpgrade(HoverboardUpgrades.rocket) && this.hoverboard.func_70301_a(1) == ItemStack.field_190927_a) {
            this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 89, 176, 0, 16, 16);
        }
        this.drawHoverboard(this, 40, 34);
    }

    protected void func_146979_b(int x, int y) {
        if (this.hoverboard.hasUpgrade(HoverboardUpgrades.storage)) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.storage", (Object[])new Object[0]) + " " + this.storagePageNumber, 99, 6, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.storage", (Object[])new Object[0]), 79, 6, 0x404040);
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 7, 109, 0x404040);
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).drawGuiContainerForegroundLayer(x, y, this.field_146289_q);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).initGui(this.field_146292_n, this.field_147003_i, this.field_147009_r);
        }
        if (this.hoverboard.hasUpgrade(HoverboardUpgrades.storage)) {
            this.field_146292_n.add(new GuiButtonArrow(ButtonData.PAGE_STORAGE_MINUS.value, this.field_147003_i + 84, this.field_147009_r + 6, "", true, 0));
            this.field_146292_n.add(new GuiButtonArrow(ButtonData.PAGE_STORAGE_ADD.value, this.field_147003_i + 156, this.field_147009_r + 6, "", false, 0));
        }
    }

    protected void func_146284_a(GuiButton button) {
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).actionPerformed(button);
        }
        if (button.field_146127_k == ButtonData.PAGE_STORAGE_MINUS.value) {
            this.storagePageNumber = this.storagePageNumber > STORAGE_PAGE_MIN ? (byte)(this.storagePageNumber - 1) : STORAGE_PAGE_MAX;
            PacketDispatcher.sendToServer(new PacketHoverboardInventory(this.storagePageNumber, this.hoverboard.func_145782_y()));
        } else if (button.field_146127_k == ButtonData.PAGE_STORAGE_ADD.value && this.storagePageNumber < STORAGE_PAGE_MAX) {
            this.storagePageNumber = (byte)(this.storagePageNumber + 1);
            PacketDispatcher.sendToServer(new PacketHoverboardInventory(this.storagePageNumber, this.hoverboard.func_145782_y()));
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    public void drawHoverboard(GuiHoverboard gui, int x, int y) {
        float prevRotationAngle = this.rotationAngle;
        float scale = 25.0f;
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.field_147003_i + x), (float)(gui.field_147009_r + y), (float)100.0f);
        GlStateManager.func_179152_a((float)-25.0f, (float)25.0f, (float)25.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)this.roll, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.65f, (float)0.65f, (float)0.65f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.45f, (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(false);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)this.hoverboard, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        long now = System.nanoTime();
        this.rotationAngle = 20L * (now - 1L) / 1000000000L;
        if (prevRotationAngle < this.rotationAngle) {
            this.yaw += 2.0f;
            if (this.rollDown) {
                this.roll -= 0.2f;
                if (this.roll < -5.0f) {
                    this.rollDown = false;
                    this.roll = -5.0f;
                }
            } else {
                this.roll += 0.2f;
                if (this.roll > 25.0f) {
                    this.rollDown = true;
                    this.roll = 25.0f;
                }
            }
        }
    }

    public void setChecked(int option, byte add) {
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).setChecked(option, add);
        }
    }

    public void setSliderValue(int sliderId, float sliderValue) {
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).setSliderValue(sliderId, sliderValue);
        }
    }

    public static ResourceLocation getTexture() {
        return TEXTURE_MAIN;
    }

    public static ResourceLocation getTextureExtra() {
        return TEXTURE_EXTRA;
    }
}

