/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.gui.inventory;

import com.arkifgames.hoverboardmod.client.gui.GuiButtonArrow;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardColor;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardInformation;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardOptions;
import com.arkifgames.hoverboardmod.client.gui.GuiHoverboardScreen;
import com.arkifgames.hoverboardmod.client.gui.inventory.ButtonData;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.inventory.ContainerHoverboardStorage;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import com.arkifgames.hoverboardmod.network.server.PacketHoverboardInventory;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiHoverboardStorage
extends GuiContainer {
    private static final ResourceLocation TEXTURE_MAIN = new ResourceLocation("hoverboardmod", "textures/gui/hoverboard_storage.png");
    private static final ResourceLocation TEXTURE_EXTRA = new ResourceLocation("hoverboardmod", "textures/gui/hoverboard_extra.png");
    private static byte STORAGE_PAGE_MAX = (byte)9;
    private static byte STORAGE_PAGE_MIN = 1;
    private EntityHoverboard hoverboard;
    private byte storagePageNumber = 1;
    private ArrayList<GuiHoverboardScreen> hoverboardGuis = new ArrayList();

    public GuiHoverboardStorage(InventoryPlayer invPlayer, EntityHoverboard entityHoverboard, byte storagePageNumber) {
        super((Container)new ContainerHoverboardStorage(invPlayer, entityHoverboard, storagePageNumber));
        this.field_146999_f = 176;
        this.field_147000_g = 202;
        this.hoverboard = entityHoverboard;
        this.storagePageNumber = storagePageNumber;
        this.hoverboardGuis.add(new GuiHoverboardInformation(this.hoverboard, this, this.hoverboardGuis));
        this.hoverboardGuis.add(new GuiHoverboardOptions(this.hoverboard, this, this.hoverboardGuis));
        this.hoverboardGuis.add(new GuiHoverboardColor(this.hoverboard, this, this.hoverboardGuis));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            if (this.hoverboardGuis.get((int)i).show) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_EXTRA);
                this.func_73729_b(this.field_147003_i - 122, this.field_147009_r, 0, 0, 120, this.field_147000_g);
            }
            this.hoverboardGuis.get(i).drawGuiContainerBackgroundLayer(f, x, y, this.field_146292_n, this.field_147003_i, this.field_147009_r);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_MAIN);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int x, int y) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.hoverboard.storage", (Object[])new Object[0]) + " " + this.storagePageNumber, 99, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 7, 109, 0x404040);
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).drawGuiContainerForegroundLayer(x, y, this.field_146289_q);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).initGui(this.field_146292_n, this.field_147003_i, this.field_147009_r);
        }
        this.field_146292_n.add(new GuiButtonArrow(ButtonData.PAGE_STORAGE_MINUS.value, this.field_147003_i + 84, this.field_147009_r + 6, "", true, 0));
        this.field_146292_n.add(new GuiButtonArrow(ButtonData.PAGE_STORAGE_ADD.value, this.field_147003_i + 156, this.field_147009_r + 6, "", false, 0));
    }

    protected void func_146284_a(GuiButton button) {
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).actionPerformed(button);
        }
        if (button.field_146127_k == ButtonData.PAGE_STORAGE_MINUS.value) {
            if (this.storagePageNumber > STORAGE_PAGE_MIN) {
                this.storagePageNumber = (byte)(this.storagePageNumber - 1);
                PacketDispatcher.sendToServer(new PacketHoverboardInventory(this.storagePageNumber, this.hoverboard.func_145782_y()));
            }
        } else if (button.field_146127_k == ButtonData.PAGE_STORAGE_ADD.value) {
            this.storagePageNumber = this.storagePageNumber < STORAGE_PAGE_MAX ? (byte)(this.storagePageNumber + 1) : STORAGE_PAGE_MIN;
            PacketDispatcher.sendToServer(new PacketHoverboardInventory(this.storagePageNumber, this.hoverboard.func_145782_y()));
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.hoverboardGuis.size(); ++i) {
            this.hoverboardGuis.get(i).mouseClicked(mouseX, mouseY, mouseButton);
        }
    }
}

