/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.model;

import com.arkifgames.hoverboardmod.client.model.ModelHoverboardBase;
import net.minecraft.util.ResourceLocation;

public class TexturedModel {
    public static final ResourceLocation TEXTURE_CHEST_CARBON = new ResourceLocation("hoverboardmod", "textures/models/chest_carbon.png");
    public static final ResourceLocation TEXTURE_MINING = new ResourceLocation("hoverboardmod", "textures/models/upgrade_mining.png");
    public static final ResourceLocation TEXTURE_UPGRADE_THRUSTER = new ResourceLocation("hoverboardmod", "textures/models/upgrade_thruster.png");
    public static final ResourceLocation TEXTURE_ROCKETS = new ResourceLocation("hoverboardmod", "textures/models/upgrade_rockets.png");
    public static final ResourceLocation TEXTURE_UPGRADE_SHEILD = new ResourceLocation("hoverboardmod", "textures/models/upgrade_shield.png");
    public static final ResourceLocation TEXTURE_HOVERBOARD_BASE = new ResourceLocation("hoverboardmod", "textures/models/hoverboard_base.png");
    public static final ResourceLocation TEXTURE_HOVERBOARD_BASE_VARIANT = new ResourceLocation("hoverboardmod", "textures/models/hoverboard_base_variant.png");
    public static final ResourceLocation TEXTURE_VENTS = new ResourceLocation("hoverboardmod", "textures/models/hoverboard_vents.png");
    public static final ResourceLocation TEXTURE_BOTTOM_THRUSTERS = new ResourceLocation("hoverboardmod", "textures/models/hoverboard_bottom_thrusters.png");
    private ResourceLocation texture;
    private ModelHoverboardBase model;
    private ResourceLocation[] textures;
    private int updateTexturesTicks;
    private int textureIndex = 0;
    private int ticks = 0;
    private boolean shouldColourCycle;
    private boolean shouldRenderPass;

    public TexturedModel(ModelHoverboardBase model, ResourceLocation texture, boolean shouldColourCycle, boolean shouldRenderPass) {
        this.texture = texture;
        this.model = model;
        this.shouldColourCycle = shouldColourCycle;
        this.shouldRenderPass = shouldRenderPass;
    }

    public TexturedModel(ModelHoverboardBase model, int updateTexturesTicks, boolean shouldColourCycle, boolean shouldRenderPass, ResourceLocation ... textures) {
        this.model = model;
        this.textures = textures;
        this.updateTexturesTicks = updateTexturesTicks;
        this.shouldColourCycle = shouldColourCycle;
        this.shouldRenderPass = shouldRenderPass;
    }

    public TexturedModel(ModelHoverboardBase model, int updateTexturesTicks, boolean shouldColourCycle, boolean shouldRenderPass, String texturePathName, byte numberOfTextures) {
        this.model = model;
        this.updateTexturesTicks = updateTexturesTicks;
        this.shouldColourCycle = shouldColourCycle;
        this.shouldRenderPass = shouldRenderPass;
        this.textures = new ResourceLocation[numberOfTextures];
        for (int i = 0; i < numberOfTextures; ++i) {
            StringBuilder stringBuilder = new StringBuilder("textures/models/hoverboard/");
            stringBuilder.append(texturePathName);
            stringBuilder.append('/');
            if (i < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(i);
            stringBuilder.append(".png");
            this.textures[i] = new ResourceLocation("hoverboardmod", stringBuilder.toString());
        }
    }

    public void onUpdate() {
        if (this.texture == null) {
            ++this.ticks;
            if (this.ticks >= this.updateTexturesTicks) {
                this.textureIndex = this.textureIndex < this.textures.length - 1 ? ++this.textureIndex : 0;
                this.ticks = 0;
            }
        }
    }

    public ResourceLocation getTexture() {
        if (this.texture != null) {
            return this.texture;
        }
        return this.textures[this.textureIndex];
    }

    public ModelHoverboardBase getModel() {
        return this.model;
    }

    public boolean shouldColourCycle() {
        return this.shouldColourCycle;
    }

    public boolean shouldRenderPass() {
        return this.shouldRenderPass;
    }
}

