/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.plugins.jei;

import com.arkifgames.hoverboardmod.blocks.HoverboardModBlocks;
import com.arkifgames.hoverboardmod.client.gui.inventory.GuiBuilder;
import com.arkifgames.hoverboardmod.client.gui.inventory.GuiMeltSpinner;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.BuilderRecipeCategory;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.BuilderRecipeChecker;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.ShapedOreRecipeBuilderWrapper;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.ShapedRecipesBuilderWrapper;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.ShapelessRecipeBuilderWrapper;
import com.arkifgames.hoverboardmod.client.plugins.jei.spinner.MeltSpinnerCategory;
import com.arkifgames.hoverboardmod.client.plugins.jei.spinner.SpinnerRecipeMaker;
import com.arkifgames.hoverboardmod.crafting.builder.ShapedOreRecipeBuilder;
import com.arkifgames.hoverboardmod.crafting.builder.ShapedRecipesBuilder;
import com.arkifgames.hoverboardmod.crafting.builder.ShapelessOreRecipeBuilder;
import com.arkifgames.hoverboardmod.crafting.builder.ShapelessRecipesBuilder;
import com.arkifgames.hoverboardmod.inventory.ContainerMeltSpinner;
import com.arkifgames.hoverboardmod.items.HoverboardModItems;
import mezz.jei.Internal;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.gui.GuiHelper;
import mezz.jei.runtime.JeiHelpers;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class HoverboardJEI
implements IModPlugin {
    public static final String BUILDER = "hoverboardmod.hoverboardBuilder";
    public static final String MELT_SPINNER = "hoverboardmod.meltSpinner";

    public void registerCategories(IRecipeCategoryRegistration registry) {
        JeiHelpers jeiHelpers = Internal.getHelpers();
        GuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new BuilderRecipeCategory((IGuiHelper)guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MeltSpinnerCategory((IGuiHelper)guiHelper)});
    }

    public void register(IModRegistry registry) {
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        blacklist.addIngredientToBlacklist((Object)new ItemStack(HoverboardModItems.hoverboard_capacity_upgrade));
        registry.addIngredientInfo((Object)new ItemStack(HoverboardModItems.aerogel), VanillaTypes.ITEM, new String[]{"info.hoverboardmod.aerogel"});
        registry.addRecipes(BuilderRecipeChecker.getValidRecipes(jeiHelpers), BUILDER);
        registry.addRecipes(SpinnerRecipeMaker.getFurnaceRecipes(jeiHelpers), MELT_SPINNER);
        registry.handleRecipes(ShapedOreRecipeBuilder.class, recipe -> new ShapedOreRecipeBuilderWrapper(jeiHelpers, (ShapedOreRecipeBuilder)recipe), BUILDER);
        registry.handleRecipes(ShapedRecipesBuilder.class, recipe -> new ShapedRecipesBuilderWrapper(jeiHelpers, (ShapedRecipesBuilder)recipe), BUILDER);
        registry.handleRecipes(ShapelessOreRecipeBuilder.class, recipe -> new ShapelessRecipeBuilderWrapper<ShapelessOreRecipeBuilder>(jeiHelpers, (ShapelessOreRecipeBuilder)recipe), BUILDER);
        registry.handleRecipes(ShapelessRecipesBuilder.class, recipe -> new ShapelessRecipeBuilderWrapper<ShapelessRecipesBuilder>(jeiHelpers, (ShapelessRecipesBuilder)recipe), BUILDER);
        registry.addRecipeClickArea(GuiBuilder.class, 88, 45, 22, 16, new String[]{BUILDER});
        registry.addRecipeClickArea(GuiMeltSpinner.class, 59, 40, 22, 16, new String[]{MELT_SPINNER});
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(ContainerMeltSpinner.class, MELT_SPINNER, 0, 1, 4, 36);
        registry.addRecipeCatalyst((Object)new ItemStack(HoverboardModBlocks.builder), new String[]{BUILDER});
        registry.addRecipeCatalyst((Object)new ItemStack(HoverboardModBlocks.melt_spinner), new String[]{MELT_SPINNER});
    }
}

