/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.plugins.jei.builder;

import com.arkifgames.hoverboardmod.blocks.HoverboardModBlocks;
import com.arkifgames.hoverboardmod.client.gui.inventory.GuiBuilder;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.BuilderRecipeDataCache;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.BuilderRecipeDisplayData;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.CraftingGridLargeHelper;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.ShapedRecipesBuilderWrapper;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.ShapelessRecipeBuilderWrapper;
import com.arkifgames.hoverboardmod.crafting.builder.BuilderRecipes;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class BuilderRecipeCategory
implements IRecipeCategory<IRecipeWrapper> {
    private static final int craftOutputSlot = 16;
    private static final int craftInputSlot1 = 0;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private final ICraftingGridHelper craftingGridHelper;
    protected final IDrawableAnimated arrow;
    protected final IDrawableAnimated rf;
    protected IGuiHelper guiHelper;

    public BuilderRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.background = guiHelper.createDrawable(GuiBuilder.getTexture(), 7, 17, 162, 72);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(HoverboardModBlocks.builder));
        this.localizedName = Translator.translateToLocal((String)"gui.jei.category.hoverboardBuilder");
        this.craftingGridHelper = new CraftingGridLargeHelper(0, 16);
        this.arrow = guiHelper.drawableBuilder(GuiBuilder.getTexture(), 192, 0, 22, 16).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.rf = guiHelper.drawableBuilder(GuiBuilder.getTexture(), 176, 0, 16, 70).buildAnimated(200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public String getUid() {
        return "hoverboardmod.hoverboardBuilder";
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Arkif's Hoverboard Mod";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 81, 28);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        ICraftingRecipeWrapper craftingRecipeWrapper;
        ResourceLocation registryName;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int index = 0 + x + y * 4;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        guiItemStacks.init(16, false, 116, 27);
        if (recipeWrapper instanceof ICustomCraftingRecipeWrapper) {
            ICustomCraftingRecipeWrapper customWrapper = (ICustomCraftingRecipeWrapper)recipeWrapper;
            customWrapper.setRecipe(recipeLayout, ingredients);
            return;
        }
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (recipeWrapper instanceof IShapedCraftingRecipeWrapper) {
            IShapedCraftingRecipeWrapper wrapper = (IShapedCraftingRecipeWrapper)recipeWrapper;
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(16, (List)outputs.get(0));
        if (recipeWrapper instanceof ICraftingRecipeWrapper && (registryName = (craftingRecipeWrapper = (ICraftingRecipeWrapper)recipeWrapper).getRegistryName()) != null) {
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 16) {
                    boolean showAdvanced;
                    String modName;
                    String recipeModId = registryName.func_110624_b();
                    boolean modIdDifferent = false;
                    ResourceLocation itemRegistryName = ingredient.func_77973_b().getRegistryName();
                    if (itemRegistryName != null) {
                        String itemModId = itemRegistryName.func_110624_b();
                        boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                    }
                    if (modIdDifferent && (modName = ForgeModIdHelper.getInstance().getFormattedModNameForModId(recipeModId)) != null) {
                        tooltip.add(TextFormatting.GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName}));
                    }
                    boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n();
                    if (showAdvanced) {
                        tooltip.add(TextFormatting.DARK_GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.id", (Object[])new Object[]{registryName.toString()}));
                    }
                }
            });
        }
        if (recipeWrapper instanceof ShapedRecipesBuilderWrapper) {
            BuilderRecipeDisplayData displayData = BuilderRecipeDataCache.getDisplayData((ShapelessRecipeBuilderWrapper)recipeWrapper);
            displayData.setCurrentIngredients(guiItemStacks.getGuiIngredients());
            ItemStack stack = (ItemStack)((IGuiIngredient)guiItemStacks.getGuiIngredients().get(guiItemStacks.getGuiIngredients().size() - 1)).getDisplayedIngredient();
            int time = BuilderRecipes.getInstance().getBuildTime(stack.func_77973_b(), stack.func_77952_i());
            displayData.setTimeToCraft(time / 20);
            displayData.setEnergy(48 * time);
            int i = displayData.getEnergy() * 70 / 262144;
            displayData.setRf((IDrawable)this.guiHelper.createDrawable(GuiBuilder.getTexture(), 176, 70 - i, 16, 70));
        }
    }
}

