/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.plugins.jei.builder;

import com.arkifgames.hoverboardmod.client.plugins.jei.builder.ShapedOreRecipeBuilderWrapper;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.ShapedRecipesBuilderWrapper;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.ShapelessRecipeBuilderWrapper;
import com.arkifgames.hoverboardmod.crafting.builder.BuilderRecipes;
import com.arkifgames.hoverboardmod.crafting.builder.IRecipeBuilder;
import com.arkifgames.hoverboardmod.crafting.builder.ShapedOreRecipeBuilder;
import com.arkifgames.hoverboardmod.crafting.builder.ShapedRecipesBuilder;
import com.arkifgames.hoverboardmod.crafting.builder.ShapelessOreRecipeBuilder;
import com.arkifgames.hoverboardmod.crafting.builder.ShapelessRecipesBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.oredict.OreIngredient;

public final class BuilderRecipeChecker {
    private BuilderRecipeChecker() {
    }

    public static List<IRecipeBuilder> getValidRecipes(IJeiHelpers jeiHelpers) {
        CraftingRecipeValidator<ShapedOreRecipeBuilder> shapedOreRecipeValidator = new CraftingRecipeValidator<ShapedOreRecipeBuilder>(recipe -> new ShapedOreRecipeBuilderWrapper(jeiHelpers, (ShapedOreRecipeBuilder)recipe));
        CraftingRecipeValidator<ShapedRecipesBuilder> shapedRecipesValidator = new CraftingRecipeValidator<ShapedRecipesBuilder>(recipe -> new ShapedRecipesBuilderWrapper(jeiHelpers, (ShapedRecipesBuilder)recipe));
        CraftingRecipeValidator<ShapelessOreRecipeBuilder> shapelessOreRecipeValidator = new CraftingRecipeValidator<ShapelessOreRecipeBuilder>(recipe -> new ShapelessRecipeBuilderWrapper<ShapelessOreRecipeBuilder>(jeiHelpers, (ShapelessOreRecipeBuilder)recipe));
        CraftingRecipeValidator<ShapelessRecipesBuilder> shapelessRecipesValidator = new CraftingRecipeValidator<ShapelessRecipesBuilder>(recipe -> new ShapelessRecipeBuilderWrapper<ShapelessRecipesBuilder>(jeiHelpers, (ShapelessRecipesBuilder)recipe));
        StackHelper stackHelper = Internal.getStackHelper();
        Iterator recipeIterator = BuilderRecipes.getInstance().getRecipeList().iterator();
        ArrayList<IRecipeBuilder> validRecipes = new ArrayList<IRecipeBuilder>();
        while (recipeIterator.hasNext()) {
            IRecipeBuilder recipe2 = (IRecipeBuilder)recipeIterator.next();
            if (recipe2 instanceof ShapedOreRecipeBuilder) {
                if (!shapedOreRecipeValidator.isRecipeValid((ShapedOreRecipeBuilder)recipe2, stackHelper)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            if (recipe2 instanceof ShapedRecipesBuilder) {
                if (!shapedRecipesValidator.isRecipeValid((ShapedRecipesBuilder)recipe2, stackHelper)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            if (recipe2 instanceof ShapelessOreRecipeBuilder) {
                if (!shapelessOreRecipeValidator.isRecipeValid((ShapelessOreRecipeBuilder)recipe2, stackHelper)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            if (recipe2 instanceof ShapelessRecipesBuilder) {
                if (!shapelessRecipesValidator.isRecipeValid((ShapelessRecipesBuilder)recipe2, stackHelper)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            validRecipes.add(recipe2);
        }
        return validRecipes;
    }

    private static final class CraftingRecipeValidator<T extends IRecipeBuilder> {
        private static final int INVALID_COUNT = -1;
        private static final int CANT_DISPLAY = -2;
        private final IRecipeWrapperFactory<T> recipeWrapperFactory;

        public CraftingRecipeValidator(IRecipeWrapperFactory<T> recipeWrapperFactory) {
            this.recipeWrapperFactory = recipeWrapperFactory;
        }

        public boolean isRecipeValid(T recipe, StackHelper stackHelper) {
            ItemStack recipeOutput = recipe.getRecipeOutput();
            if (recipeOutput == null || recipeOutput.func_190926_b()) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().error("Recipe has no output. {}", (Object)recipeInfo);
                return false;
            }
            List ingredients = recipe.getIngredients();
            if (ingredients == null || ingredients.isEmpty()) {
                return false;
            }
            int inputCount = CraftingRecipeValidator.getInputCount(ingredients, stackHelper);
            if (inputCount == -2) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().warn("Recipe contains ingredients that can't be understood or displayed by JEI: {}", (Object)recipeInfo);
                return false;
            }
            if (inputCount == -1) {
                return false;
            }
            if (inputCount > 16) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().error("Recipe has too many inputs. {}", (Object)recipeInfo);
                return false;
            }
            if (inputCount == 0) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().error("Recipe has no inputs. {}", (Object)recipeInfo);
                return false;
            }
            return true;
        }

        private String getInfo(T recipe) {
            IRecipeWrapper recipeWrapper = this.recipeWrapperFactory.getRecipeWrapper(recipe);
            return ErrorUtil.getInfoFromRecipe(recipe, (IRecipeWrapper)recipeWrapper);
        }

        protected static int getInputCount(List<ItemStack> ingredientList, StackHelper stackHelper) {
            int inputCount = 0;
            Ingredient test = Ingredient.func_193369_a((ItemStack[])((ItemStack[])ingredientList.toArray()));
            List input = stackHelper.getMatchingStacks(test);
            if (input == null) {
                return -1;
            }
            if (test instanceof OreIngredient && input.isEmpty()) {
                return -1;
            }
            if (!test.isSimple() && input.isEmpty()) {
                return -2;
            }
            return ++inputCount;
        }
    }
}

