/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.plugins.jei.builder;

import java.util.List;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import net.minecraft.item.ItemStack;

public class CraftingGridLargeHelper
implements ICraftingGridHelper {
    private final int craftInputSlot1;
    private final int craftOutputSlot;

    public CraftingGridLargeHelper(int craftInputSlot1, int craftOutputSlot) {
        this.craftInputSlot1 = craftInputSlot1;
        this.craftOutputSlot = craftOutputSlot;
    }

    public <T> void setInputs(IGuiIngredientGroup<T> ingredientGroup, List<List<T>> inputs) {
        int width;
        int height;
        if (inputs.size() > 4) {
            height = 3;
            width = 3;
        } else if (inputs.size() > 1) {
            height = 2;
            width = 2;
        } else if (inputs.size() > 9) {
            height = 4;
            width = 4;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputs(ingredientGroup, inputs, width, height);
    }

    public <T> void setInputs(IGuiIngredientGroup<T> ingredientGroup, List<List<T>> inputs, int width, int height) {
        for (int i = 0; i < inputs.size(); ++i) {
            List<T> recipeItem = inputs.get(i);
            int index = this.getCraftingIndex(i, width, height);
            this.setInput(ingredientGroup, index, recipeItem);
        }
    }

    private <T> void setInput(IGuiIngredientGroup<T> guiIngredients, int inputIndex, List<T> input) {
        guiIngredients.set(this.craftInputSlot1 + inputIndex, input);
    }

    @Deprecated
    public void setInputStacks(IGuiItemStackGroup guiItemStacks, List<List<ItemStack>> input) {
        int width;
        int height;
        if (input.size() > 4) {
            height = 3;
            width = 3;
        } else if (input.size() > 1) {
            height = 2;
            width = 2;
        } else if (input.size() > 9) {
            height = 4;
            width = 4;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputStacks(guiItemStacks, input, width, height);
    }

    @Deprecated
    public void setInputStacks(IGuiItemStackGroup guiItemStacks, List<List<ItemStack>> input, int width, int height) {
        for (int i = 0; i < input.size(); ++i) {
            List<ItemStack> recipeItem = input.get(i);
            int index = this.getCraftingIndex(i, width, height);
            this.setInput((IGuiIngredientGroup)guiItemStacks, index, (List)recipeItem);
        }
    }

    private int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 4 + 0 : (height == 2 ? i * 4 + 0 : 4);
        } else if (height == 1) {
            index = i + 4;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                index += 2;
                if (i > 3) {
                    index += 2;
                }
            }
        } else if (width == 3 && height == 3) {
            index = i;
            if (i > 2) {
                ++index;
                if (i > 5) {
                    ++index;
                }
            }
        } else {
            index = i;
        }
        return index;
    }

    public void setOutput(IGuiItemStackGroup guiItemStacks, List<ItemStack> output) {
        guiItemStacks.set(this.craftOutputSlot, output);
    }
}

