/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.plugins.jei.builder;

import com.arkifgames.hoverboardmod.client.plugins.jei.builder.BuilderRecipeDataCache;
import com.arkifgames.hoverboardmod.client.plugins.jei.builder.BuilderRecipeDisplayData;
import com.arkifgames.hoverboardmod.crafting.builder.BuilderRecipes;
import com.arkifgames.hoverboardmod.crafting.builder.IRecipeBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.recipes.BrokenCraftingRecipeException;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ShapelessRecipeBuilderWrapper<T extends IRecipeBuilder>
implements ICraftingRecipeWrapper {
    private final IJeiHelpers jeiHelpers;
    protected final T recipe;

    public ShapelessRecipeBuilderWrapper(IJeiHelpers jeiHelpers, T recipe) {
        this.jeiHelpers = jeiHelpers;
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ItemStack recipeOutput = this.recipe.getRecipeOutput();
        IStackHelper stackHelper = this.jeiHelpers.getStackHelper();
        try {
            List inputLists = stackHelper.expandRecipeItemStackInputs(this.recipe.getIngredients());
            ingredients.setInputLists(VanillaTypes.ITEM, inputLists);
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipeOutput);
        }
        catch (RuntimeException e) {
            String info = ErrorUtil.getInfoFromBrokenCraftingRecipe(this.recipe, (List)this.recipe.getIngredients(), (ItemStack)recipeOutput);
            throw new BrokenCraftingRecipeException(info, (Throwable)e);
        }
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipe.getRegistryName();
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mouseX > 144 && mouseX < 161 && mouseY > 0 && mouseY < 146) {
            BuilderRecipeDisplayData data = BuilderRecipeDataCache.getDisplayData(this);
            tooltip.add(I18n.func_135052_a((String)"gui.jei.category.machine.energy", (Object[])new Object[]{data.getEnergy()}));
        }
        return tooltip;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int time;
        BuilderRecipeDisplayData data = BuilderRecipeDataCache.getDisplayData(this);
        Map<Integer, ? extends IGuiIngredient<ItemStack>> currentIngredients = data.getCurrentIngredients();
        if (currentIngredients == null) {
            return;
        }
        if (data.getOutputStack() == null) {
            data.setOutputStack((ItemStack)currentIngredients.get(currentIngredients.size() - 1).getDisplayedIngredient());
        }
        if (data.getTimeToCraft() == 0 && data.getOutputStack() != null) {
            data.setTimeToCraft(BuilderRecipes.getInstance().getBuildTime(data.getOutputStack().func_77973_b(), data.getOutputStack().func_77952_i()) / 20);
        }
        if (data.getRf() != null) {
            int i = data.getEnergy() * 70 / 262144;
            data.getRf().draw(minecraft, 145, 71 - i);
        }
        if ((time = data.getTimeToCraft()) != 0) {
            String text = time + "s";
            int width = minecraft.field_71466_p.func_78256_a(text);
            int x = recipeWidth - 70 - width / 2;
            int y = 49;
            if (minecraft.field_71466_p.func_82883_a()) {
                Gui.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + width + 2), (int)(y + 10), (int)-16777216);
                Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)(y + 9), (int)-589505316);
            }
            minecraft.field_71466_p.func_78276_b(text, x, y, Color.gray.getRGB());
        }
    }
}

