/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.plugins.jei.spinner;

import com.arkifgames.hoverboardmod.crafting.MeltSpinnerRecipes;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;

public class SpinnerRecipe
implements IRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;

    public SpinnerRecipe(List<ItemStack> inputs, ItemStack output) {
        this.inputs = Collections.singletonList(inputs);
        this.output = output;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        MeltSpinnerRecipes meltSpinnerRecipes = MeltSpinnerRecipes.instance();
        float experience = meltSpinnerRecipes.getSpinningExperience(this.output);
        if (experience > 0.0f) {
            String experienceString = Translator.translateToLocalFormatted((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_78276_b(experienceString, recipeWidth - stringWidth - 18, 26, Color.gray.getRGB());
        }
    }
}

