/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.renderer.entity;

import com.arkifgames.hoverboardmod.client.model.TexturedModel;
import com.arkifgames.hoverboardmod.client.renderer.entity.layers.LayerHoverboardLights;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardUpgrades;
import com.arkifgames.hoverboardmod.main.Config;
import com.arkifgames.hoverboardmod.proxy.ClientProxy;
import com.arkifgames.hoverboardmod.tileentity.TileEntityHoverboardCharger;
import com.google.common.collect.Lists;
import java.nio.FloatBuffer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHoverboard
extends Render<EntityHoverboard> {
    private static final ResourceLocation GUARDIAN_BEAM_TEXTURE = new ResourceLocation("hoverboardmod", "textures/models/hoverboard_charger_beam.png");
    private static ResourceLocation TEXTURE_SHIELD = new ResourceLocation("hoverboardmod", "textures/models/shield.png");
    private static int[] CHARGER_BEAM_COLOUR = new int[]{255, 0, 0, 255};
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DynamicTexture TEXTURE_BRIGHTNESS = new DynamicTexture(16, 16);
    private FloatBuffer brightnessBuffer = GLAllocation.func_74529_h((int)4);
    public List<LayerRenderer<EntityHoverboard>> layerRenderers = Lists.newArrayList();
    protected boolean renderMarker;
    public static float NAME_TAG_RANGE = 64.0f;
    public static float NAME_TAG_RANGE_SNEAK = 32.0f;
    private float rotationYawHead;
    private float renderYawOffset;
    private float rotationYawDelta;
    private float rotationYawDeltaWrapped;
    private float rotationPitchDelta;

    public RenderHoverboard(RenderManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.5f;
        this.layerRenderers.add(new LayerHoverboardLights(this));
    }

    protected float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    public void doRender(EntityHoverboard entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.calculateRenderData(entity);
        this.renderSphereShield(entity, x, y, z, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        boolean shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        for (TexturedModel texturedModel : entity.getModels()) {
            texturedModel.getModel().field_78095_p = this.getSwingProgress(entity, partialTicks);
            texturedModel.getModel().field_78093_q = shouldSit;
            texturedModel.getModel().field_78091_s = entity.func_70631_g_();
        }
        for (TexturedModel texturedModel : entity.getModelsRenderPass()) {
            texturedModel.getModel().field_78095_p = this.getSwingProgress(entity, partialTicks);
            texturedModel.getModel().field_78093_q = shouldSit;
            texturedModel.getModel().field_78091_s = entity.func_70631_g_();
        }
        try {
            this.renderYawOffset = this.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, partialTicks);
            this.rotationYawHead = this.interpolateRotation(entity.field_70758_at, entity.field_70759_as, partialTicks);
            this.rotationYawDelta = this.rotationYawHead - this.renderYawOffset;
            if (shouldSit && entity.func_184187_bx() instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity.func_184187_bx();
                this.renderYawOffset = this.interpolateRotation(entitylivingbase.field_70760_ar, entitylivingbase.field_70761_aq, partialTicks);
                this.rotationYawDelta = this.rotationYawHead - this.renderYawOffset;
                this.rotationYawDeltaWrapped = MathHelper.func_76142_g((float)this.rotationYawDelta);
                if (this.rotationYawDeltaWrapped < -85.0f) {
                    this.rotationYawDeltaWrapped = -85.0f;
                }
                if (this.rotationYawDeltaWrapped >= 85.0f) {
                    this.rotationYawDeltaWrapped = 85.0f;
                }
                this.renderYawOffset = this.rotationYawHead - this.rotationYawDeltaWrapped;
                if (this.rotationYawDeltaWrapped * this.rotationYawDeltaWrapped > 2500.0f) {
                    this.renderYawOffset += this.rotationYawDeltaWrapped * 0.2f;
                }
                this.rotationYawDelta = this.rotationYawHead - this.renderYawOffset;
            }
            this.rotationPitchDelta = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            this.renderLivingAt(entity, x, y, z);
            float f8 = this.handleRotationFloat(entity, partialTicks);
            this.applyRotations(entity, f8, this.renderYawOffset, partialTicks);
            float f4 = this.prepareScale(entity, partialTicks);
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (!entity.func_184218_aH()) {
                f5 = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * partialTicks;
                f6 = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
                if (entity.func_70631_g_()) {
                    f6 *= 3.0f;
                }
                if (f5 > 1.0f) {
                    f5 = 1.0f;
                }
                this.rotationYawDelta = this.rotationYawHead - this.renderYawOffset;
            }
            GlStateManager.func_179141_d();
            for (TexturedModel texturedModel : entity.getModels()) {
                texturedModel.getModel().func_78086_a((EntityLivingBase)entity, f6, f5, partialTicks);
                texturedModel.getModel().func_78087_a(f6, f5, f8, this.rotationYawDelta, this.rotationPitchDelta, f4, (Entity)entity);
            }
            for (TexturedModel texturedModel : entity.getModelsRenderPass()) {
                texturedModel.getModel().func_78086_a((EntityLivingBase)entity, f6, f5, partialTicks);
                texturedModel.getModel().func_78087_a(f6, f5, f8, this.rotationYawDelta, this.rotationPitchDelta, f4, (Entity)entity);
            }
            if (this.field_188301_f) {
                boolean flag1 = this.setScoreTeamColor(entity);
                GlStateManager.func_179142_g();
                GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
                if (!this.renderMarker) {
                    this.renderHoverboard(entity, f6, f5, f8, this.rotationYawDelta, this.rotationPitchDelta, f4);
                }
                this.renderLayers(entity, f6, f5, partialTicks, f8, this.rotationYawDelta, this.rotationPitchDelta, f4);
                GlStateManager.func_187417_n();
                GlStateManager.func_179119_h();
                if (flag1) {
                    this.unsetScoreTeamColor();
                }
            } else {
                boolean flag = this.setDoRenderBrightness(entity, partialTicks);
                this.renderHoverboard(entity, f6, f5, f8, this.rotationYawDelta, this.rotationPitchDelta, f4);
                if (flag) {
                    this.unsetBrightness();
                }
                GlStateManager.func_179132_a((boolean)true);
                this.renderLayers(entity, f6, f5, partialTicks, f8, this.rotationYawDelta, this.rotationPitchDelta, f4);
            }
            GlStateManager.func_179101_C();
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't render entity", (Throwable)exception);
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (!this.field_188301_f) {
            this.renderName(entity, x, y, z);
        }
        if (partialTicks != 1.0f) {
            for (TileEntityHoverboardCharger.ChargerPos chargerPos : entity.chargers) {
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                this.func_110776_a(GUARDIAN_BEAM_TEXTURE);
                GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
                GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
                GlStateManager.func_179140_f();
                GlStateManager.func_179129_p();
                GlStateManager.func_179084_k();
                GlStateManager.func_179132_a((boolean)true);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                float counter = (float)entity.field_70170_p.func_82737_E() + partialTicks;
                float movement = counter * (chargerPos.reverse ? -0.25f : 0.25f) % 1.0f;
                float eyeHeight = entity.func_70047_e();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)x), (float)((float)y + eyeHeight), (float)((float)z));
                Vec3d blockPosVec = new Vec3d((double)chargerPos.x + 0.5, (double)chargerPos.y + 0.5, (double)chargerPos.z + 0.5);
                Vec3d hoverboardPosVec = this.getPosition((EntityLivingBase)entity, eyeHeight, partialTicks);
                Vec3d deltaPosVec = blockPosVec.func_178788_d(hoverboardPosVec);
                double length = deltaPosVec.func_72433_c() + -0.075;
                deltaPosVec = deltaPosVec.func_72432_b();
                float glRotateX = (float)Math.acos(deltaPosVec.field_72448_b);
                float glRotateY = (float)Math.atan2(deltaPosVec.field_72449_c, deltaPosVec.field_72450_a);
                GlStateManager.func_179114_b((float)((1.5707964f + -glRotateY) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(glRotateX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                double rotation = (double)counter * 0.2 * (chargerPos.reverse ? 1.5 : -1.5);
                double scale = 0.05;
                double d12 = 0.0 + Math.cos(rotation + Math.PI) * scale;
                double d13 = 0.0 + Math.sin(rotation + Math.PI) * scale;
                double d14 = 0.0 + Math.cos(rotation + 0.0) * scale;
                double d15 = 0.0 + Math.sin(rotation + 0.0) * scale;
                double d16 = 0.0 + Math.cos(rotation + 1.5707963267948966) * scale;
                double d17 = 0.0 + Math.sin(rotation + 1.5707963267948966) * scale;
                double d18 = 0.0 + Math.cos(rotation + 4.71238898038469) * scale;
                double d19 = 0.0 + Math.sin(rotation + 4.71238898038469) * scale;
                double d22 = -1.0f + movement;
                double d23 = length * 2.5 + d22;
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b(d12, length, d13).func_187315_a(0.5, d23).func_181669_b(CHARGER_BEAM_COLOUR[0], CHARGER_BEAM_COLOUR[1], CHARGER_BEAM_COLOUR[2], CHARGER_BEAM_COLOUR[3]).func_181675_d();
                bufferbuilder.func_181662_b(d12, 0.0, d13).func_187315_a(0.5, d22).func_181669_b(CHARGER_BEAM_COLOUR[0], CHARGER_BEAM_COLOUR[1], CHARGER_BEAM_COLOUR[2], CHARGER_BEAM_COLOUR[3]).func_181675_d();
                bufferbuilder.func_181662_b(d14, 0.0, d15).func_187315_a(0.0, d22).func_181669_b(CHARGER_BEAM_COLOUR[0], CHARGER_BEAM_COLOUR[1], CHARGER_BEAM_COLOUR[2], CHARGER_BEAM_COLOUR[3]).func_181675_d();
                bufferbuilder.func_181662_b(d14, length, d15).func_187315_a(0.0, d23).func_181669_b(CHARGER_BEAM_COLOUR[0], CHARGER_BEAM_COLOUR[1], CHARGER_BEAM_COLOUR[2], CHARGER_BEAM_COLOUR[3]).func_181675_d();
                bufferbuilder.func_181662_b(d16, length, d17).func_187315_a(0.5, d23).func_181669_b(CHARGER_BEAM_COLOUR[0], CHARGER_BEAM_COLOUR[1], CHARGER_BEAM_COLOUR[2], CHARGER_BEAM_COLOUR[3]).func_181675_d();
                bufferbuilder.func_181662_b(d16, 0.0, d17).func_187315_a(0.5, d22).func_181669_b(CHARGER_BEAM_COLOUR[0], CHARGER_BEAM_COLOUR[1], CHARGER_BEAM_COLOUR[2], CHARGER_BEAM_COLOUR[3]).func_181675_d();
                bufferbuilder.func_181662_b(d18, 0.0, d19).func_187315_a(0.0, d22).func_181669_b(CHARGER_BEAM_COLOUR[0], CHARGER_BEAM_COLOUR[1], CHARGER_BEAM_COLOUR[2], CHARGER_BEAM_COLOUR[3]).func_181675_d();
                bufferbuilder.func_181662_b(d18, length, d19).func_187315_a(0.0, d23).func_181669_b(CHARGER_BEAM_COLOUR[0], CHARGER_BEAM_COLOUR[1], CHARGER_BEAM_COLOUR[2], CHARGER_BEAM_COLOUR[3]).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
        }
    }

    private Vec3d getPosition(EntityLivingBase entityLivingBaseIn, double p_177110_2_, float p_177110_4_) {
        double d0 = entityLivingBaseIn.field_70142_S + (entityLivingBaseIn.field_70165_t - entityLivingBaseIn.field_70142_S) * (double)p_177110_4_;
        double d1 = p_177110_2_ + entityLivingBaseIn.field_70137_T + (entityLivingBaseIn.field_70163_u - entityLivingBaseIn.field_70137_T) * (double)p_177110_4_;
        double d2 = entityLivingBaseIn.field_70136_U + (entityLivingBaseIn.field_70161_v - entityLivingBaseIn.field_70136_U) * (double)p_177110_4_;
        return new Vec3d(d0, d1, d2);
    }

    private void renderSphereShield(EntityHoverboard entity, double x, double y, double z, float partialTicks) {
        if (entity.getShield() && Config.ALLOW_SHIELD && entity.hasPower() && (double)partialTicks != 1.0 && !entity.getOverheated()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)(y + (double)(entity.field_70131_O / 2.0f)), (double)z);
            if (!Minecraft.func_71410_x().func_147113_T()) {
                GL11.glRotatef((float)(System.currentTimeMillis() % 10000000L / 15L), (float)1.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(System.currentTimeMillis() % 10000000L / 15L), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GL11.glColor4f((float)(entity.getRed() * entity.getColourIntensity()), (float)(entity.getGreen() * entity.getColourIntensity()), (float)(entity.getBlue() * entity.getColourIntensity()), (float)entity.getColourIntensity());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_SHIELD);
            GL11.glCallList((int)ClientProxy.RENDER_ID_SPHERE_OUTSIDE);
            GL11.glCallList((int)ClientProxy.RENDER_ID_SPHERE_INSIDE);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glPopMatrix();
        }
    }

    public float prepareScale(EntityHoverboard entitylivingbaseIn, float partialTicks) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.preRenderCallback(entitylivingbaseIn, partialTicks);
        float f = 0.0625f;
        GlStateManager.func_179109_b((float)0.0f, (float)-1.501f, (float)0.0f);
        return f;
    }

    protected boolean setScoreTeamColor(EntityHoverboard entityLivingBaseIn) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        return true;
    }

    protected void unsetScoreTeamColor() {
        GlStateManager.func_179145_e();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    protected void renderHoverboard(EntityHoverboard entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag1;
        boolean flag = this.isVisible(entitylivingbaseIn);
        boolean bl = flag1 = !flag && !entitylivingbaseIn.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (flag || flag1) {
            if (flag1) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            GL11.glPushMatrix();
            if (entitylivingbaseIn.seenByClientTick > -1 && entitylivingbaseIn.seenByClientTick <= entitylivingbaseIn.field_70173_aa) {
                for (HoverboardUpgrades hoverboardUpgrades : HoverboardUpgrades.values()) {
                    if (!entitylivingbaseIn.hasUpgrade(hoverboardUpgrades)) continue;
                    hoverboardUpgrades.addModel(entitylivingbaseIn);
                }
                entitylivingbaseIn.seenByClientTick = -1;
            }
            if (entitylivingbaseIn.isBeingRiddenByPlayer() && entitylivingbaseIn.getCanMove() && entitylivingbaseIn.hasPower() && !entitylivingbaseIn.getOverheated()) {
                GL11.glRotatef((float)entitylivingbaseIn.getLongitudinalRotationDegrees(), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)entitylivingbaseIn.getSidewaysRotationDegrees(), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (!entitylivingbaseIn.func_82150_aj() || entitylivingbaseIn.field_70737_aN > 0 || entitylivingbaseIn.field_70725_aQ > 0) {
                for (int i = 0; i < entitylivingbaseIn.getModels().size(); ++i) {
                    if (entitylivingbaseIn.getModels().get(i).shouldColourCycle() && entitylivingbaseIn.field_70737_aN <= 0 && entitylivingbaseIn.field_70725_aQ <= 0) {
                        GL11.glColor3f((float)entitylivingbaseIn.getRed(), (float)entitylivingbaseIn.getGreen(), (float)entitylivingbaseIn.getBlue());
                    }
                    this.field_76990_c.field_78724_e.func_110577_a(entitylivingbaseIn.getModels().get(i).getTexture());
                    entitylivingbaseIn.getModels().get(i).getModel().func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, this.rotationYawDelta, this.rotationYawHead - this.renderYawOffset, this.rotationPitchDelta, scaleFactor);
                    if (!entitylivingbaseIn.getModels().get(i).shouldColourCycle() || entitylivingbaseIn.field_70737_aN > 0 || entitylivingbaseIn.field_70725_aQ > 0) continue;
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
            if (entitylivingbaseIn.isBeingRiddenByPlayer() && entitylivingbaseIn.getCanMove() && entitylivingbaseIn.hasPower() && !entitylivingbaseIn.getOverheated()) {
                GL11.glRotatef((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glPopMatrix();
            if (flag1) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    protected boolean isVisible(EntityHoverboard p_193115_1_) {
        return !p_193115_1_.func_82150_aj() || this.field_188301_f;
    }

    protected boolean setDoRenderBrightness(EntityHoverboard entityLivingBaseIn, float partialTicks) {
        return this.setBrightness(entityLivingBaseIn, partialTicks, true);
    }

    protected boolean setBrightness(EntityHoverboard entitylivingbaseIn, float partialTicks, boolean combineTextures) {
        boolean flag1;
        float f = entitylivingbaseIn.func_70013_c();
        int i = this.getColorMultiplier(entitylivingbaseIn, f, partialTicks);
        boolean flag = (i >> 24 & 0xFF) > 0;
        boolean bl = flag1 = entitylivingbaseIn.field_70737_aN > 0 || entitylivingbaseIn.field_70725_aQ > 0;
        if (!flag && !flag1) {
            return false;
        }
        if (!flag && !combineTextures) {
            return false;
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176093_u);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)OpenGlHelper.field_176094_t);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176092_v);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176080_A, (int)OpenGlHelper.field_176092_v);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176076_D, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        this.brightnessBuffer.position(0);
        if (flag1) {
            this.brightnessBuffer.put(1.0f);
            this.brightnessBuffer.put(0.0f);
            this.brightnessBuffer.put(0.0f);
            this.brightnessBuffer.put(0.3f);
        } else {
            float f1 = (float)(i >> 24 & 0xFF) / 255.0f;
            float f2 = (float)(i >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f4 = (float)(i & 0xFF) / 255.0f;
            this.brightnessBuffer.put(f2);
            this.brightnessBuffer.put(f3);
            this.brightnessBuffer.put(f4);
            this.brightnessBuffer.put(1.0f - f1);
        }
        this.brightnessBuffer.flip();
        GlStateManager.func_187448_b((int)8960, (int)8705, (FloatBuffer)this.brightnessBuffer);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
        GlStateManager.func_179098_w();
        GlStateManager.func_179144_i((int)TEXTURE_BRIGHTNESS.func_110552_b());
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        return true;
    }

    protected void unsetBrightness() {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176093_u);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176079_G, (int)OpenGlHelper.field_176093_u);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176086_J, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)5890);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
        GlStateManager.func_179090_x();
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176098_y, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176077_E, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)OpenGlHelper.field_176078_F, (int)5890);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    protected void renderLivingAt(EntityHoverboard entityLivingBaseIn, double x, double y, double z) {
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 0.15625f), (float)((float)z));
    }

    protected void applyRotations(EntityHoverboard entityLiving, float p_77043_2_, float rotationYaw, float partialTicks) {
        GlStateManager.func_179114_b((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GlStateManager.func_179114_b((float)(f * this.getDeathMaxRotation(entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            String s = TextFormatting.func_110646_a((String)entityLiving.func_70005_c_());
            if (s != null && ("Dinnerbone".equals(s) || "Grumm".equals(s) || "Arkif".equals(s))) {
                GlStateManager.func_179109_b((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    protected float getSwingProgress(EntityHoverboard livingBase, float partialTickTime) {
        return livingBase.func_70678_g(partialTickTime);
    }

    protected float handleRotationFloat(EntityHoverboard livingBase, float partialTicks) {
        return (float)livingBase.field_70173_aa + partialTicks;
    }

    protected void renderLayers(EntityHoverboard entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scaleIn) {
        for (LayerRenderer<EntityHoverboard> layerrenderer : this.layerRenderers) {
            boolean flag = this.setBrightness(entitylivingbaseIn, partialTicks, layerrenderer.func_177142_b());
            layerrenderer.func_177141_a((EntityLivingBase)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scaleIn);
            if (!flag) continue;
            this.unsetBrightness();
        }
    }

    protected float getDeathMaxRotation(EntityHoverboard entityLivingBaseIn) {
        return 90.0f;
    }

    protected int getColorMultiplier(EntityHoverboard entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        return 0;
    }

    protected void preRenderCallback(EntityHoverboard entitylivingbaseIn, float partialTickTime) {
    }

    public void renderName(EntityHoverboard entity, double x, double y, double z) {
        if (this.canRenderName(entity)) {
            float f;
            double d0 = entity.func_70068_e(this.field_76990_c.field_78734_h);
            float f2 = f = entity.func_70093_af() ? NAME_TAG_RANGE_SNEAK : NAME_TAG_RANGE;
            if (d0 < (double)(f * f)) {
                String s = entity.func_145748_c_().func_150254_d();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                this.func_188296_a((Entity)entity, x, y, z, s, d0);
            }
        }
    }

    protected boolean canRenderName(EntityHoverboard entity) {
        EntityPlayerSP entityplayersp = Minecraft.func_71410_x().field_71439_g;
        boolean flag = !entity.func_98034_c((EntityPlayer)entityplayersp);
        Team team = entity.func_96124_cp();
        Team team1 = entityplayersp.func_96124_cp();
        if (team != null) {
            Team.EnumVisible team$enumvisible = team.func_178770_i();
            switch (team$enumvisible) {
                case ALWAYS: {
                    return flag;
                }
                case NEVER: {
                    return false;
                }
                case HIDE_FOR_OTHER_TEAMS: {
                    return team1 == null ? flag : team.func_142054_a(team1) && (team.func_98297_h() || flag);
                }
                case HIDE_FOR_OWN_TEAM: {
                    return team1 == null ? flag : !team.func_142054_a(team1) && flag;
                }
            }
            return true;
        }
        return Minecraft.func_71382_s() && entity != this.field_76990_c.field_78734_h && flag && !entity.func_184207_aI() && (entity.func_94059_bO() || entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityHoverboard entity) {
        return null;
    }

    public boolean shouldRender(EntityHoverboard livingEntity, ICamera camera, double camX, double camY, double camZ) {
        if (super.func_177071_a((Entity)livingEntity, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntity.func_110167_bD() && livingEntity.func_110166_bE() != null) {
            Entity entity = livingEntity.func_110166_bE();
            return camera.func_78546_a(entity.func_184177_bl());
        }
        return false;
    }

    public void setLightmap(EntityHoverboard entityLivingIn) {
        int i = entityLivingIn.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
    }

    private void calculateRenderData(EntityHoverboard entityHoverboard) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        float longitudinal = entityHoverboard.getLongitudinalRotationDegrees();
        float sideways = entityHoverboard.getSidewaysRotationDegrees();
        if (entityHoverboard.isMovingForward) {
            entityHoverboard.setLongitudinalRotationDegrees(longitudinal += 2.0f / (float)Minecraft.field_71470_ab * 10.0f);
        } else if (entityHoverboard.isMovingBackward) {
            entityHoverboard.setLongitudinalRotationDegrees(longitudinal -= 1.5f / (float)Minecraft.field_71470_ab * 10.0f);
        } else {
            if (longitudinal > 0.0f) {
                entityHoverboard.setLongitudinalRotationDegrees(longitudinal -= 1.0f / (float)Minecraft.field_71470_ab * 10.0f);
            } else if (longitudinal < 0.0f) {
                entityHoverboard.setLongitudinalRotationDegrees(longitudinal += 1.0f / (float)Minecraft.field_71470_ab * 10.0f);
            }
            if (entityHoverboard.getLongitudinalRotationDegrees() < 1.0f / (float)Minecraft.field_71470_ab * 15.0f && entityHoverboard.getLongitudinalRotationDegrees() > -(1.0f / (float)Minecraft.field_71470_ab) * 15.0f) {
                entityHoverboard.setLongitudinalRotationDegrees(0.0f);
            }
        }
        if (entityHoverboard.isMovingLeft) {
            entityHoverboard.setSidewaysRotationDegrees(sideways += 1.0f / (float)Minecraft.field_71470_ab * 10.0f);
        } else if (entityHoverboard.isMovingRight) {
            entityHoverboard.setSidewaysRotationDegrees(sideways -= 1.0f / (float)Minecraft.field_71470_ab * 10.0f);
        } else {
            if (sideways > 0.0f) {
                entityHoverboard.setSidewaysRotationDegrees(sideways -= 1.0f / (float)Minecraft.field_71470_ab * 10.0f);
            } else if (sideways < 0.0f) {
                entityHoverboard.setSidewaysRotationDegrees(sideways += 1.0f / (float)Minecraft.field_71470_ab * 10.0f);
            }
            if (entityHoverboard.getSidewaysRotationDegrees() < 1.0f / (float)Minecraft.field_71470_ab * 15.0f && entityHoverboard.getSidewaysRotationDegrees() > -(1.0f / (float)Minecraft.field_71470_ab) * 15.0f) {
                entityHoverboard.setSidewaysRotationDegrees(0.0f);
            }
        }
        if (entityHoverboard.getOverheated()) {
            if (entityHoverboard.getLeftVentMovement() > -0.2f) {
                entityHoverboard.setLeftVentMovement(entityHoverboard.getLeftVentMovement() - 0.5f / (float)Minecraft.field_71470_ab);
            }
            if (entityHoverboard.getRightVentMovement() < 0.2f) {
                entityHoverboard.setRightVentMovement(entityHoverboard.getRightVentMovement() + 0.5f / (float)Minecraft.field_71470_ab);
            }
        } else {
            if (entityHoverboard.getLeftVentMovement() < 0.0f) {
                entityHoverboard.setLeftVentMovement(entityHoverboard.getLeftVentMovement() + 0.1f / (float)Minecraft.field_71470_ab);
            }
            if (entityHoverboard.getRightVentMovement() > 0.0f) {
                entityHoverboard.setRightVentMovement(entityHoverboard.getRightVentMovement() - 0.1f / (float)Minecraft.field_71470_ab);
            }
        }
    }

    static {
        int[] aint = TEXTURE_BRIGHTNESS.func_110565_c();
        for (int i = 0; i < 256; ++i) {
            aint[i] = -1;
        }
        TEXTURE_BRIGHTNESS.func_110564_a();
    }
}

