/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.renderer.hud;

import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardUpgrades;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class RenderHoverboardHud {
    private static final ResourceLocation TEXTURE_HUD = new ResourceLocation("hoverboardmod", "textures/misc/hoverboard_hud.png");
    private static final ResourceLocation TEXTURE_HUD_GUI = new ResourceLocation("hoverboardmod", "textures/misc/hoverboard_hud_extras.png");
    private static final String STRING_MINING = I18n.func_135052_a((String)"hud.hoverboard.miningWarning", (Object[])new Object[0]);
    private static final String STRING_CREATIVE = I18n.func_135052_a((String)"hud.hoverboard.creative", (Object[])new Object[0]);
    private static final String STRING_POWER = I18n.func_135052_a((String)"hud.hoverboard.power", (Object[])new Object[0]);
    private static final String STRING_HEAT = I18n.func_135052_a((String)"hud.hoverboard.heat", (Object[])new Object[0]);
    private static final String STRING_MISSILE = I18n.func_135052_a((String)"hud.hoverboard.rockets", (Object[])new Object[0]);
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private int width;
    private int height;
    private int textHeight;

    public RenderHoverboardHud() {
        this.textHeight = this.minecraft.field_71466_p.field_78288_b;
    }

    @SubscribeEvent
    public void onRenderHoverboard(RenderGameOverlayEvent.Post event) {
        if (!event.isCancelable() && this.minecraft.field_71439_g.func_184187_bx() != null && this.minecraft.field_71439_g.func_184187_bx() instanceof EntityHoverboard) {
            EntityHoverboard hoverboard = (EntityHoverboard)this.minecraft.field_71439_g.func_184187_bx();
            this.width = event.getResolution().func_78326_a();
            this.height = event.getResolution().func_78328_b();
            this.minecraft.field_71460_t.func_78478_c();
            if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
                this.renderHud(hoverboard);
                if (!this.minecraft.field_71439_g.field_71075_bZ.field_75098_d) {
                    this.renderPower(hoverboard);
                    this.renderHeat(hoverboard);
                    this.renderRocket(hoverboard);
                } else {
                    this.renderCreative();
                }
                if (hoverboard.getMiningMode()) {
                    this.renderMining();
                }
            }
        }
    }

    private void renderHud(EntityHoverboard hoverboard) {
        GL11.glPushMatrix();
        ScaledResolution scaledresolution = new ScaledResolution(this.minecraft);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GL11.glColor4f((float)hoverboard.getRed(), (float)hoverboard.getGreen(), (float)hoverboard.getBlue(), (float)0.65f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE_HUD);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(0.0, (double)scaledresolution.func_78328_b(), -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledresolution.func_78326_a(), (double)scaledresolution.func_78328_b(), -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)scaledresolution.func_78326_a(), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderPower(EntityHoverboard hoverboard) {
        int xPos = this.width / 2 - 128;
        int yPos = 5;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE_HUD_GUI);
        this.drawTexturedModalRect(xPos, yPos, 0, 0, 256, 20);
        this.drawTexturedModalRect(xPos + 1, yPos + 1, 0, 20, hoverboard.getCurrentPower() * 254 / hoverboard.getMaxPower(), 18);
        int textWidth = this.minecraft.field_71466_p.func_78256_a(STRING_POWER);
        xPos = this.width / 2 - textWidth / 2;
        yPos = 12;
        this.minecraft.field_71466_p.func_78276_b(STRING_POWER, xPos - 1, yPos, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_POWER, xPos + 1, yPos, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_POWER, xPos, yPos + 1, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_POWER, xPos, yPos - 1, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_POWER, xPos, yPos, 15324159);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderHeat(EntityHoverboard hoverboard) {
        int xPos = this.width / 2 - 128;
        int yPos = 30;
        GL11.glPushMatrix();
        this.minecraft.func_110434_K().func_110577_a(TEXTURE_HUD_GUI);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(xPos, yPos, 0, 0, 256, 20);
        this.drawTexturedModalRect(xPos + 1, yPos + 1, 0, 39, hoverboard.getCurrentHeat() * 256 / 50000, 18);
        int textWidth = this.minecraft.field_71466_p.func_78256_a(STRING_HEAT);
        xPos = this.width / 2 - textWidth / 2;
        yPos = 37;
        this.minecraft.field_71466_p.func_78276_b(STRING_HEAT, xPos + 1, yPos, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_HEAT, xPos - 1, yPos, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_HEAT, xPos, yPos + 1, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_HEAT, xPos, yPos - 1, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_HEAT, xPos, yPos, 16771539);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderRocket(EntityHoverboard hoverboard) {
        if (hoverboard.hasUpgrade(HoverboardUpgrades.rocket)) {
            int xPos = 4;
            int yPos = 5;
            GL11.glPushMatrix();
            this.minecraft.func_110434_K().func_110577_a(TEXTURE_HUD_GUI);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(xPos, yPos, 0, 58, 100, 27);
            this.drawTexturedModalRect(xPos, yPos, 100, 58, hoverboard.getCurrentRockets() * 100 / 256, 27);
            xPos = 59;
            yPos = 4;
            this.minecraft.field_71466_p.func_78276_b(STRING_MISSILE, xPos + 1, yPos, 0);
            this.minecraft.field_71466_p.func_78276_b(STRING_MISSILE, xPos - 1, yPos, 0);
            this.minecraft.field_71466_p.func_78276_b(STRING_MISSILE, xPos, yPos + 1, 0);
            this.minecraft.field_71466_p.func_78276_b(STRING_MISSILE, xPos, yPos - 1, 0);
            this.minecraft.field_71466_p.func_78276_b(STRING_MISSILE, xPos, yPos, 13887999);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    private void renderCreative() {
        int textWidth = this.minecraft.field_71466_p.func_78256_a(STRING_CREATIVE);
        int xPos = this.width / 2 - textWidth / 2;
        int yPos = 12;
        this.minecraft.field_71466_p.func_78276_b(STRING_CREATIVE, xPos + 1, yPos, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_CREATIVE, xPos - 1, yPos, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_CREATIVE, xPos, yPos + 1, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_CREATIVE, xPos, yPos - 1, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_CREATIVE, xPos, yPos, 15324159);
    }

    private void renderMining() {
        int xPos = this.width / 2 + this.width / 4;
        int yPos = this.height - 5 - this.textHeight;
        this.minecraft.field_71466_p.func_78276_b(STRING_MINING, xPos - 1, yPos, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_MINING, xPos + 1, yPos, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_MINING, xPos, yPos + 1, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_MINING, xPos, yPos - 1, 0);
        this.minecraft.field_71466_p.func_78276_b(STRING_MINING, xPos, yPos, 0xFFD3D3);
    }

    public void drawTexturedModalRect(int x, int y, int u, int z, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        double zLevel = -90.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), zLevel).func_187315_a((double)((float)(u + 0) * f), (double)((float)(z + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a((double)((float)(u + width) * f), (double)((float)(z + height) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), zLevel).func_187315_a((double)((float)(u + width) * f), (double)((float)(z + 0) * f1)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), zLevel).func_187315_a((double)((float)(u + 0) * f), (double)((float)(z + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

