/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.renderer.item;

import com.arkifgames.hoverboardmod.client.model.ItemLayerWrapper;
import com.arkifgames.hoverboardmod.client.model.ModelHoverboardBase;
import com.arkifgames.hoverboardmod.client.model.ModelHoverboardBottomThrusters;
import com.arkifgames.hoverboardmod.client.model.TexturedModel;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderItemHoverboard
extends TileEntityItemStackRenderer {
    private static ArrayList<TexturedModel> models = new ArrayList();
    private int lastTickColour = 0;
    private float hue = 0.0f;
    private float saturation = 0.75f;
    private float brightness = 1.0f;
    private Color colour = Color.getHSBColor(this.hue, this.saturation, this.brightness);
    public static ItemLayerWrapper layerWrapper;
    public static ItemLayerWrapper layerWrapperCapacity;

    public void func_179022_a(@Nonnull ItemStack stack) {
        ItemCameraTransforms.TransformType transformType = stack.func_77958_k() == 0x800000 ? layerWrapperCapacity.getTransform() : layerWrapper.getTransform();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.5f, (float)0.0f);
        if (models.size() == 0) {
            models.add(new TexturedModel(new ModelHoverboardBase(), TexturedModel.TEXTURE_HOVERBOARD_BASE, false, false));
            models.add(new TexturedModel(new ModelHoverboardBase(), 2, true, false, "lights", 53));
            models.add(new TexturedModel(new ModelHoverboardBottomThrusters(), TexturedModel.TEXTURE_BOTTOM_THRUSTERS, true, false));
        }
        if (this.lastTickColour < Minecraft.func_71410_x().field_71439_g.field_70173_aa) {
            for (int i = 0; i < models.size(); ++i) {
                models.get(i).onUpdate();
            }
            this.updateColour();
            this.lastTickColour = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
        } else if (this.lastTickColour > Minecraft.func_71410_x().field_71439_g.field_70173_aa) {
            this.lastTickColour = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
        }
        switch (transformType) {
            case GROUND: {
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.5f);
                GlStateManager.func_179114_b((float)80.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)1.2f, (float)-0.7f, (float)-0.6f);
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.5f);
                GlStateManager.func_179114_b((float)80.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)1.2f, (float)-0.7f, (float)-0.6f);
                break;
            }
            case FIXED: {
                break;
            }
            case GUI: {
                GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case HEAD: {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
                break;
            }
            case NONE: {
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.5f);
                GlStateManager.func_179114_b((float)-80.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-0.8f, (float)-1.4f, (float)-0.0f);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.5f);
                GlStateManager.func_179114_b((float)80.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.8f, (float)-1.4f, (float)-0.0f);
                break;
            }
        }
        this.renderModels(stack);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateColour() {
        this.hue += 0.001f;
        if (this.hue >= 1.0f) {
            this.hue = 0.0f;
        }
        this.colour = Color.getHSBColor(this.hue, this.saturation, this.brightness);
    }

    private void renderModels(ItemStack itemStack) {
        for (int i = 0; i < models.size(); ++i) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(models.get(i).getTexture());
            if (i == 1) {
                GL11.glTranslatef((float)0.0f, (float)-0.001f, (float)0.0f);
            }
            if (i == 1 || i == 2) {
                GL11.glColor3f((float)((float)this.colour.getRed() / 255.0f), (float)((float)this.colour.getGreen() / 255.0f), (float)((float)this.colour.getBlue() / 255.0f));
            }
            models.get(i).getModel().func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            if (i == 1 || i == 2) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (i != 1) continue;
            GL11.glTranslatef((float)0.0f, (float)0.001f, (float)0.0f);
        }
    }
}

