/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.client.renderer.tileentity;

import com.arkifgames.hoverboardmod.client.model.ModelCharger;
import com.arkifgames.hoverboardmod.tileentity.TileEntityHoverboardCharger;
import com.arkifgames.hoverboardmod.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderTileEntityHoverboardCharger
extends TileEntitySpecialRenderer<TileEntityHoverboardCharger> {
    private static final ResourceLocation CHARGER = new ResourceLocation("hoverboardmod", "textures/models/hoverboard_charger.png");
    private static final ResourceLocation GUARDIAN_BEAM_TEXTURE = new ResourceLocation("hoverboardmod", "textures/models/hoverboard_charger_beam.png");
    private ModelCharger modelHoverboardCharger = new ModelCharger();

    public void render(TileEntityHoverboardCharger tileEntity, double xFrom, double yFrom, double zFrom, float partialTicks, int destroyStage, float alpha) {
        if (tileEntity instanceof TileEntityHoverboardCharger) {
            TileEntityHoverboardCharger charger = tileEntity;
            int i = 0;
            float rotationAngle = 90.0f;
            float rotationAngle2 = 45.0f;
            if (!Minecraft.func_71410_x().func_147113_T()) {
                rotationAngle = 90.0f * ((float)System.nanoTime() + partialTicks) / 1.0E9f;
                rotationAngle2 = 180.0f * ((float)System.nanoTime() + partialTicks) / 1.0E9f;
            }
            if (tileEntity.getEnergyStored() > 0) {
                this.func_147499_a(GUARDIAN_BEAM_TEXTURE);
                GlStateManager.func_179106_n();
                RenderTileEntityHoverboardCharger.renderBeamSegment(xFrom, yFrom, zFrom, partialTicks, 1.0, charger.reverse ? -rotationAngle2 : rotationAngle2, tileEntity.func_145831_w().func_82737_E(), 0.25, 0.5, EnumDyeColor.RED.func_193349_f(), 0.1, charger.reverse);
                GlStateManager.func_179127_m();
            }
            if (charger.func_145830_o()) {
                i = charger.func_145832_p();
            }
            if (destroyStage >= 0) {
                this.func_147499_a(field_178460_a[destroyStage]);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.func_179128_n((int)5888);
            } else {
                this.func_147499_a(CHARGER);
            }
            this.modelHoverboardCharger.centreCentre.field_78796_g = (float)Math.toRadians(charger.reverse ? (double)(-rotationAngle) : (double)rotationAngle);
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GL11.glTranslatef((float)((float)xFrom + 0.5f), (float)((float)yFrom + 1.5f), (float)((float)zFrom + 0.5f));
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.func_179114_b((float)Util.getRotationTESR(i), (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelHoverboardCharger.renderModel(0.0625f);
            this.modelHoverboardCharger.renderLights(0.0625f);
            if (charger.state == null) {
                charger.state = charger.func_145838_q().func_176221_a(charger.func_145831_w().func_180495_p(charger.func_174877_v()), (IBlockAccess)charger.func_145831_w(), charger.func_174877_v());
            }
            if (charger.func_145831_w().func_82737_E() % 5L == 0L) {
                charger.state = charger.func_145838_q().func_176221_a(charger.func_145831_w().func_180495_p(charger.func_174877_v()), (IBlockAccess)charger.func_145831_w(), charger.func_174877_v());
            }
            GlStateManager.func_179114_b((float)Util.getRotationTESR(i), (float)0.0f, (float)-1.0f, (float)0.0f);
            this.modelHoverboardCharger.renderConnectors(charger.state, 0.0625f);
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
            }
        }
    }

    public static void renderBeamSegment(double x, double y, double z, double partialTicks, double textureScale, double rotation, double totalWorldTime, double yOffset, double height, float[] colors, double beamRadius, boolean reverse) {
        double i = yOffset + height;
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double counter = totalWorldTime + partialTicks;
        double movement = reverse ? counter : -counter;
        double movement2 = MathHelper.func_181162_h((double)(movement * 0.2 - (double)MathHelper.func_76128_c((double)(movement * 0.1))));
        float red = colors[0];
        float green = colors[1];
        float blue = colors[2];
        double rotationRadian = Math.toRadians(rotation);
        double d4 = 0.5 + Math.cos(rotationRadian + 2.356194490192345) * beamRadius;
        double d5 = 0.5 + Math.sin(rotationRadian + 2.356194490192345) * beamRadius;
        double d6 = 0.5 + Math.cos(rotationRadian + 0.7853981633974483) * beamRadius;
        double d7 = 0.5 + Math.sin(rotationRadian + 0.7853981633974483) * beamRadius;
        double d8 = 0.5 + Math.cos(rotationRadian + 3.9269908169872414) * beamRadius;
        double d9 = 0.5 + Math.sin(rotationRadian + 3.9269908169872414) * beamRadius;
        double d10 = 0.5 + Math.cos(rotationRadian + 5.497787143782138) * beamRadius;
        double d11 = 0.5 + Math.sin(rotationRadian + 5.497787143782138) * beamRadius;
        double d14 = -1.0 + movement2;
        double d15 = height * textureScale * (0.5 / beamRadius) + d14;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(x + d4, y + i, z + d5).func_187315_a(0.5, d15).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d4, y + yOffset, z + d5).func_187315_a(0.5, d14).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d6, y + yOffset, z + d7).func_187315_a(0.0, d14).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d6, y + i, z + d7).func_187315_a(0.0, d15).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d10, y + i, z + d11).func_187315_a(0.5, d15).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d10, y + yOffset, z + d11).func_187315_a(0.5, d14).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d8, y + yOffset, z + d9).func_187315_a(0.0, d14).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d8, y + i, z + d9).func_187315_a(0.0, d15).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d6, y + i, z + d7).func_187315_a(0.5, d15).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d6, y + yOffset, z + d7).func_187315_a(0.5, d14).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d10, y + yOffset, z + d11).func_187315_a(0.0, d14).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d10, y + i, z + d11).func_187315_a(0.0, d15).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d8, y + i, z + d9).func_187315_a(0.5, d15).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d8, y + yOffset, z + d9).func_187315_a(0.5, d14).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d4, y + yOffset, z + d5).func_187315_a(0.0, d14).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(x + d4, y + i, z + d5).func_187315_a(0.0, d15).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    public boolean isGlobalRenderer(TileEntityHoverboardCharger te) {
        return true;
    }
}

