/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.crafting;

import com.arkifgames.hoverboardmod.blocks.HoverboardModBlocks;
import com.arkifgames.hoverboardmod.crafting.BatteryRecipe;
import com.arkifgames.hoverboardmod.items.HoverboardModItems;
import com.arkifgames.hoverboardmod.main.Config;
import ic2.api.item.IC2Items;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CraftingRecipes {
    public static void loadCraftingRecipes() {
        OreDictionary.registerOre((String)"dyeBlack", (Item)HoverboardModItems.pitch);
        OreDictionary.registerOre((String)"stickIron", (Item)HoverboardModItems.iron_rod);
        if (Config.IC2_INSTALLED && Config.RECIPES_INDUSTRIAL_CRAFT_2) {
            System.out.println("Arkif's Hoverboard Mod will attempt to use IndustrialCraft2's items in crafting recipes.");
            CraftingRecipes.addRecipe("recipe_rocket_ammunition", new ItemStack(HoverboardModItems.rocket_ammunition, 1), "DDD", "RRR", "GSG", Character.valueOf('D'), IC2Items.getItemAPI().getItem("dynamite"), Character.valueOf('R'), Items.field_151152_bP, Character.valueOf('G'), Items.field_151016_H, Character.valueOf('S'), Items.field_151007_F);
        } else {
            CraftingRecipes.addRecipe("recipe_rocket_ammunition", new ItemStack(HoverboardModItems.rocket_ammunition, 1), "GGG", "RSR", "RRR", Character.valueOf('R'), Items.field_151152_bP, Character.valueOf('S'), Items.field_151007_F, Character.valueOf('G'), Items.field_151016_H);
        }
        if (!Config.BUILDCRAFT_INSTALLED || Config.RECIPES_BUILDCRAFT) {
            // empty if block
        }
        CraftingRecipes.addShapelessRecipe("recipe_carbon_fibre", new ItemStack(HoverboardModItems.carbon_fibre), Ingredient.func_193368_a((Item[])new Item[]{HoverboardModItems.pitch_fibres, HoverboardModItems.pitch_fibres}));
        CraftingRecipes.addRecipe(new ShapedOreRecipe(new ResourceLocation("hoverboardmod", "recipe_battery"), new ItemStack(HoverboardModItems.battery, 1), new Object[]{"GQG", "RBR", "QBQ", Character.valueOf('G'), "nuggetGold", Character.valueOf('Q'), "gemQuartz", Character.valueOf('R'), "dustRedstone", Character.valueOf('B'), "blockRedstone"}));
        CraftingRecipes.addRecipe(new ShapedOreRecipe(new ResourceLocation("hoverboardmod", "recipe_monitor_0"), new ItemStack(HoverboardModItems.monitor, 1), new Object[]{"GGG", "CRP", "BBB", Character.valueOf('G'), "paneGlass", Character.valueOf('C'), HoverboardModItems.microcontroller, Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('B'), Blocks.field_150471_bO}));
        CraftingRecipes.addRecipe(new ShapedOreRecipe(new ResourceLocation("hoverboardmod", "recipe_monitor_1"), new ItemStack(HoverboardModItems.monitor, 1), new Object[]{"GGG", "CRP", "BBB", Character.valueOf('G'), "paneGlass", Character.valueOf('C'), HoverboardModItems.microcontroller, Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('B'), Blocks.field_150430_aB}));
        CraftingRecipes.addRecipe(new ShapedOreRecipe(new ResourceLocation("hoverboardmod", "recipe_power_module"), new ItemStack(HoverboardModItems.power_module, 1), new Object[]{"IRI", "DCD", "ITI", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('D'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('T'), Blocks.field_150429_aA}));
        CraftingRecipes.addRecipe(new ShapedOreRecipe(new ResourceLocation("hoverboardmod", "recipe_lights"), new ItemStack(HoverboardModItems.lights, 1), new Object[]{"PRP", "GLM", "PBP", Character.valueOf('P'), "paneGlass", Character.valueOf('R'), "dyeRed", Character.valueOf('G'), "dyeGreen", Character.valueOf('B'), "dyeBlue", Character.valueOf('L'), Blocks.field_150379_bu, Character.valueOf('M'), HoverboardModItems.power_module}));
        String silicon1 = null;
        if (OreDictionary.doesOreNameExist((String)"itemSilicon")) {
            silicon1 = "itemSilicon";
        }
        CraftingRecipes.addRecipe(new ShapedOreRecipe(new ResourceLocation("hoverboardmod", "recipe_processor"), new ItemStack(HoverboardModItems.processor, 1), new Object[]{"RSR", "GCG", "SRS", Character.valueOf('R'), "dustRedstone", Character.valueOf('S'), silicon1 == null ? HoverboardModItems.silicon : silicon1, Character.valueOf('G'), "nuggetGold", Character.valueOf('C'), Items.field_151113_aN}));
        String basePcb = null;
        if (OreDictionary.doesOreNameExist((String)"plastic") && OreDictionary.getOres((String)"plastic").size() > 0) {
            basePcb = "plastic";
        } else if (OreDictionary.doesOreNameExist((String)"itemPlastic") && OreDictionary.getOres((String)"itemPlastic").size() > 0) {
            basePcb = "itemPlastic";
        }
        String metalPcb = null;
        metalPcb = OreDictionary.doesOreNameExist((String)"nuggetCopper") && OreDictionary.getOres((String)"nuggetCopper").size() > 0 ? "nuggetCopper" : (OreDictionary.doesOreNameExist((String)"nuggetIron") && OreDictionary.getOres((String)"nuggetIron").size() > 0 ? "nuggetIron" : "ingotIron");
        CraftingRecipes.addRecipe(new ShapedOreRecipe(new ResourceLocation("hoverboardmod", "recipe_pcb"), new ItemStack(HoverboardModItems.pcb, 1), new Object[]{"IGI", "RNR", "PPP", Character.valueOf('I'), metalPcb, Character.valueOf('G'), "dyeGreen", Character.valueOf('R'), "dustRedstone", Character.valueOf('N'), "nuggetGold", Character.valueOf('P'), basePcb == null ? Items.field_151121_aF : basePcb}));
        CraftingRecipes.addRecipe(new ShapedOreRecipe(new ResourceLocation("hoverboardmod", "recipe_iron_rod"), new ItemStack(HoverboardModItems.iron_rod, 1), new Object[]{"  I", " I ", "I  ", Character.valueOf('I'), "ingotIron"}));
        CraftingRecipes.addRecipe(new ShapedOreRecipe(new ResourceLocation("hoverboardmod", "recipe_crank"), new ItemStack(HoverboardModItems.crank, 1), new Object[]{" I ", "IRI", " I ", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "stickIron"}));
        if (OreDictionary.doesOreNameExist((String)"gearIron") && OreDictionary.getOres((String)"gearIron").size() > 0) {
            if (Config.IC2_INSTALLED && Config.RECIPES_INDUSTRIAL_CRAFT_2) {
                CraftingRecipes.addRecipe(new BatteryRecipe(new ResourceLocation("hoverboardmod", "recipe_builder_0"), new ItemStack(HoverboardModBlocks.builder, 1), new Object[]{"CWC", "SPB", "CWC", Character.valueOf('C'), IC2Items.getItem((String)"crafting", (String)"carbon_plate"), Character.valueOf('W'), Blocks.field_150462_ai, Character.valueOf('S'), "gearIron", Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('B'), HoverboardModItems.battery}, 5));
            }
            CraftingRecipes.addRecipe(new BatteryRecipe(new ResourceLocation("hoverboardmod", "recipe_builder_1"), new ItemStack(HoverboardModBlocks.builder, 1), new Object[]{"CWC", "SPB", "CWC", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('W'), Blocks.field_150462_ai, Character.valueOf('S'), "gearIron", Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('B'), HoverboardModItems.battery}, 5));
        } else {
            if (Config.IC2_INSTALLED && Config.RECIPES_INDUSTRIAL_CRAFT_2) {
                CraftingRecipes.addRecipe(new BatteryRecipe(new ResourceLocation("hoverboardmod", "recipe_builder_0"), new ItemStack(HoverboardModBlocks.builder, 1), new Object[]{"CWC", "SPB", "CWC", Character.valueOf('C'), IC2Items.getItem((String)"crafting", (String)"carbon_plate"), Character.valueOf('W'), Blocks.field_150462_ai, Character.valueOf('S'), Blocks.field_150486_ae, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('B'), HoverboardModItems.battery}, 5));
            }
            CraftingRecipes.addRecipe(new BatteryRecipe(new ResourceLocation("hoverboardmod", "recipe_builder_1"), new ItemStack(HoverboardModBlocks.builder, 1), new Object[]{"CWC", "SPB", "CWC", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('W'), Blocks.field_150462_ai, Character.valueOf('S'), Blocks.field_150486_ae, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('B'), HoverboardModItems.battery}, 5));
        }
        String metalSolarPanel = null;
        metalSolarPanel = OreDictionary.doesOreNameExist((String)"ingotAluminum") && OreDictionary.getOres((String)"ingotAluminum").size() > 0 ? "ingotAluminum" : "ingotIron";
        CraftingRecipes.addRecipe(new BatteryRecipe(new ResourceLocation("hoverboardmod", "recipe_solar_panel"), new ItemStack(HoverboardModBlocks.solar_panel, 1), new Object[]{"IDI", "SBS", "PsP", Character.valueOf('I'), metalSolarPanel, Character.valueOf('D'), Blocks.field_150453_bW, Character.valueOf('S'), silicon1 == null ? HoverboardModItems.silicon : silicon1, Character.valueOf('B'), HoverboardModItems.battery, Character.valueOf('P'), Blocks.field_150320_F, Character.valueOf('s'), new ItemStack((Block)Blocks.field_150333_U, 1, 0)}, 4));
        if (OreDictionary.doesOreNameExist((String)"gearGold") && OreDictionary.getOres((String)"gearGold").size() > 0) {
            CraftingRecipes.addRecipe(new BatteryRecipe(new ResourceLocation("hoverboardmod", "recipe_melt_spinner"), new ItemStack(HoverboardModBlocks.melt_spinner, 1), new Object[]{"BHI", "PCM", "Rpb", Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('I'), "blockIron", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('C'), HoverboardModItems.crank, Character.valueOf('M'), "gearGold", Character.valueOf('R'), "dustRedstone", Character.valueOf('p'), HoverboardModItems.power_module, Character.valueOf('b'), HoverboardModItems.battery}, 8));
        } else {
            CraftingRecipes.addRecipe(new BatteryRecipe(new ResourceLocation("hoverboardmod", "recipe_melt_spinner"), new ItemStack(HoverboardModBlocks.melt_spinner, 1), new Object[]{"BHI", "PCM", "Rpb", Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('I'), "blockIron", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('C'), HoverboardModItems.crank, Character.valueOf('M'), Items.field_151111_aL, Character.valueOf('R'), "dustRedstone", Character.valueOf('p'), HoverboardModItems.power_module, Character.valueOf('b'), HoverboardModItems.battery}, 8));
        }
        CraftingRecipes.addRecipe("recipe_carbon_fibre_stairs_0", new ItemStack(HoverboardModBlocks.carbon_fibre_stairs, 6), "C  ", "CC ", "CCC", Character.valueOf('C'), HoverboardModBlocks.carbon_fibre_block);
        CraftingRecipes.addRecipe("recipe_carbon_fibre_stairs_1", new ItemStack(HoverboardModBlocks.carbon_fibre_stairs, 6), "  C", " CC", "CCC", Character.valueOf('C'), HoverboardModBlocks.carbon_fibre_block);
        CraftingRecipes.addRecipe("recipe_carbon_fibre_slab", new ItemStack((Block)HoverboardModBlocks.carbon_fibre_slab, 6), "CCC", Character.valueOf('C'), HoverboardModBlocks.carbon_fibre_block);
        GameRegistry.addSmelting((ItemStack)new ItemStack(Blocks.field_150402_ci), (ItemStack)new ItemStack(HoverboardModItems.pitch, 2), (float)0.8f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(HoverboardModItems.pitch), (ItemStack)new ItemStack(HoverboardModItems.mesophase_pitch, 1), (float)0.5f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(Items.field_151128_bU), (ItemStack)new ItemStack(HoverboardModItems.silicon), (float)0.1f);
    }

    private static void addRecipe(String name, ItemStack output, Object ... input) {
        ResourceLocation resourceLocation = new ResourceLocation("hoverboardmod", name);
        GameRegistry.addShapedRecipe((ResourceLocation)resourceLocation, (ResourceLocation)new ResourceLocation("hoverboardmod", "Recipes"), (ItemStack)output, (Object[])input);
    }

    private static void addRecipe(ShapedOreRecipe oreRecipe) {
        oreRecipe.setRegistryName(new ResourceLocation(oreRecipe.func_193358_e()));
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)oreRecipe);
    }

    private static void addShapelessRecipe(String name, ItemStack output, Ingredient ... input) {
        ResourceLocation resourceLocation = new ResourceLocation("hoverboardmod", name);
        GameRegistry.addShapelessRecipe((ResourceLocation)resourceLocation, (ResourceLocation)new ResourceLocation("hoverboardmod", "Recipes"), (ItemStack)output, (Ingredient[])input);
    }
}

