/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.crafting;

import com.arkifgames.hoverboardmod.items.HoverboardModItems;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MeltSpinnerRecipes {
    private static final MeltSpinnerRecipes smeltingBase = new MeltSpinnerRecipes();
    private final Map<ItemStack, ItemStack> smeltingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static MeltSpinnerRecipes instance() {
        return smeltingBase;
    }

    private MeltSpinnerRecipes() {
        this.addSpinningRecipe(HoverboardModItems.mesophase_pitch, new ItemStack(HoverboardModItems.pitch_fibres), 1.0f);
    }

    public void addSpinningRecipe(Block block, ItemStack itemStack, float xp) {
        this.addSpinningRecipe(Item.func_150898_a((Block)block), itemStack, xp);
    }

    public void addSpinningRecipe(Item item, ItemStack itemStack, float xp) {
        this.addSpinningRecipe(new ItemStack(item, 1, Short.MAX_VALUE), itemStack, xp);
    }

    public void addSpinningRecipe(ItemStack input, ItemStack output, float xp) {
        this.smeltingList.put(input, output);
        this.experienceList.put(output, Float.valueOf(xp));
    }

    public ItemStack getSmeltingResult(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!this.compareItemStacks(itemStack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack2.func_77973_b() == itemStack1.func_77973_b() && (itemStack2.func_77952_i() == Short.MAX_VALUE || itemStack2.func_77952_i() == itemStack1.func_77952_i());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getSpinningExperience(ItemStack itemStack) {
        float ret = itemStack.func_77973_b().getSmeltingExperience(itemStack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(itemStack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

