/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.crafting.builder;

import com.arkifgames.hoverboardmod.blocks.HoverboardModBlocks;
import com.arkifgames.hoverboardmod.crafting.builder.IRecipeBuilder;
import com.arkifgames.hoverboardmod.crafting.builder.RecipeSorter;
import com.arkifgames.hoverboardmod.crafting.builder.ShapedRecipesBuilder;
import com.arkifgames.hoverboardmod.items.HoverboardModItems;
import com.arkifgames.hoverboardmod.main.Config;
import com.arkifgames.hoverboardmod.tileentity.TileEntityHoverboardBuilder;
import ic2.api.item.IC2Items;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import scala.Tuple2;

public class BuilderRecipes {
    private static final BuilderRecipes instance = new BuilderRecipes();
    private List recipes = new ArrayList();
    private HashMap<Tuple2<Item, Integer>, Integer> buildTimes;

    public static final BuilderRecipes getInstance() {
        return instance;
    }

    private BuilderRecipes() {
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_thruster"), new ItemStack(HoverboardModItems.thruster, 1), new int[]{5}, new Object[]{"CCC ", "FBMC", "R#PC", "CCC ", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('F'), Items.field_151033_d, Character.valueOf('B'), HoverboardModItems.battery, Character.valueOf('M'), HoverboardModItems.microcontroller, Character.valueOf('R'), Items.field_151072_bj, Character.valueOf('#'), Blocks.field_150451_bX, Character.valueOf('P'), HoverboardModItems.power_module});
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_rocket_launcher"), new ItemStack(HoverboardModItems.rocket_launcher, 1), "CCCC", "PMF ", "CCCC", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('M'), HoverboardModItems.microcontroller, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('F'), Items.field_151059_bz);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_hoverboard"), new ItemStack(HoverboardModItems.hoverboard, 1), new int[]{9, 10, 13, 14}, new Object[]{"CCCC", "HLMU", "SBBP", "CTTC", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('L'), HoverboardModItems.lights, Character.valueOf('M'), HoverboardModItems.microcontroller, Character.valueOf('U'), HoverboardModItems.monitor, Character.valueOf('S'), Blocks.field_150486_ae, Character.valueOf('B'), HoverboardModItems.battery, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('T'), HoverboardModItems.thruster});
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_microcontroller"), new ItemStack(HoverboardModItems.microcontroller, 1), "C", "P", "M", Character.valueOf('C'), HoverboardModItems.processor, Character.valueOf('P'), HoverboardModItems.pcb, Character.valueOf('M'), HoverboardModItems.power_module);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_wrench"), new ItemStack(HoverboardModItems.wrench, 1), "  CC", "  CC", " C  ", "C   ", Character.valueOf('C'), HoverboardModItems.carbon_fibre);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_repair_kit"), new ItemStack(HoverboardModItems.repair_kit, 1), "CBLC", "CPMC", "CTFC", "CCCC", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('B'), HoverboardModItems.pcb, Character.valueOf('L'), HoverboardModItems.lights, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('M'), HoverboardModItems.monitor, Character.valueOf('T'), HoverboardModItems.thruster, Character.valueOf('F'), HoverboardModItems.pitch_fibres);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_loader"), new ItemStack(HoverboardModBlocks.loader, 1), "CGGC", "PDMP", "CSSC", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('G'), Blocks.field_150445_bS, Character.valueOf('P'), Blocks.field_150320_F, Character.valueOf('D'), Blocks.field_150367_z, Character.valueOf('M'), HoverboardModItems.power_module, Character.valueOf('S'), Blocks.field_150486_ae);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_unloader"), new ItemStack(HoverboardModBlocks.unloader, 1), "CGGC", "PHMP", "CSSC", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('G'), Blocks.field_150445_bS, Character.valueOf('P'), Blocks.field_150320_F, Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('M'), HoverboardModItems.power_module, Character.valueOf('S'), Blocks.field_150486_ae);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_charger"), new ItemStack(HoverboardModBlocks.charger, 1), new int[]{5, 6, 9, 10}, new Object[]{"DCCD", "PBBP", "PBBP", "DRRD", Character.valueOf('D'), Blocks.field_150367_z, Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('B'), HoverboardModItems.battery, Character.valueOf('R'), Blocks.field_150451_bX});
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_carbon_fibre_block"), new ItemStack(HoverboardModBlocks.carbon_fibre_block, 16), "CC", "CC", Character.valueOf('C'), HoverboardModItems.carbon_fibre);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_carbon_fibre_fence"), new ItemStack(HoverboardModBlocks.carbon_fibre_fence, 24), "I--I", "I--I", Character.valueOf('I'), HoverboardModBlocks.carbon_fibre_block, Character.valueOf('-'), HoverboardModItems.carbon_fibre);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_carbon_fibre_door"), new ItemStack(HoverboardModItems.carbon_fibre_door, 4), "CCCC", "CPPC", "CCCC", "CCCC", Character.valueOf('C'), HoverboardModBlocks.carbon_fibre_block, Character.valueOf('P'), new ItemStack((Block)Blocks.field_150397_co, 1, 15));
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_carbon_fibre_wall"), new ItemStack(HoverboardModBlocks.carbon_fibre_wall, 8), "CCCC", "CCCC", Character.valueOf('C'), HoverboardModBlocks.carbon_fibre_block);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_rocket"), new ItemStack(HoverboardModItems.upgrade, 1, 0), "CL ", "CPM", "CL ", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('L'), HoverboardModItems.rocket_launcher, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('M'), HoverboardModItems.monitor);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_thruster"), new ItemStack(HoverboardModItems.upgrade, 1, 1), "CCC", "TPM", "CCC", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('T'), HoverboardModItems.thruster, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('M'), HoverboardModItems.monitor);
        if (Config.ACTUALLY_ADDITIONS_INSTALLED && Config.RECIPES_ACTUALLY_ADDITIONS) {
            Item storageCrate = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ActuallyAdditions", "blockGiantChest"));
            if (storageCrate != null) {
                this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_storage"), new ItemStack(HoverboardModItems.upgrade, 1, 2), "PSSP", "SCCS", "SCCS", "PSSP", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('S'), storageCrate, Character.valueOf('P'), HoverboardModItems.pitch_fibres);
            } else {
                this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_storage"), new ItemStack(HoverboardModItems.upgrade, 1, 2), "PSSP", "SCCS", "SCCS", "PSSP", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('S'), Blocks.field_150486_ae, Character.valueOf('P'), HoverboardModItems.pitch_fibres);
            }
        } else {
            this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_storage"), new ItemStack(HoverboardModItems.upgrade, 1, 2), "PSSP", "SCCS", "SCCS", "PSSP", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('S'), Blocks.field_150486_ae, Character.valueOf('P'), HoverboardModItems.pitch_fibres);
        }
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_light"), new ItemStack(HoverboardModItems.upgrade, 1, 3), "PLLP", "PRRP", "PRRP", "PLLP", Character.valueOf('P'), HoverboardModItems.pitch_fibres, Character.valueOf('L'), HoverboardModItems.lights, Character.valueOf('R'), Items.field_151137_ax);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_mining"), new ItemStack(HoverboardModItems.upgrade, 1, 4), "PCCP", "S-TS", "SM#S", "PCCP", Character.valueOf('P'), Items.field_151046_w, Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('S'), Items.field_151047_v, Character.valueOf('-'), HoverboardModItems.crank, Character.valueOf('T'), Blocks.field_150331_J, Character.valueOf('M'), HoverboardModItems.monitor, Character.valueOf('#'), HoverboardModItems.power_module);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_collect"), new ItemStack(HoverboardModItems.upgrade, 1, 5), "CCCC", "EEEE", "HHHH", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('E'), Items.field_151061_bv, Character.valueOf('H'), Blocks.field_150438_bZ);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_shield"), new ItemStack(HoverboardModItems.upgrade, 1, 6), "OCCO", "CNMC", "CPDC", "OCCO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('N'), Items.field_151156_bN, Character.valueOf('M'), HoverboardModItems.monitor, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('D'), Blocks.field_150484_ah);
        if (Config.THERMAL_FOUNDATION_INSTALLED && Config.RECIPES_THERMAL_FOUNDATION) {
            ItemStack dustCryotheum = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermalfoundation", "material")), 1, 1025);
            this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_cooling"), new ItemStack(HoverboardModItems.upgrade, 1, 7), "IFFI", "C##C", "C##C", "IFFI", Character.valueOf('I'), Blocks.field_150403_cj, Character.valueOf('F'), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn, 1), (PotionType)PotionTypes.field_185242_n), Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('#'), dustCryotheum);
        } else {
            this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_cooling"), new ItemStack(HoverboardModItems.upgrade, 1, 7), "IFFI", "CIIC", "CIIC", "IFFI", Character.valueOf('I'), Blocks.field_150403_cj, Character.valueOf('F'), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn, 1), (PotionType)PotionTypes.field_185242_n), Character.valueOf('C'), HoverboardModItems.carbon_fibre);
        }
        if (Config.THERMAL_EXPANSION_INSTALLED && Config.RECIPES_THERMAL_EXPANSION) {
            ItemStack capacitor = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermalexpansion", "capacitor")), 1, 1);
            if (capacitor.func_77973_b() != null) {
                this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_capacity"), new ItemStack(HoverboardModItems.upgrade, 1, 8), "CPPC", "C##C", "CPPC", Character.valueOf('C'), HoverboardModItems.carbon_fibre, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('#'), capacitor);
            } else {
                this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_capcity"), new ItemStack(HoverboardModItems.upgrade, 1, 8), "PBBP", "BRRB", "BRRB", "PBBP", Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('B'), HoverboardModItems.battery, Character.valueOf('R'), Blocks.field_150451_bX);
            }
        } else {
            this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_cacpity"), new ItemStack(HoverboardModItems.upgrade, 1, 8), "PBBP", "BRRB", "BRRB", "PBBP", Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('B'), HoverboardModItems.battery, Character.valueOf('R'), Blocks.field_150451_bX);
        }
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_aquatic"), new ItemStack(HoverboardModItems.upgrade, 1, 9), "PAAP", "APPA", "APPA", "PAAP", Character.valueOf('P'), HoverboardModItems.pitch_fibres, Character.valueOf('A'), HoverboardModItems.aerogel);
        this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_upgrade_efficiency"), new ItemStack(HoverboardModItems.upgrade, 1, 10), " PP ", "PM#P", "PEDP", " PP ", Character.valueOf('P'), HoverboardModItems.pitch_fibres, Character.valueOf('M'), HoverboardModItems.microcontroller, Character.valueOf('#'), HoverboardModItems.power_module, Character.valueOf('E'), ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData((Enchantment)Enchantment.field_185264_b.func_148754_a(32), 4)), Character.valueOf('D'), Items.field_151045_i);
        if (Config.IC2_INSTALLED && Config.RECIPES_INDUSTRIAL_CRAFT_2) {
            this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_wrench"), new ItemStack(HoverboardModItems.wrench), "  CC", "  CC", " C  ", "C   ", Character.valueOf('C'), IC2Items.getItem((String)"crafting", (String)"carbon_plate"));
            this.addRecipe(new ResourceLocation("hoverboardmod", "recipe_repair_kit"), new ItemStack(HoverboardModItems.repair_kit, 1), "CBLC", "CPMC", "CTFC", "CCCC", Character.valueOf('C'), IC2Items.getItem((String)"crafting", (String)"carbon_plate"), Character.valueOf('B'), HoverboardModItems.pcb, Character.valueOf('L'), HoverboardModItems.lights, Character.valueOf('P'), HoverboardModItems.power_module, Character.valueOf('M'), HoverboardModItems.monitor, Character.valueOf('T'), HoverboardModItems.thruster, Character.valueOf('F'), HoverboardModItems.pitch_fibres);
        }
        Collections.sort(this.recipes, new RecipeSorter());
        this.buildTimes = new HashMap();
        this.addBuildTime(HoverboardModItems.thruster, 400);
        this.addBuildTime(HoverboardModItems.rocket_launcher, 500);
        this.addBuildTime(HoverboardModItems.hoverboard, 3000);
        this.addBuildTime(HoverboardModItems.microcontroller, 1200);
        this.addBuildTime(HoverboardModItems.repair_kit, 1500);
        this.addBuildTime(HoverboardModItems.wrench, 160);
        this.addBuildTime(Item.func_150898_a((Block)HoverboardModBlocks.loader), 600);
        this.addBuildTime(Item.func_150898_a((Block)HoverboardModBlocks.unloader), 600);
        this.addBuildTime(Item.func_150898_a((Block)HoverboardModBlocks.charger), 900);
        this.addBuildTime(Item.func_150898_a((Block)HoverboardModBlocks.carbon_fibre_block), 50);
        this.addBuildTime(Item.func_150898_a((Block)HoverboardModBlocks.carbon_fibre_fence), 300);
        this.addBuildTime(HoverboardModItems.upgrade, 0, 500);
        this.addBuildTime(HoverboardModItems.upgrade, 1, 500);
        this.addBuildTime(HoverboardModItems.upgrade, 2, 300);
        this.addBuildTime(HoverboardModItems.upgrade, 3, 40);
        this.addBuildTime(HoverboardModItems.upgrade, 4, 800);
        this.addBuildTime(HoverboardModItems.upgrade, 5, 200);
        this.addBuildTime(HoverboardModItems.upgrade, 6, 1200);
        this.addBuildTime(HoverboardModItems.upgrade, 7, 300);
        this.addBuildTime(HoverboardModItems.upgrade, 8, 600);
        this.addBuildTime(HoverboardModItems.upgrade, 9, 400);
        this.addBuildTime(HoverboardModItems.upgrade, 10, 800);
    }

    private void addBuildTime(Item item, int ticks) {
        this.addBuildTime(item, 0, ticks);
    }

    private void addBuildTime(Item item, int damage, int ticks) {
        this.buildTimes.put((Tuple2<Item, Integer>)new Tuple2((Object)item, (Object)damage), ticks);
    }

    public int getBuildTime(Item item) {
        return this.getBuildTime(item, 0);
    }

    public int getBuildTime(Item item, int itemDamage) {
        if (item == null) {
            return 200;
        }
        try {
            return this.buildTimes.get(new Tuple2((Object)item, (Object)itemDamage));
        }
        catch (NullPointerException e) {
            return 200;
        }
    }

    public void addRecipe(IRecipeBuilder recipe) {
        this.recipes.add(recipe);
    }

    public ShapedRecipesBuilder addRecipe(ResourceLocation registry, ItemStack itemStack, Object ... objectArray) {
        return this.addRecipe(registry, itemStack, (int[])null, objectArray);
    }

    public ShapedRecipesBuilder addRecipe(ResourceLocation registry, ItemStack itemStack, int[] rfItemSlots, Object ... objectArray) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (objectArray[i] instanceof String[]) {
            String[] strings = (String[])objectArray[i++];
            for (int l = 0; l < strings.length; ++l) {
                String string1 = strings[l];
                ++k;
                j = string1.length();
                s = s + string1;
            }
        } else {
            while (objectArray[i] instanceof String) {
                String string2 = (String)objectArray[i++];
                ++k;
                j = string2.length();
                s = s + string2;
            }
        }
        HashMap<Character, ItemStack> hashMap = new HashMap<Character, ItemStack>();
        while (i < objectArray.length) {
            Character character = (Character)objectArray[i];
            ItemStack itemStack1 = ItemStack.field_190927_a;
            if (objectArray[i + 1] instanceof Item) {
                itemStack1 = new ItemStack((Item)objectArray[i + 1]);
            } else if (objectArray[i + 1] instanceof Block) {
                itemStack1 = new ItemStack((Block)objectArray[i + 1], 1, Short.MAX_VALUE);
            } else if (objectArray[i + 1] instanceof ItemStack) {
                itemStack1 = (ItemStack)objectArray[i + 1];
            }
            hashMap.put(character, itemStack1);
            i += 2;
        }
        ItemStack[] itemStacks = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char character = s.charAt(i1);
            itemStacks[i1] = hashMap.containsKey(Character.valueOf(character)) ? ((ItemStack)hashMap.get(Character.valueOf(character))).func_77946_l() : ItemStack.field_190927_a;
        }
        ShapedRecipesBuilder shapedRecipes = new ShapedRecipesBuilder(registry, j, k, itemStacks, itemStack, rfItemSlots);
        this.recipes.add(shapedRecipes);
        return shapedRecipes;
    }

    public void addShapelessRecipe(ResourceLocation name, ResourceLocation group, @Nonnull ItemStack output, Ingredient ... params) {
        NonNullList lst = NonNullList.func_191196_a();
        for (Ingredient i : params) {
            lst.add((Object)i);
        }
        this.recipes.add(new ShapelessRecipes(group == null ? "" : group.toString(), output, lst).setRegistryName(name));
    }

    public ItemStack findMatchingRecipe(TileEntityHoverboardBuilder builder) {
        for (int j = 0; j < this.recipes.size(); ++j) {
            IRecipeBuilder iRecipeHoverboard = (IRecipeBuilder)this.recipes.get(j);
            if (!iRecipeHoverboard.matches(builder, builder.func_145831_w())) continue;
            return iRecipeHoverboard.getCraftingResult(builder);
        }
        return ItemStack.field_190927_a;
    }

    public List getRecipeList() {
        return this.recipes;
    }
}

