/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.crafting.builder;

import com.arkifgames.hoverboardmod.crafting.builder.IRecipeBuilder;
import com.arkifgames.hoverboardmod.tileentity.TileEntityHoverboardBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import scala.actors.threadpool.Arrays;

public class ShapedOreRecipeBuilder
implements IRecipeBuilder {
    private static final int MAX_CRAFT_GRID_WIDTH = 4;
    private static final int MAX_CRAFT_GRID_HEIGHT = 4;
    private ItemStack output = ItemStack.field_190927_a;
    private Object[] input = null;
    private int width = 0;
    private int height = 0;
    private boolean mirrored = true;
    private ResourceLocation registry;

    public ShapedOreRecipeBuilder(ResourceLocation location, Block result, Object ... recipe) {
        this(location, new ItemStack(result), recipe);
    }

    public ShapedOreRecipeBuilder(ResourceLocation location, Item result, Object ... recipe) {
        this(location, new ItemStack(result), recipe);
    }

    public ShapedOreRecipeBuilder(ResourceLocation location, ItemStack result, Object ... recipe) {
        this.registry = location;
        this.output = result.func_77946_l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    @Override
    public ItemStack getCraftingResult(TileEntityHoverboardBuilder var1) {
        return this.output.func_77946_l();
    }

    @Override
    public int getRecipeSize() {
        return this.input.length;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.output;
    }

    @Override
    public boolean matches(TileEntityHoverboardBuilder inv, World world) {
        for (int x = 0; x <= 4 - this.width; ++x) {
            for (int y = 0; y <= 4 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(TileEntityHoverboardBuilder inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.getStackInRowAndColumn(x, y);
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    Iterator itr = ((ArrayList)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public ShapedOreRecipeBuilder setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    @Override
    public List getIngredients() {
        return Arrays.asList((Object[])this.input);
    }

    @Override
    public boolean canFit(int width, int height) {
        return width * height >= this.input.length;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registry;
    }
}

