/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.crafting.builder;

import com.arkifgames.hoverboardmod.crafting.builder.IRecipeBuilder;
import com.arkifgames.hoverboardmod.tileentity.TileEntityHoverboardBuilder;
import com.arkifgames.hoverboardmod.util.Util;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ShapedRecipesBuilder
implements IRecipeBuilder {
    public final int recipeWidth;
    public final int recipeHeight;
    public final ItemStack[] recipeItems;
    private final ItemStack recipeOutput;
    private int[] targetSlots;
    private boolean copyNbtToOutput;
    private ResourceLocation registry;

    public ShapedRecipesBuilder(ResourceLocation location, int width, int height, ItemStack[] recipeItemStacks, ItemStack output, int[] targetSlots) {
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = recipeItemStacks;
        this.recipeOutput = output;
        this.targetSlots = targetSlots;
        this.registry = location;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }

    public ShapedRecipesBuilder setCopyNbt() {
        this.copyNbtToOutput = true;
        return this;
    }

    @Override
    public boolean matches(TileEntityHoverboardBuilder tileEntityHoverboardBuilder, World world) {
        for (int row = 0; row <= 4 - this.recipeWidth; ++row) {
            for (int column = 0; column <= 4 - this.recipeHeight; ++column) {
                if (this.checkMatch2(tileEntityHoverboardBuilder, row, column, true)) {
                    return true;
                }
                if (!this.checkMatch2(tileEntityHoverboardBuilder, row, column, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch2(TileEntityHoverboardBuilder tileEntityHoverboardBuilder, int par2, int par3, boolean par4) {
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                ItemStack itemStackGiven;
                int i1 = row - par2;
                int j1 = column - par3;
                ItemStack itemStackRecipe = ItemStack.field_190927_a;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    itemStackRecipe = par4 ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((itemStackGiven = tileEntityHoverboardBuilder.getStackInRowAndColumn(row, column)).func_77973_b() == Items.field_190931_a) {
                    itemStackGiven = ItemStack.field_190927_a;
                }
                if (itemStackGiven.func_190926_b() && itemStackRecipe.func_190926_b()) continue;
                if (itemStackGiven.func_190926_b() && !itemStackRecipe.func_190926_b() || !itemStackGiven.func_190926_b() && itemStackRecipe.func_190926_b()) {
                    return false;
                }
                if (itemStackRecipe.func_77973_b() != itemStackGiven.func_77973_b()) {
                    return false;
                }
                if (itemStackRecipe.func_77973_b() == Items.field_151068_bn || itemStackRecipe.func_77973_b() == Items.field_185155_bH || itemStackRecipe.func_77973_b() == Items.field_185156_bI) {
                    if (itemStackRecipe.func_77942_o() && itemStackGiven.func_77942_o()) {
                        if (!itemStackGiven.func_77978_p().func_74779_i("Potion").equals(itemStackRecipe.func_77978_p().func_74779_i("Potion"))) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (itemStackRecipe.func_77973_b() == Items.field_151134_bR) {
                    if (itemStackRecipe.func_77942_o() && itemStackGiven.func_77942_o()) {
                        if (!itemStackGiven.func_77978_p().func_74781_a("StoredEnchantments").equals((Object)itemStackRecipe.func_77978_p().func_74781_a("StoredEnchantments"))) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (itemStackRecipe.func_77952_i() == Short.MAX_VALUE || itemStackRecipe.func_77952_i() == itemStackGiven.func_77952_i()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(TileEntityHoverboardBuilder builder) {
        ItemStack itemstack = this.getRecipeOutput().func_77946_l();
        if (this.copyNbtToOutput) {
            for (int i = 0; i < builder.getSizeCrafting(); ++i) {
                ItemStack itemstack1 = builder.func_70301_a(i);
                if (itemstack1.func_190926_b() || !itemstack1.func_77942_o()) continue;
                itemstack.func_77982_d(itemstack1.func_77978_p().func_74737_b());
            }
        }
        int rf = 0;
        if (this.targetSlots != null && this.targetSlots.length > 0) {
            for (int i = 0; i < this.targetSlots.length; ++i) {
                if (builder.func_70301_a(this.targetSlots[i]).func_190926_b()) {
                    return itemstack;
                }
                ItemStack stackInSlot = builder.func_70301_a(this.targetSlots[i]);
                if (stackInSlot.func_77978_p() == null || !stackInSlot.func_77978_p().func_74764_b("Energy")) continue;
                rf += stackInSlot.func_77978_p().func_74762_e("Energy");
            }
            if (itemstack.func_77942_o()) {
                itemstack.func_77978_p().func_74768_a("Energy", rf);
            } else {
                Util.setDefaultEnergyTag(itemstack, rf);
            }
        }
        return itemstack;
    }

    @Override
    public boolean canFit(int width, int height) {
        return width * height >= this.recipeItems.length;
    }

    @Override
    public List getIngredients() {
        return Arrays.asList(this.recipeItems);
    }

    @Override
    public int getWidth() {
        return this.recipeWidth;
    }

    @Override
    public int getHeight() {
        return this.recipeHeight;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registry;
    }
}

