/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.crafting.builder;

import com.arkifgames.hoverboardmod.crafting.builder.IRecipeBuilder;
import com.arkifgames.hoverboardmod.tileentity.TileEntityHoverboardBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessOreRecipeBuilder
implements IRecipeBuilder {
    private ItemStack output = ItemStack.field_190927_a;
    private ArrayList<Object> input = new ArrayList();
    private ResourceLocation registry;

    public ShapelessOreRecipeBuilder(ResourceLocation location, Block result, Object ... recipe) {
        this(location, new ItemStack(result), recipe);
    }

    public ShapelessOreRecipeBuilder(ResourceLocation location, Item result, Object ... recipe) {
        this(location, new ItemStack(result), recipe);
    }

    public ShapelessOreRecipeBuilder(ResourceLocation location, ItemStack result, Object ... recipe) {
        this.registry = location;
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    @Override
    public int getRecipeSize() {
        return this.input.size();
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.output;
    }

    @Override
    public ItemStack getCraftingResult(TileEntityHoverboardBuilder var1) {
        return this.output.func_77946_l();
    }

    @Override
    public boolean matches(TileEntityHoverboardBuilder var1, World world) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            Iterator<Object> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof ArrayList) {
                    Iterator itr = ((ArrayList)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    @Override
    public List getIngredients() {
        return this.input;
    }

    @Override
    public boolean canFit(int width, int height) {
        return width * height >= this.input.size();
    }

    @Override
    public int getWidth() {
        return 4;
    }

    @Override
    public int getHeight() {
        return 4;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registry;
    }
}

