/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.entities;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.arkifgames.hoverboardmod.blocks.BlockCharger;
import com.arkifgames.hoverboardmod.blocks.BlockDocker;
import com.arkifgames.hoverboardmod.blocks.HoverboardModBlocks;
import com.arkifgames.hoverboardmod.client.audio.HoverboardAudio;
import com.arkifgames.hoverboardmod.client.audio.SoundEvents;
import com.arkifgames.hoverboardmod.client.model.ModelHoverboardBase;
import com.arkifgames.hoverboardmod.client.model.ModelHoverboardBottomThrusters;
import com.arkifgames.hoverboardmod.client.model.ModelHoverboardVentsLeft;
import com.arkifgames.hoverboardmod.client.model.ModelHoverboardVentsRight;
import com.arkifgames.hoverboardmod.client.model.TexturedModel;
import com.arkifgames.hoverboardmod.entities.EntityRocket;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardOptions;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardUpgrades;
import com.arkifgames.hoverboardmod.items.HoverboardModItems;
import com.arkifgames.hoverboardmod.items.ItemRepairKit;
import com.arkifgames.hoverboardmod.items.ItemUpgrade;
import com.arkifgames.hoverboardmod.items.ItemWrench;
import com.arkifgames.hoverboardmod.main.Config;
import com.arkifgames.hoverboardmod.main.Main;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketDataSync;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketKeyBoostPress;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketKeyRocketPress;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketParticle;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketShieldBounce;
import com.arkifgames.hoverboardmod.network.client.PacketShieldSync;
import com.arkifgames.hoverboardmod.network.client.PacketThrower;
import com.arkifgames.hoverboardmod.network.server.PacketHoverboardControl;
import com.arkifgames.hoverboardmod.tileentity.TileEntityHoverboardCharger;
import com.arkifgames.hoverboardmod.util.Util;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleCloud;
import net.minecraft.client.particle.ParticleFirework;
import net.minecraft.client.particle.ParticleSnowShovel;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketBlockBreakAnim;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHoverboard
extends EntityLiving
implements IInventory,
IInventoryChangedListener {
    private static final DataParameter<Integer> ROCKET_COUNT = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEAT_COUNT = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> POWER_COUNT = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ROCKET_TO_SHOOT_COUNT = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> OPTIONS = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> UPGRADES = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<String> OWNER_NAME = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> COLOR_HUE = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_BRIGHTNESS = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_SATURATION = EntityDataManager.func_187226_a(EntityHoverboard.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final String NBT_NAME = "ExtendedHoverboard";
    public static final double MAX_HEALTH = 60.0;
    public static final double KNOCKBACK_RESISTANCE = 0.0;
    public static final double MOVEMENT_SPEED = 0.75;
    public static final double MOVEMENT_SPEED_THRUSTER = 1.0;
    public static final double MOVEMENT_SPEED_LIGHTNING = 2.0;
    public static final int MAX_ROCKET_COUNT = 256;
    public static final int MIN_ROCKET_COUNT = 0;
    public static final int BUNDLE_OF_ROCKETS_COUNT = 16;
    public static final int MAX_ROCKETS_TO_SHOOT = 8;
    public static final int MIN_ROCKETS_TO_SHOOT = 0;
    public static final int DEFAULT_ROCKETS_TO_SHOOT = 2;
    public static final int MAX_HEAT_COUNT = 50000;
    public static final int MIN_HEAT_COUNT = 0;
    public static final int MAX_POWER = 0x100000;
    public static final int MIN_POWER = 0;
    public static final int MAX_POWER_TRANSFER = 4096;
    public static final int MAX_POWER_UPGRADE = 0x800000;
    public static final int MAX_POWER_TRANSFER_UPGRADE = 32768;
    public static final int HEAT_USAGE_UPWARDS = 25;
    public static final int HEAT_USAGE_COOLDOWN = 100;
    public static final int HEAT_USAGE_DEACTIVE = 50;
    public static final int HEAT_USAGE_MOVEMENT = 10;
    public static final int HEAT_USAGE_ROCKETS = 100;
    public static final int HEAT_USAGE_SHIELD = 25;
    public static final int HEAT_USAGE_MINING = 40;
    public static final int HEAT_USAGE_BOOST = 625;
    public static final int HEAT_USAGE_HOVER = 5;
    public static final int POWER_USAGE_ROCKETS = 2097;
    public static final int POWER_USAGE_MOVEMENT = 10;
    public static final int POWER_USAGE_UPWARDS = 10;
    public static final int POWER_USAGE_SHIELD = 52;
    public static final int POWER_USAGE_MINING = 209;
    public static final int POWER_USAGE_BOOST = 209;
    public static final int POWER_USAGE_HOVER = 15;
    private static final int BOOST_DURATION_TICKS = 40;
    private static final int BOOST_UNTIL_READY_TICKS = 200;
    private static int SHIELD_SIZE = 3;
    private static final DamageSource[] IMMUNITIES = new DamageSource[]{DamageSource.field_76367_g, DamageSource.field_76379_h, DamageSource.field_82729_p, DamageSource.field_76368_d, DamageSource.field_76376_m, DamageSource.field_82727_n, DamageSource.field_76366_f};
    private static final Block[] BREAKABLES = new Block[]{Blocks.field_150329_H, Blocks.field_150436_aH, Blocks.field_150395_bd, Blocks.field_150330_I, Blocks.field_150398_cm, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150398_cm};
    private int options;
    private int upgrades;
    public NonNullList<ItemStack> items;
    private int rocketReloadTimer;
    private int rocketShootTimer;
    private int boostAvailableTimer;
    private int boostDurationTimer;
    private static Set<Class<? extends Entity>> entityBlacklist = Sets.newHashSet();
    private EntityLivingBase thrower;
    private EntityLivingBase shooter;
    private List<MiningBlock> miningBlocks;
    private int powerUsage;
    private int heatGenerated;
    public float forward;
    public float strafe;
    public float verticle;
    private float efficiency;
    private HoverboardAudio hoverboardAudio;
    public boolean shouldPlaySound;
    private boolean shouldPlaySoundOnDismount;
    private int lastTick;
    private int lastTickPower;
    private int lastTickHeat;
    public float powerUsageAverage;
    public float heatGeneratedAverage;
    private boolean shieldBounce;
    @SideOnly(value=Side.CLIENT)
    public boolean isMovingForward;
    @SideOnly(value=Side.CLIENT)
    public boolean isMovingBackward;
    @SideOnly(value=Side.CLIENT)
    public boolean isMovingRight;
    @SideOnly(value=Side.CLIENT)
    public boolean isMovingLeft;
    @SideOnly(value=Side.CLIENT)
    private float longitudinalRotationDegrees;
    @SideOnly(value=Side.CLIENT)
    private float sidewaysRotationDegrees;
    @SideOnly(value=Side.CLIENT)
    private float leftVentMovement;
    @SideOnly(value=Side.CLIENT)
    private float rightVentMovement;
    private ArrayList<TexturedModel> models;
    private ArrayList<TexturedModel> modelsRenderPass;
    private boolean attemptVariant;
    public float pickaxeDegrees;
    private int startRF;
    @SideOnly(value=Side.CLIENT)
    public int seenByClientTick;
    public List<TileEntityHoverboardCharger.ChargerPos> chargers;
    private float hue;
    private float saturation;
    private float brightness;
    private float colorIntensity;
    private Color color;
    private boolean clientStaticColorSynced;

    public EntityHoverboard(World world) {
        super(world);
        this.options = HoverboardOptions.canMove.value | HoverboardOptions.displayParticles.value | HoverboardOptions.canPressRocketKey.value | HoverboardOptions.canPressBoostKey.value | HoverboardOptions.privateDock.value | HoverboardOptions.privatePilot.value | HoverboardOptions.privateStorage.value;
        this.upgrades = 0;
        this.items = NonNullList.func_191197_a((int)387, (Object)ItemStack.field_190927_a);
        this.rocketReloadTimer = 0;
        this.rocketShootTimer = 0;
        this.boostAvailableTimer = 0;
        this.boostDurationTimer = 0;
        this.miningBlocks = new ArrayList<MiningBlock>();
        this.powerUsage = 0;
        this.heatGenerated = 0;
        this.forward = 0.0f;
        this.strafe = 0.0f;
        this.verticle = 0.0f;
        this.efficiency = 0.0f;
        this.shouldPlaySound = true;
        this.shouldPlaySoundOnDismount = false;
        this.models = new ArrayList();
        this.modelsRenderPass = new ArrayList();
        this.attemptVariant = false;
        this.pickaxeDegrees = 0.0f;
        this.startRF = 0;
        this.chargers = new ArrayList<TileEntityHoverboardCharger.ChargerPos>();
        this.hue = 0.0f;
        this.saturation = 0.0f;
        this.brightness = 0.05f;
        this.colorIntensity = 0.0f;
        this.color = Color.getHSBColor(this.hue, this.saturation, this.brightness);
        this.clientStaticColorSynced = false;
        this.func_70105_a(1.5f, 0.3f);
        this.field_70178_ae = true;
        this.attemptVariant = false;
        this.func_189654_d(Config.HOVERBOARD_HOVER_MODE);
        if (world.field_72995_K) {
            this.models.add(new TexturedModel(new ModelHoverboardBase(), TexturedModel.TEXTURE_HOVERBOARD_BASE, false, false));
            this.models.add(new TexturedModel(new ModelHoverboardVentsRight(), TexturedModel.TEXTURE_VENTS, false, false));
            this.models.add(new TexturedModel(new ModelHoverboardVentsLeft(), TexturedModel.TEXTURE_VENTS, false, false));
            this.modelsRenderPass.add(new TexturedModel(new ModelHoverboardBase(), 1, true, true, "lights", 53));
            this.modelsRenderPass.add(new TexturedModel(new ModelHoverboardBottomThrusters(), TexturedModel.TEXTURE_BOTTOM_THRUSTERS, true, true));
            this.seenByClientTick = 0;
        }
        this.hoverboardAudio = new HoverboardAudio(this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.options = HoverboardOptions.canMove.value | HoverboardOptions.displayParticles.value | HoverboardOptions.canPressRocketKey.value | HoverboardOptions.canPressBoostKey.value | HoverboardOptions.privateDock.value | HoverboardOptions.privatePilot.value | HoverboardOptions.privateStorage.value;
        this.upgrades = 0;
        this.field_70180_af.func_187214_a(ROCKET_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(HEAT_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(POWER_COUNT, (Object)this.startRF);
        this.field_70180_af.func_187214_a(ROCKET_TO_SHOOT_COUNT, (Object)2);
        this.field_70180_af.func_187214_a(OPTIONS, (Object)this.options);
        this.field_70180_af.func_187214_a(UPGRADES, (Object)this.upgrades);
        this.field_70180_af.func_187214_a(OWNER, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(OWNER_NAME, (Object)"");
        this.field_70180_af.func_187214_a(COLOR_HUE, (Object)Float.valueOf(this.hue));
        this.field_70180_af.func_187214_a(COLOR_BRIGHTNESS, (Object)Float.valueOf(this.brightness));
        this.field_70180_af.func_187214_a(COLOR_SATURATION, (Object)Float.valueOf(this.saturation));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos blockPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
        this.field_70143_R = 0.0f;
        if (this.field_70170_p.field_72995_K) {
            this.spawnHeatParticles();
            this.spawnLowHealthParticles();
            if (this.getStaticColorMode()) {
                this.colorIntensity = !this.getShieldBounce() ? (this.colorIntensity > 0.25f ? (this.colorIntensity -= 0.01f) : 0.25f) : 0.5f;
                if (!this.clientStaticColorSynced) {
                    this.hue = this.getColorHue();
                    this.brightness = this.getColorBrightness();
                    this.saturation = this.getColorSaturation();
                    this.color = Color.getHSBColor(this.hue, this.saturation, this.brightness);
                    this.clientStaticColorSynced = true;
                }
            } else {
                this.updateColourClient(blockPos);
            }
        }
        this.handleLiquids(blockPos);
        if (!this.field_70170_p.field_72995_K && Config.HOVERBOARD_TERRAIN_DAMAGE) {
            IBlockState blockState = this.field_70170_p.func_180495_p(blockPos);
            for (Block block1 : BREAKABLES) {
                if (blockState.func_177230_c() != block1 && !(blockState.func_177230_c() instanceof BlockBush)) continue;
                this.field_70170_p.func_180498_a((EntityPlayer)null, 2001, blockPos, Block.func_149682_b((Block)blockState.func_177230_c()) + (blockState.func_177230_c().func_176201_c(blockState) << 12));
                blockState.func_177230_c().func_176226_b(this.field_70170_p, blockPos, blockState, 0);
                this.field_70170_p.func_175698_g(blockPos);
                break;
            }
        }
        if (this.getShield() && Config.ALLOW_SHIELD && !this.getOverheated() && this.hasPower() && this.hasUpgrade(HoverboardUpgrades.shield)) {
            this.updateShield();
        }
        if (this.getHoverMode() && this.hasPower() && !this.getOverheated() && !this.func_184207_aI()) {
            if (this.field_70170_p.field_72995_K) {
                this.spawnHoverParticles();
            }
            this.field_70181_x = 0.0;
            if (!this.field_70170_p.field_72995_K && !this.getOverheated() && this.hasPower() && !this.field_70170_p.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_185904_a().func_76220_a()) {
                this.heatGenerated += 5;
                this.powerUsage += 15;
            }
        }
        this.handleBoost();
        boolean creative = false;
        if (this.isBeingRiddenByPlayer()) {
            EntityPlayer rider = this.getPlayerRiding();
            creative = rider.field_71075_bZ.field_75098_d;
            if (!this.getOverheated() && this.hasPower() && !this.field_70170_p.field_72995_K) {
                this.heatGenerated += 5;
                this.powerUsage += 15;
            }
            if (this.field_70170_p.field_72995_K && !this.shouldPlaySoundOnDismount) {
                this.shouldPlaySoundOnDismount = true;
            }
            if (this.field_70170_p.field_72995_K && !Main.KEY_DOWN_PRESSED) {
                this.spawnHoverParticles();
            }
            if (!(this.field_70170_p.func_180495_p(blockPos).func_185904_a().func_76224_d() || !this.field_70170_p.func_175710_j(blockPos) || creative || this.getMiningMode() || this.getHoverMode() || this.field_71093_bK == -1)) {
                if (!Config.HOVERBOARD_HOVER_MODE) {
                    this.field_70181_x = MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.1f - (float)Math.PI)) * 0.025f;
                } else {
                    this.handleHover(blockPos);
                }
            } else if (!this.field_70170_p.func_175710_j(blockPos) || creative || this.getMiningMode() || this.getHoverMode() || this.field_71093_bK == -1) {
                this.field_70181_x = 0.0;
            }
            if (Config.ALLOW_COLLECT_ITEMS && this.getCollectItems() && this.hasPower() && this.hasUpgrade(HoverboardUpgrades.item_collection)) {
                this.suckItems(rider);
            }
            if (this.field_70170_p.field_72995_K) {
                float yOffset;
                IBlockState block;
                this.hoverboardAudio.playRidingSounds(rider);
                if (Main.KEY_UP_PRESSED && this.field_70163_u < (double)this.field_70170_p.func_72800_K() && this.getCanMove() && !this.getOverheated() && this.hasPower() && rider == Minecraft.func_71410_x().field_71439_g && !(block = this.field_70170_p.func_180495_p(blockPos.func_177963_a(0.0, (double)(yOffset = this.getMiningMode() ? 2.2f : 2.5f), 0.0))).func_185904_a().func_76220_a()) {
                    PacketDispatcher.sendToServer(new PacketHoverboardControl(true));
                }
                if (Main.KEY_DOWN_PRESSED && this.getCanMove() && !this.getOverheated() && rider == Minecraft.func_71410_x().field_71439_g) {
                    PacketDispatcher.sendToServer(new PacketHoverboardControl(false));
                    this.spawnParticles();
                }
            }
            this.handleRockets(rider, blockPos);
            this.handleLightSource(blockPos);
            this.handleMiningMode(rider);
        } else {
            if (!(this.field_70170_p.field_72995_K || this.getHoverMode() || this.getOverheated())) {
                this.heatGenerated -= 50;
            }
            if (!this.field_70170_p.field_72995_K && this.func_189652_ae() && Config.HOVERBOARD_HOVER_MODE && !this.getHoverMode()) {
                this.func_189654_d(false);
            }
            if (this.field_70170_p.field_72995_K && this.shouldPlaySoundOnDismount) {
                this.dismountEntity();
                this.shouldPlaySoundOnDismount = false;
            }
        }
        if (this.field_70163_u < -64.0) {
            this.func_174812_G();
        }
        if (this.field_70163_u > 256.0) {
            this.field_70181_x -= this.field_70163_u - 64.0 > 2.0 ? 2.0 : this.field_70163_u - 64.0;
        }
        if (this.getCurrentHeat() >= 50000) {
            this.setOverheated(true);
            if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() != Blocks.field_150353_l && this.field_70170_p.func_180495_p(blockPos).func_177230_c() != Blocks.field_150356_k && this.field_70170_p.field_72995_K) {
                this.hoverboardAudio.playOverheatSound(null);
            }
        }
        if (this.getOverheated()) {
            this.setCanMove(false);
            if (Config.HOVERBOARD_HOVER_MODE && this.func_189652_ae() && !this.func_184207_aI()) {
                this.func_189654_d(false);
            }
            if (!this.field_70122_E && this.func_184207_aI()) {
                this.field_70181_x -= 0.75;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.heatGenerated -= 100;
            }
            if (this.getCurrentHeat() <= 25000) {
                this.setOverheated(false);
                this.field_70170_p.func_184133_a((EntityPlayer)null, blockPos, SoundEvents.HOVERBOARD_REBOOT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                this.field_70170_p.func_184133_a((EntityPlayer)null, blockPos, SoundEvents.HOVERBOARD_FUNCTIONAL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                this.setCanMove(true);
            }
        }
        if (!this.hasPower()) {
            this.setCanMove(false);
            if (Config.HOVERBOARD_HOVER_MODE && this.func_189652_ae() && !this.func_184207_aI()) {
                this.func_189654_d(false);
            }
            if (!this.field_70122_E && this.func_184207_aI()) {
                this.field_70181_x -= 0.75;
            }
        } else if (this.hasPower() && !this.getOverheated() && !this.getCanMove()) {
            this.setCanMove(true);
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70301_a(0).func_190926_b() && ((ItemStack)this.items.get(0)).func_77973_b() instanceof IEnergyContainerItem) {
            int maxEnergyReceived = Math.min(this.getMaxPower() - this.getCurrentPower(), this.getMaxPowerTransfer());
            IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)((ItemStack)this.items.get(0)).func_77973_b();
            int extract = energyContainerItem.extractEnergy((ItemStack)this.items.get(0), maxEnergyReceived, true);
            if (extract > maxEnergyReceived) {
                energyContainerItem.extractEnergy((ItemStack)this.items.get(0), maxEnergyReceived, false);
                this.addPower(maxEnergyReceived);
            } else {
                energyContainerItem.extractEnergy((ItemStack)this.items.get(0), extract, false);
                this.addPower(extract);
            }
        }
        if (this.hasUpgrade(HoverboardUpgrades.rocket) && !this.func_70301_a(1).func_190926_b() && this.func_70301_a(1).func_77973_b() == HoverboardModItems.rocket_ammunition && this.getCurrentRockets() <= 240) {
            this.func_70301_a(1).func_190918_g(1);
            if (this.func_70301_a(1).func_190916_E() <= 0) {
                this.func_70299_a(1, ItemStack.field_190927_a);
            }
            this.addRockets(16);
        }
        if (this.field_70170_p.field_72995_K) {
            for (TexturedModel modelTexture : this.models) {
                modelTexture.onUpdate();
            }
            for (TexturedModel modelTexture : this.modelsRenderPass) {
                modelTexture.onUpdate();
            }
        }
        this.efficiency = this.hasUpgrade(HoverboardUpgrades.efficiency) ? (float)((69.59071681 - 9.9662E-4 * (double)this.getCurrentHeat()) / (1.0 - 2.56417459E-5 * (double)this.getCurrentHeat() + 2.18881246E-10 * Math.pow(this.getCurrentHeat(), 2.0))) : (float)((17.72536396 - 1.1927E-4 * (double)this.getCurrentHeat()) / (1.0 - 4.93418749E-5 * (double)this.getCurrentHeat() + 7.35856896E-10 * Math.pow(this.getCurrentHeat(), 2.0)));
        if (!this.field_70170_p.field_72995_K) {
            if (!creative) {
                this.setCurrentPower(this.getCurrentPower() - Math.round((float)this.powerUsage * ((100.0f - this.efficiency) * 0.01f + 1.0f)));
            }
            this.powerUsage = 0;
            if (this.hasUpgrade(HoverboardUpgrades.cooling) && !this.getOverheated()) {
                this.heatGenerated = this.getCurrentHeat() > 30000 && this.heatGenerated > 1 && this.boostDurationTimer <= 0 && (this.rocketShootTimer > this.getCurrentRocketsToShoot() * 3 + 1 || this.rocketShootTimer == 0) ? 2 : MathHelper.func_76141_d((float)((float)this.heatGenerated * 0.25f));
            }
            if (this.field_71093_bK == -1 && this.heatGenerated > 1 && this.boostDurationTimer <= 0 && (this.rocketShootTimer > this.getCurrentRocketsToShoot() * 3 + 1 || this.rocketShootTimer == 0)) {
                this.heatGenerated *= 2;
            }
            if (!creative || this.getOverheated()) {
                this.setCurrentHeat(this.getCurrentHeat() + (this.heatGenerated > 0 ? Math.round((float)this.heatGenerated * ((100.0f - this.efficiency) * 0.01f + 1.0f)) : this.heatGenerated));
            }
            this.heatGenerated = 0;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa == this.lastTick + 200 && this.lastTick != 0) {
                this.powerUsageAverage = this.lastTickPower > this.getCurrentPower() ? (float)(this.lastTickPower - this.getCurrentPower()) / 200.0f : 0.0f;
                this.heatGeneratedAverage = this.getCurrentHeat() > this.lastTickHeat ? (float)(this.getCurrentHeat() - this.lastTickHeat) / 200.0f : 0.0f;
            }
            if (this.field_70173_aa >= this.lastTick + 200) {
                this.lastTick = this.field_70173_aa;
                this.lastTickPower = this.getCurrentPower();
                this.lastTickHeat = this.getCurrentHeat();
            }
            for (int i = 0; i < this.chargers.size(); ++i) {
                if (!(this.chargers.get(i).distanceSq((Vec3i)blockPos) > 25.0) && this.field_70170_p.func_180495_p(this.chargers.get(i).toBlockPos()).func_177230_c() instanceof BlockCharger) continue;
                this.chargers.remove(i);
            }
        }
        if (this.field_70170_p.field_72995_K && !this.attemptVariant) {
            if (this.getOwnerName() != null && !this.getOwnerName().equals("") && "Arkif".equals(this.getOwnerName())) {
                this.models.set(0, new TexturedModel(new ModelHoverboardBase(), TexturedModel.TEXTURE_HOVERBOARD_BASE_VARIANT, false, false));
            }
            this.attemptVariant = true;
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.isBeingRiddenByPlayer() && this.func_82171_bF()) {
            EntityPlayer rider = this.getPlayerRiding();
            this.field_70126_B = this.field_70177_z = rider.field_70177_z;
            this.field_70125_A = rider.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            this.forward = forward;
            this.strafe = strafe;
            if (this.getCanMove()) {
                this.strafe = rider.field_70702_br * (this.hasUpgrade(HoverboardUpgrades.thruster) ? 0.7f : 0.4f);
                this.forward = rider.field_191988_bg;
                if (this.field_70122_E) {
                    this.forward *= 0.25f;
                    this.strafe *= 0.25f;
                }
            }
            if (this.forward <= 0.0f) {
                this.forward *= 0.2f;
            }
            if (this.field_70170_p.field_72995_K) {
                this.calculateRotations();
            }
            if (this.forward != 0.0f || this.strafe != 0.0f) {
                if (this.field_70170_p.field_72995_K && this.getCanMove() && this.forward > 0.0f && !this.func_82150_aj()) {
                    PacketDispatcher.sendToServer(new PacketParticle(this.func_145782_y(), 0, false));
                }
                if (!rider.field_71075_bZ.field_75098_d) {
                    this.powerUsage += 10;
                    this.heatGenerated += 10;
                }
            } else if (this.field_70170_p.field_72995_K && this.getCanMove()) {
                this.spawnParticles();
                this.spawnSuctionParticles(true);
            }
            this.field_70138_W = 0.5f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(this.strafe, vertical, this.forward);
            }
        } else {
            this.forward = forward;
            this.strafe = strafe;
            if (this.field_70170_p.field_72995_K) {
                this.calculateRotations();
            }
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public boolean func_70072_I() {
        return false;
    }

    private void handleLiquids(BlockPos blockPos) {
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer rider;
            if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() == Blocks.field_150355_j || this.field_70170_p.func_180495_p(blockPos).func_177230_c() == Blocks.field_150358_i) {
                if (this.isBeingRiddenByPlayer()) {
                    rider = this.getPlayerRiding();
                    if (!rider.field_71075_bZ.field_75098_d && !this.hasUpgrade(HoverboardUpgrades.aquatic)) {
                        this.func_70097_a(DamageSource.field_76369_e, this.func_110138_aP() / 20.0f);
                    }
                } else if (!this.hasUpgrade(HoverboardUpgrades.aquatic)) {
                    this.func_70097_a(DamageSource.field_76369_e, this.func_110138_aP() / 20.0f);
                }
                this.setCurrentHeat(this.getCurrentHeat() - 500);
            }
            if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() == Blocks.field_150353_l || this.field_70170_p.func_180495_p(blockPos) == Blocks.field_150356_k) {
                if (this.isBeingRiddenByPlayer()) {
                    rider = this.getPlayerRiding();
                    if (!rider.field_71075_bZ.field_75098_d) {
                        this.func_70097_a(DamageSource.field_76371_c, this.func_110138_aP() / (float)(this.hasUpgrade(HoverboardUpgrades.aquatic) ? 30 : 10));
                    }
                } else {
                    this.func_70097_a(DamageSource.field_76371_c, this.func_110138_aP() / 10.0f);
                }
                this.setCurrentHeat(this.getCurrentHeat() + 50000 / (this.hasUpgrade(HoverboardUpgrades.aquatic) ? 500 : 100));
            }
            if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof BlockLiquid) {
                this.field_70159_w *= this.hasUpgrade(HoverboardUpgrades.aquatic) ? 0.75 : (double)0.2f;
                double d = this.field_70181_x = this.hasUpgrade(HoverboardUpgrades.aquatic) ? 0.0 : (double)0.15f;
                if (!this.func_184207_aI()) {
                    this.field_70181_x = 0.15f;
                }
                this.field_70179_y *= this.hasUpgrade(HoverboardUpgrades.aquatic) ? 0.75 : (double)0.2f;
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound properties = new NBTTagCompound();
        if (this.getOwnerName() == null || this.getOwnerName().equals("")) {
            if (this.getOwnerEntity() == null) {
                properties.func_74778_a("OwnerName", "");
            } else {
                properties.func_74778_a("OwnerName", this.getOwnerEntity().func_70005_c_());
            }
        } else {
            properties.func_74778_a("OwnerName", this.getOwnerName());
        }
        if (this.getOwnerUUID() == null) {
            properties.func_74778_a("OwnerUUID", "");
        } else {
            properties.func_74778_a("OwnerUUID", this.getOwnerUUID().toString());
        }
        properties.func_74776_a("ColorSaturation", this.getColorBrightness());
        properties.func_74776_a("ColorBrightness", this.getColorSaturation());
        properties.func_74776_a("ColorHue", this.getColorHue());
        properties.func_74768_a("Upgrades", this.getUpgrades());
        properties.func_74768_a("Options", this.getOptions());
        properties.func_74768_a("RocketsToShoot", this.getCurrentRocketsToShoot());
        properties.func_74768_a("CurrentRockets", this.getCurrentRockets());
        properties.func_74768_a("CurrentHeat", this.getCurrentHeat());
        properties.func_74768_a("CurrentPower", this.getCurrentPower());
        Util.saveAllItems(properties, this.items, true);
        compound.func_74782_a(NBT_NAME, (NBTBase)properties);
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(NBT_NAME);
        if (properties == null) {
            return;
        }
        if (properties.func_74764_b("OwnerName")) {
            this.setOwnerName(properties.func_74779_i("OwnerName"));
        }
        if (properties.func_150297_b("OwnerUUID", 8)) {
            s = properties.func_74779_i("OwnerUUID");
        } else {
            String s1 = properties.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            this.setOwner(UUID.fromString(s));
        }
        this.setUpgrades(properties.func_74762_e("Upgrades"));
        this.setOptions(properties.func_74762_e("Options"));
        this.setCurrentRocketsToShoot(properties.func_74762_e("RocketsToShoot"));
        this.setCurrentRockets(properties.func_74762_e("CurrentRockets"));
        this.setCurrentHeat(properties.func_74762_e("CurrentHeat"));
        this.setCurrentPower(properties.func_74762_e("CurrentPower"));
        this.setColorSaturation(properties.func_74760_g("ColorSaturation"));
        this.setColorBrightness(properties.func_74760_g("ColorBrightness"));
        this.setColorHue(properties.func_74760_g("ColorHue"));
        IAttributeInstance iattributeinstance = this.func_110140_aT().func_111152_a("Speed");
        if (iattributeinstance != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(iattributeinstance.func_111125_b() * 0.25);
        }
        this.items = NonNullList.func_191197_a((int)387, (Object)ItemStack.field_190927_a);
        Util.loadAllItems(properties, this.items);
        this.func_189654_d(Config.HOVERBOARD_HOVER_MODE);
    }

    protected void func_110147_ax() {
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111265_b).func_111128_a(0.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111267_a);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111266_c);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111263_d);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188791_g);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_189429_h);
        this.func_110140_aT().func_111150_b(SWIM_SPEED);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.75);
        this.func_110148_a(SWIM_SPEED).func_111128_a(4.5);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(0.0);
    }

    public boolean func_70097_a(DamageSource damageSource, float par2) {
        for (DamageSource damageSource2 : IMMUNITIES) {
            if (damageSource != damageSource2) continue;
            return false;
        }
        return this.func_184207_aI() && this.getEntityRiding().equals((Object)damageSource.func_76346_g()) ? false : super.func_70097_a(damageSource, par2);
    }

    protected void func_70665_d(DamageSource damageSource, float par2) {
        if (!damageSource.func_82725_o()) {
            super.func_70665_d(damageSource, par2);
        }
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    public boolean shouldDismountInWater(Entity rider) {
        if (rider instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)rider;
            if (player.field_71075_bZ.field_75098_d || this.hasUpgrade(HoverboardUpgrades.aquatic)) {
                return false;
            }
            this.setHoverMode(false);
            return true;
        }
        this.setHoverMode(false);
        return true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70601_bi() {
        return false;
    }

    public int func_70641_bl() {
        return 0;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack currentHeldItem = player.field_71071_by.func_70448_g();
        if (player.func_70093_af()) {
            if (this.getPrivateStorage()) {
                if (this.getOwnerUUID() != null && this.getOwnerUUID().equals(player.func_110124_au())) {
                    this.openGUI(player);
                    return true;
                }
            } else {
                this.openGUI(player);
            }
        } else {
            if (!currentHeldItem.func_190926_b() && (currentHeldItem.func_77973_b() instanceof ItemWrench || currentHeldItem.func_77973_b() instanceof ItemUpgrade || currentHeldItem.func_77973_b() instanceof ItemRepairKit || currentHeldItem.func_77973_b() instanceof ItemLead)) {
                return false;
            }
            if (!this.func_184207_aI()) {
                if (this.getPrivatePilot()) {
                    if (this.getOwnerUUID() != null && this.getOwnerUUID().equals(player.func_110124_au())) {
                        this.mountEntity(player);
                        return true;
                    }
                } else {
                    this.mountEntity(player);
                    return true;
                }
            }
        }
        return false;
    }

    private void mountEntity(EntityPlayer player) {
        if (this.getPrivatePilot() && !player.func_110124_au().equals(this.getOwnerUUID())) {
            return;
        }
        this.func_189654_d(Config.HOVERBOARD_HOVER_MODE);
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        this.shouldPlaySound = true;
        if (!this.field_70170_p.field_72995_K) {
            if (this.hasPower()) {
                this.field_70170_p.func_184133_a((EntityPlayer)null, new BlockPos((Entity)this), SoundEvents.HOVERBOARD_MOUNT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            player.func_184220_m((Entity)this);
        }
        this.setMiningMode(false);
    }

    private void dismountEntity() {
    }

    public void func_70645_a(DamageSource damageSource) {
        if (!this.field_70170_p.field_72995_K) {
            this.dropChestItems();
            this.dropDeathItems();
        }
        super.func_70645_a(damageSource);
    }

    public void func_70691_i(float amount) {
    }

    public void repair(float amount) {
        if (this.field_70170_p.field_72995_K) {
            this.spawnRepairParticles(5);
        }
        this.func_70642_aH();
        super.func_70691_i(amount);
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        return potionEffect.func_188419_a() == MobEffects.field_76441_p;
    }

    public void func_70077_a(EntityLightningBolt entityLightningBolt) {
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f, false);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(2.0);
        if (this.func_110143_aJ() > 0.0f) {
            this.func_70606_j(1.0f);
            this.setCurrentPower(this.getMaxPower());
        }
    }

    protected int func_70693_a(EntityPlayer p_70693_1_) {
        return this.func_184207_aI() ? 5 + this.field_70170_p.field_73012_v.nextInt(15) : 0;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_110167_bD() {
        return false;
    }

    protected void func_110159_bB() {
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public Entity func_110166_bE() {
        return null;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public boolean func_184218_aH() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O + 0.1;
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(HoverboardModItems.hoverboard);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.chargers.isEmpty() && (!this.getShield() || !Config.ALLOW_SHIELD || !this.hasPower() || this.getOverheated()) ? this.func_174813_aQ() : this.func_174813_aQ().func_186662_g(4.0);
    }

    public AxisAlignedBB func_174813_aQ() {
        return super.func_174813_aQ();
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean isBeingRiddenByPlayer() {
        return super.func_184207_aI() && this.func_184188_bt().get(0) instanceof EntityPlayer;
    }

    public EntityPlayer getPlayerRiding() {
        if (this.isBeingRiddenByPlayer()) {
            return (EntityPlayer)this.func_184188_bt().get(0);
        }
        return null;
    }

    public Entity getEntityRiding() {
        if (this.func_184207_aI()) {
            return (Entity)this.func_184188_bt().get(0);
        }
        return null;
    }

    private void handleHover(BlockPos blockPos) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getOverheated() || this.getCurrentPower() <= 0) {
                return;
            }
            float distanceAboveSolidBlock = 0.0f;
            float targetHoverHeight = Config.HOVERBOARD_HOVER_HEIGHT;
            int xMin = -1;
            int xMax = 2;
            int zMin = -1;
            int zMax = 2;
            float facingX = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float facingZ = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            if (MathHelper.func_76135_e((float)facingX) > 0.45f && this.boostDurationTimer > 0) {
                if (MathHelper.func_76135_e((float)this.forward) > 0.1f) {
                    xMin = -2;
                    xMax = 3;
                }
                if (MathHelper.func_76135_e((float)this.strafe) > 0.1f) {
                    zMin = -2;
                    zMax = 3;
                }
            }
            if (MathHelper.func_76135_e((float)facingZ) > 0.45f && this.boostAvailableTimer > 0) {
                if (MathHelper.func_76135_e((float)this.forward) > 0.1f) {
                    zMin = -2;
                    zMax = 3;
                }
                if (MathHelper.func_76135_e((float)this.strafe) > 0.1f) {
                    xMin = -2;
                    xMax = 3;
                }
            }
            block0: for (int y = MathHelper.func_76128_c((double)this.field_70163_u); y > 0; --y) {
                for (int x = xMin; x < xMax; ++x) {
                    for (int z = zMin; z < zMax; ++z) {
                        BlockPos blockPosHover = new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t + (double)x)), y, MathHelper.func_76128_c((double)(this.field_70161_v + (double)z)));
                        IBlockState blockStateAtOrBelow = this.field_70170_p.func_180495_p(blockPosHover);
                        IBlockState blockStateAbove = this.field_70170_p.func_180495_p(blockPosHover.func_177982_a(0, 1, 0));
                        if ((blockStateAtOrBelow.func_185904_a().func_76230_c() || blockStateAtOrBelow.func_185904_a().func_76224_d() || blockStateAtOrBelow.func_185904_a() == Material.field_151597_y || blockStateAtOrBelow.func_185904_a() == Material.field_151593_r) && !blockStateAbove.func_185904_a().func_76230_c() && !blockStateAbove.func_185904_a().func_76224_d() && blockStateAbove.func_185904_a() != Material.field_151597_y && blockStateAbove.func_185904_a() != Material.field_151593_r) {
                            AxisAlignedBB blockCollision = blockStateAtOrBelow.func_185890_d((IBlockAccess)this.field_70170_p, blockPos);
                            if (blockCollision != null) {
                                distanceAboveSolidBlock = (float)this.field_70163_u - (float)y - (float)blockCollision.field_72337_e;
                                break block0;
                            }
                            distanceAboveSolidBlock = (float)this.field_70163_u - (float)y - 0.5f;
                            break block0;
                        }
                        if (MathHelper.func_76128_c((double)this.field_70163_u) - y <= MathHelper.func_76123_f((float)targetHoverHeight)) continue;
                        distanceAboveSolidBlock = MathHelper.func_76123_f((float)targetHoverHeight) + 1;
                        break block0;
                    }
                }
            }
            float hoverHeightStableRange = this.field_70131_O;
            this.field_70181_x = distanceAboveSolidBlock < targetHoverHeight ? MathHelper.func_151237_a((double)((double)(targetHoverHeight - distanceAboveSolidBlock) * 1.2), (double)0.5, (double)1.0) : (distanceAboveSolidBlock > targetHoverHeight + hoverHeightStableRange ? MathHelper.func_151237_a((double)((double)(targetHoverHeight - distanceAboveSolidBlock) * 1.2), (double)-0.3, (double)-0.1) : (this.field_70181_x > (double)0.001f ? (this.field_70181_x *= 0.25) : (this.field_70181_x < (double)-0.001f ? (this.field_70181_x *= 0.25) : 0.0)));
        }
    }

    public int func_70302_i_() {
        return this.hasUpgrade(HoverboardUpgrades.storage) ? EntityHoverboard.getInventorySizeWithUpgrade() : EntityHoverboard.getInventorySizeWithoutUpgrade();
    }

    public void setSizeInventory(int invSize) {
    }

    public ItemStack func_70301_a(int i) {
        return i < this.items.size() ? (ItemStack)this.items.get(i) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int i, int count) {
        if (!this.func_70301_a(i).func_190926_b()) {
            if (this.func_70301_a(i).func_190916_E() <= count) {
                ItemStack itemstack = this.func_70301_a(i);
                this.func_70299_a(i, ItemStack.field_190927_a);
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.func_70301_a(i).func_77979_a(count);
            if (this.func_70301_a(i).func_190916_E() == 0) {
                this.func_70299_a(i, ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.items.set(i, (Object)itemStack);
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() == 0) {
            this.items.set(i, (Object)ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70112_a(double p_70112_1_) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_70092_e(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer entityPlayer) {
    }

    public void func_174886_c(EntityPlayer entityPlayer) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_70296_d() {
        if (this.field_70170_p != null) {
            this.field_70170_p.func_72870_g((Entity)this);
        }
    }

    public boolean getCollectItems() {
        return (this.getOptions() & HoverboardOptions.canCollectItems.value) == HoverboardOptions.canCollectItems.value;
    }

    public void setCollectItems(boolean bool) {
        if (bool) {
            this.setOptions(this.getOptions() | HoverboardOptions.canCollectItems.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.canCollectItems.value);
        }
    }

    private void suckItems(EntityPlayer player) {
        float distanceXZ = 12.0f;
        float distanceY = 12.0f;
        double maxspeedXZ = 1.0;
        double maxspeedY = 1.0;
        double speedXZ = 0.1;
        double speedY = 0.1;
        List entities = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b((double)distanceXZ, (double)distanceY, (double)distanceXZ));
        if (entities != null && !entities.isEmpty()) {
            for (EntityItem item : entities) {
                if (item == null || this.isInventoryFull(item.func_92059_d()) && this.isPlayerInventoryFull(player, item.func_92059_d())) continue;
                double dx = this.field_70165_t - item.field_70165_t;
                double dy = this.field_70163_u - item.field_70163_u + 1.0;
                double dz = this.field_70161_v - item.field_70161_v;
                double absxz = Math.sqrt(dx * dx + dz * dz);
                double absy = Math.abs(dy);
                if (absxz > (double)distanceXZ) continue;
                if (absxz > 1.0) {
                    dx /= absxz;
                    dz /= absxz;
                }
                if (absy > 1.0) {
                    dy /= absy;
                }
                double vx = item.field_70159_w + speedXZ * dx;
                double vy = item.field_70181_x + speedY * dy;
                double vz = item.field_70179_y + speedXZ * dz;
                double absvxz = Math.sqrt(vx * vx + vz * vz);
                double absvy = Math.abs(vy);
                double rationspeedxz = absvxz / maxspeedXZ;
                if (rationspeedxz > 1.0) {
                    vx /= rationspeedxz;
                    vz /= rationspeedxz;
                }
                double rationspeedy = absvy / maxspeedY;
                if (absvy > 1.0) {
                    vy /= rationspeedy;
                }
                item.field_70159_w = vx;
                item.field_70181_x = vy;
                item.field_70179_y = vz;
                if (!(absxz < 1.0) || item.field_145804_b > 0 || item.field_70128_L || !this.isPlayerInventoryFull(player, item.func_92059_d())) continue;
                this.onCollideWithHoverboard(this, item);
            }
        }
    }

    public boolean isPlayerInventoryFull(EntityPlayer player, ItemStack itemStack) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_() - 5; ++i) {
            if (player.field_71071_by.func_70301_a(i).func_190926_b()) {
                return false;
            }
            if (!this.stackEqualExact(player.field_71071_by.func_70301_a(i), itemStack) || player.field_71071_by.func_70301_a(i).func_190916_E() >= itemStack.func_77976_d() || !itemStack.func_77985_e() || player.field_71071_by.func_70301_a(i).func_190916_E() >= this.func_70297_j_()) continue;
            return false;
        }
        return true;
    }

    public boolean isInventoryFull(ItemStack itemStack) {
        for (int i = 2; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) {
                return false;
            }
            if (!this.stackEqualExact(this.func_70301_a(i), itemStack) || this.func_70301_a(i).func_190916_E() >= itemStack.func_77976_d() || !itemStack.func_77985_e() || this.func_70301_a(i).func_190916_E() >= this.func_70297_j_()) continue;
            return false;
        }
        return true;
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private void onCollideWithHoverboard(EntityHoverboard hoverboard, EntityItem item) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack itemstack = item.func_92059_d();
            boolean needsUpdate = false;
            if (itemstack.func_190916_E() > 0 && item.field_145804_b <= 0 && (item.func_145798_i() == null || item.func_145798_i().equals(hoverboard.getOwnerEntity().func_70005_c_()))) {
                for (int i = 2; i < this.func_70302_i_(); ++i) {
                    if (!this.func_70301_a(i).func_190926_b() && this.stackEqualExact(this.func_70301_a(i), itemstack) && this.func_70301_a(i).func_190916_E() < this.func_70297_j_() && this.func_70301_a(i).func_77976_d() > this.func_70301_a(i).func_190916_E()) {
                        int sizeMaxToAdd = itemstack.func_77976_d() - this.func_70301_a(i).func_190916_E();
                        if (sizeMaxToAdd >= itemstack.func_190916_E()) {
                            ((ItemStack)this.items.get(i)).func_190917_f(itemstack.func_190916_E());
                            itemstack.func_190920_e(0);
                            item.func_70106_y();
                        } else {
                            ((ItemStack)this.items.get(i)).func_190917_f(sizeMaxToAdd);
                            itemstack.func_190918_g(sizeMaxToAdd);
                        }
                        needsUpdate = true;
                        break;
                    }
                    if (!this.func_70301_a(i).func_190926_b()) continue;
                    this.items.set(i, (Object)itemstack);
                    item.func_70106_y();
                    needsUpdate = true;
                    break;
                }
            }
            if (needsUpdate) {
                // empty if block
            }
        }
    }

    public boolean addStackToInventory(ItemStack itemStack, int quantityToAdd) {
        int i;
        for (i = EntityHoverboard.getInventoryStart(); i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b() || !this.stackEqualExact(this.func_70301_a(i), itemStack) || this.func_70301_a(i).func_190916_E() >= this.func_70301_a(i).func_77976_d() || this.func_70301_a(i).func_190916_E() >= this.func_70297_j_()) continue;
            int freeSpace = this.func_70301_a(i).func_77976_d() - this.func_70301_a(i).func_190916_E();
            if (freeSpace >= quantityToAdd) {
                if (itemStack.func_190916_E() >= quantityToAdd) {
                    this.func_70301_a(i).func_190917_f(quantityToAdd);
                    itemStack.func_190918_g(quantityToAdd);
                    return true;
                }
                this.func_70301_a(i).func_190917_f(itemStack.func_190916_E());
                itemStack.func_190920_e(0);
                return true;
            }
            if (itemStack.func_190916_E() >= freeSpace) {
                this.func_70301_a(i).func_190917_f(freeSpace);
                itemStack.func_190918_g(freeSpace);
                return true;
            }
            this.func_70301_a(i).func_190917_f(itemStack.func_190916_E());
            itemStack.func_190920_e(0);
            return true;
        }
        for (i = EntityHoverboard.getInventoryStart(); i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            if (itemStack.func_190916_E() <= quantityToAdd) {
                if (itemStack.func_190916_E() > itemStack.func_77976_d()) continue;
                this.items.set(i, (Object)itemStack.func_77946_l());
                itemStack.func_190920_e(0);
                return true;
            }
            this.items.set(i, (Object)itemStack.func_77946_l());
            this.func_70301_a(i).func_190920_e(quantityToAdd);
            itemStack.func_190918_g(quantityToAdd);
            return true;
        }
        return false;
    }

    public boolean transferStackToInventory(NonNullList<ItemStack> buffer, int stacksToAdd, ItemStack itemStack) {
        int i;
        for (i = 0; i < buffer.size(); ++i) {
            if (((ItemStack)buffer.get(i)).func_190926_b() || ((ItemStack)buffer.get(i)).func_77973_b() != itemStack.func_77973_b() || ((ItemStack)buffer.get(i)).func_77952_i() != itemStack.func_77952_i() || ((ItemStack)buffer.get(i)).func_190916_E() >= ((ItemStack)buffer.get(i)).func_77976_d()) continue;
            int freeSpace = ((ItemStack)buffer.get(i)).func_77976_d() - ((ItemStack)buffer.get(i)).func_190916_E();
            if (freeSpace >= stacksToAdd) {
                if (itemStack.func_190916_E() >= stacksToAdd) {
                    ((ItemStack)buffer.get(i)).func_190917_f(stacksToAdd);
                    itemStack.func_190918_g(stacksToAdd);
                    return true;
                }
                ((ItemStack)buffer.get(i)).func_190917_f(itemStack.func_190916_E());
                itemStack.func_190920_e(0);
                return true;
            }
            if (itemStack.func_190916_E() >= freeSpace) {
                ((ItemStack)buffer.get(i)).func_190917_f(freeSpace);
                itemStack.func_190918_g(freeSpace);
                return true;
            }
            ((ItemStack)buffer.get(i)).func_190917_f(itemStack.func_190916_E());
            itemStack.func_190920_e(0);
            return true;
        }
        for (i = 0; i < buffer.size(); ++i) {
            if (!((ItemStack)buffer.get(i)).func_190926_b()) continue;
            if (itemStack.func_190916_E() <= stacksToAdd && itemStack.func_190916_E() > 0) {
                if (itemStack.func_190916_E() > itemStack.func_77976_d()) continue;
                buffer.set(i, (Object)itemStack.func_77946_l());
                itemStack.func_190920_e(0);
                return true;
            }
            if (itemStack.func_190916_E() <= 0) continue;
            buffer.set(i, (Object)itemStack.func_77946_l());
            ((ItemStack)buffer.get(i)).func_190920_e(stacksToAdd);
            itemStack.func_190918_g(stacksToAdd);
            return true;
        }
        return false;
    }

    public static int getInventoryStart() {
        return 2;
    }

    public static int getInventorySizeWithoutUpgrade() {
        return 27;
    }

    public static int getInventorySizeWithUpgrade() {
        return 387;
    }

    public boolean getDisplayParticles() {
        return (this.getOptions() & HoverboardOptions.displayParticles.value) == HoverboardOptions.displayParticles.value;
    }

    public void setDisplayParticles(boolean particles) {
        this.setOptions(this.getOptions() | HoverboardOptions.displayParticles.value);
        PacketDispatcher.sendToServer(new PacketDataSync(this.func_145782_y(), HoverboardOptions.displayParticles, particles ? (byte)1 : 0));
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnMissileParticles(int side, double positionX, double positionY, double positionZ) {
        if (this.getDisplayParticles()) {
            double d3 = this.getRocketX(side);
            double d4 = this.getRocketY();
            double d5 = this.getRocketZ(side);
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d3, d4, d5, -this.field_70159_w, 0.0, -this.field_70179_y, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnThrusterParticles() {
        if (this.getDisplayParticles() && !this.func_82150_aj()) {
            int i;
            float d3 = MathHelper.func_76134_b((float)((this.field_70177_z + 90.0f) / 180.0f * (float)Math.PI)) * 1.75f;
            float d5 = MathHelper.func_76126_a((float)((this.field_70177_z + 90.0f) / 180.0f * (float)Math.PI)) * 1.75f;
            for (i = 0; i < 16; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, (double)d3 - this.field_70159_w, this.field_70163_u - (double)0.85f, (double)d5 - this.field_70179_y, this.field_70146_Z.nextGaussian() * 2.0, 0.1, this.field_70146_Z.nextGaussian() * 2.0, new int[0]);
            }
            if (this.hasUpgrade(HoverboardUpgrades.thruster)) {
                for (i = 0; i < 3; ++i) {
                    float yOffset = Util.remap(0.0f, 10.0f, 0.2f, 0.5f, this.longitudinalRotationDegrees);
                    ParticleSnowShovel.Factory factory = new ParticleSnowShovel.Factory();
                    Particle snow = factory.func_178902_a(EnumParticleTypes.SNOW_SHOVEL.func_179348_c(), this.field_70170_p, this.field_70165_t - (double)d3, this.field_70163_u + (double)yOffset + (double)(Main.KEY_UP_PRESSED ? -0.3f : 0.0f), this.field_70161_v - (double)d5, (double)(-1.0f * d3 * 0.5f - (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f), (double)(0.05f - (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f), (double)(-1.0f * d5 * 0.5f - (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f), new int[0]);
                    snow.func_70538_b(this.getRed() * 0.35f + 0.65f, this.getGreen() * 0.35f + 0.65f, this.getBlue() * 0.35f + 0.65f);
                    snow.func_82338_g(0.6f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(snow);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnHoverParticles() {
        if (this.getDisplayParticles() && !this.func_82150_aj() && Minecraft.func_71410_x().field_71474_y.field_74362_aa < 2) {
            try {
                double d3 = this.field_70165_t - (double)MathHelper.func_76134_b((float)((this.field_70761_aq + 90.0f) / 180.0f * (float)Math.PI)) * 0.7;
                double d4 = this.field_70163_u + 0.0;
                double d5 = this.field_70161_v - (double)MathHelper.func_76126_a((float)((this.field_70761_aq + 90.0f) / 180.0f * (float)Math.PI)) * 0.7;
                double d6 = this.field_70165_t - (double)MathHelper.func_76134_b((float)((this.field_70761_aq + -90.0f) / 180.0f * (float)Math.PI)) * 0.7;
                double d7 = this.field_70163_u + 0.0;
                double d8 = this.field_70161_v - (double)MathHelper.func_76126_a((float)((this.field_70761_aq + -90.0f) / 180.0f * (float)Math.PI)) * 0.7;
                for (int i = 0; i < 1; ++i) {
                    ParticleSnowShovel.Factory factory = new ParticleSnowShovel.Factory();
                    Particle cloudFront = factory.func_178902_a(EnumParticleTypes.SNOW_SHOVEL.func_179348_c(), this.field_70170_p, d6 - this.field_70159_w, d7 - (double)(Main.KEY_UP_PRESSED ? 0.35f : 0.0f), d8 - this.field_70179_y, -this.field_70159_w * 0.1 + this.field_70146_Z.nextGaussian() * 0.01, Main.KEY_DOWN_PRESSED ? -0.4 : -0.2, -this.field_70179_y * 0.1 + this.field_70146_Z.nextGaussian() * 0.01, new int[0]);
                    Particle cloudBack = factory.func_178902_a(EnumParticleTypes.SNOW_SHOVEL.func_179348_c(), this.field_70170_p, d3 - this.field_70159_w, d4 - (double)(Main.KEY_UP_PRESSED ? 0.35f : 0.0f), d5 - this.field_70179_y, -this.field_70159_w * 0.1 + this.field_70146_Z.nextGaussian() * 0.01, Main.KEY_DOWN_PRESSED ? -0.4 : -0.2, -this.field_70179_y * 0.1 + this.field_70146_Z.nextGaussian() * 0.01, new int[0]);
                    cloudBack.func_70538_b(this.getRed() * 0.75f + 0.25f, this.getGreen() * 0.75f + 0.25f, this.getBlue() * 0.75f + 0.25f);
                    cloudFront.func_70538_b(this.getRed() * 0.75f + 0.25f, this.getGreen() * 0.75f + 0.25f, this.getBlue() * 0.75f + 0.25f);
                    cloudBack.func_82338_g(0.4f);
                    cloudFront.func_82338_g(0.4f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(cloudBack);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(cloudFront);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnSuctionParticles(boolean rand) {
        int randomNo;
        if (this.getDisplayParticles() && ((randomNo = this.field_70170_p.field_73012_v.nextInt(100)) == 1 && rand || !rand)) {
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5, -1.0, 0.5, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, -0.5, -1.0, -0.5, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, -0.5, -1.0, 0.5, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5, -1.0, -0.5, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, -1.0, 1.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, -1.0, -1.0, -1.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, -1.0, -1.0, 1.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, -1.0, -1.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.5, -1.0, 1.5, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, -1.5, -1.0, -1.5, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, -1.5, -1.0, 1.5, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.5, -1.0, -1.5, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0, -1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, -2.0, -1.0, -2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, -2.0, -1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0, -1.0, -2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0, -1.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, -2.0, -1.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, -1.0, -2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, -1.0, 2.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_INSTANT, this.field_70165_t, this.field_70163_u - 0.5, this.field_70161_v, this.field_70170_p.field_73012_v.nextGaussian(), 0.0, this.field_70170_p.field_73012_v.nextGaussian(), new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        if (this.getDisplayParticles() && !this.func_82150_aj()) {
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v, this.field_70146_Z.nextGaussian(), -4.0, this.field_70146_Z.nextGaussian(), new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnHeatParticles() {
        try {
            int amount = Math.round((float)(this.getCurrentHeat() + 1) * 1.5E-4f);
            if (this.getDisplayParticles() && !this.func_82150_aj()) {
                double d2;
                double d1;
                double d0;
                int i;
                for (i = 0; i < amount; ++i) {
                    d0 = this.field_70146_Z.nextGaussian() * 0.0;
                    d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.0f) - (double)this.field_70130_N + 0.75, this.field_70163_u - 0.2 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.0f) - (double)this.field_70130_N + 0.75, d0, d1, d2, new int[0]);
                }
                if (amount >= 6 && this.field_70146_Z.nextInt(3) == 2) {
                    for (i = 0; i < 1; ++i) {
                        d0 = this.field_70146_Z.nextGaussian() * 0.0;
                        d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.0f) - (double)this.field_70130_N + 0.75, this.field_70163_u - 0.2 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 1.0f) - (double)this.field_70130_N + 0.75, d0, d1, d2, new int[0]);
                    }
                }
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnLowHealthParticles() {
        int amount = Math.round((30.0f - this.func_110143_aJ()) / 30.0f * 5.0f);
        if (this.getDisplayParticles() && !this.func_82150_aj()) {
            for (int i = 0; i < amount - (this.field_70173_aa % 2 == 0 ? amount : 0); ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.05;
                double d1 = this.field_70146_Z.nextGaussian() * 0.05;
                double d2 = this.field_70146_Z.nextGaussian() * 0.05;
                this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t + d0, this.field_70163_u + d2 * 1.5, this.field_70161_v + d2, d0, d1, d2, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnRepairParticles(int amount) {
        if (this.getDisplayParticles() && !this.func_82150_aj()) {
            for (int i = 0; i < amount; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.5;
                double d1 = this.field_70146_Z.nextGaussian() * 0.5;
                double d2 = this.field_70146_Z.nextGaussian() * 0.5;
                this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + d2 * 1.5, this.field_70161_v + this.field_70146_Z.nextGaussian(), d0, d1, d2, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void createParticleBall(double speed, int size, boolean trail, boolean flicker, Entity ent) {
        if (this.getDisplayParticles()) {
            double d1 = ent.field_70165_t;
            double d2 = ent.field_70163_u + 0.75;
            double d3 = ent.field_70161_v;
            for (int j = -size; j <= size; ++j) {
                for (int k = -size; k <= size; ++k) {
                    for (int l = -size; l <= size; ++l) {
                        double d4 = (double)k + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                        double d5 = (double)j + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                        double d6 = (double)l + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.5;
                        double d7 = (double)MathHelper.func_76133_a((double)(d4 * d4 + d5 * d5 + d6 * d6)) / speed + this.field_70146_Z.nextGaussian() * 0.05;
                        this.createParticle(d1, d2, d3, d4 / d7, d5 / d7, d6 / d7, trail, flicker);
                        if (j == -size || j == size || k == -size || k == size) continue;
                        l += size * 2 - 1;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void createParticle(double x, double y, double z, double velX, double velY, double velZ, boolean trail, boolean flicker) {
        ParticleFirework.Factory factory = new ParticleFirework.Factory();
        ParticleFirework.Spark entityfireworksparkfx = (ParticleFirework.Spark)factory.func_178902_a(EnumParticleTypes.FIREWORKS_SPARK.func_179348_c(), this.field_70170_p, x, y, z, velX, velY, velZ, new int[0]);
        entityfireworksparkfx.func_92045_e(trail);
        entityfireworksparkfx.func_92043_f(flicker);
        entityfireworksparkfx.func_70538_b(this.getRed(), this.getGreen(), this.getBlue());
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)entityfireworksparkfx);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnBoostParticles() {
        if (this.boostDurationTimer > 0) {
            float d3 = MathHelper.func_76134_b((float)((this.field_70177_z + 90.0f) / 180.0f * (float)Math.PI)) * 1.75f;
            float d5 = MathHelper.func_76126_a((float)((this.field_70177_z + 90.0f) / 180.0f * (float)Math.PI)) * 1.75f;
            for (int i = 0; i < 10; ++i) {
                ParticleCloud.Factory factory = new ParticleCloud.Factory();
                Particle cloud = factory.func_178902_a(EnumParticleTypes.CLOUD.func_179348_c(), this.field_70170_p, this.field_70165_t - (double)d3 - this.field_70159_w, this.field_70163_u, this.field_70161_v - (double)d5 - this.field_70179_y, (double)(-1.0f * d3 * 0.5f - (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f), (double)(0.05f - (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f), (double)(-1.0f * d5 * 0.5f - (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.1f), new int[0]);
                cloud.func_70538_b(this.getRed() * 0.75f + 0.25f, this.getGreen() * 0.75f + 0.25f, this.getBlue() * 0.75f + 0.25f);
                cloud.func_82338_g(1.0f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a(cloud);
            }
        }
    }

    public boolean getStaticColorMode() {
        return (this.getOptions() & HoverboardOptions.colorMode.value) == HoverboardOptions.colorMode.value;
    }

    public void setColorMode(boolean bool) {
        if (bool) {
            this.setOptions(this.getOptions() | HoverboardOptions.colorMode.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.colorMode.value);
        }
    }

    public void setColorHue(float hue) {
        this.field_70180_af.func_187227_b(COLOR_HUE, (Object)Float.valueOf(hue));
        if (this.field_70170_p.field_72995_K) {
            this.hue = hue;
            this.color = Color.getHSBColor(hue, this.saturation, this.brightness);
        }
    }

    public float getColorHue() {
        return ((Float)this.field_70180_af.func_187225_a(COLOR_HUE)).floatValue();
    }

    public void setColorBrightness(float brightness) {
        this.field_70180_af.func_187227_b(COLOR_BRIGHTNESS, (Object)Float.valueOf(brightness));
        if (this.field_70170_p.field_72995_K) {
            this.brightness = brightness;
            this.color = Color.getHSBColor(this.hue, this.saturation, brightness);
        }
    }

    public float getColorBrightness() {
        return ((Float)this.field_70180_af.func_187225_a(COLOR_BRIGHTNESS)).floatValue();
    }

    public void setColorSaturation(float saturation) {
        this.field_70180_af.func_187227_b(COLOR_SATURATION, (Object)Float.valueOf(saturation));
        if (this.field_70170_p.field_72995_K) {
            this.saturation = saturation;
            this.color = Color.getHSBColor(this.hue, saturation, this.brightness);
        }
    }

    public float getColorSaturation() {
        return ((Float)this.field_70180_af.func_187225_a(COLOR_SATURATION)).floatValue();
    }

    @SideOnly(value=Side.CLIENT)
    public float getRed() {
        return (float)this.color.getRed() / 255.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getGreen() {
        return (float)this.color.getGreen() / 255.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getBlue() {
        return (float)this.color.getBlue() / 255.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getColourIntensity() {
        return this.colorIntensity;
    }

    @SideOnly(value=Side.CLIENT)
    public void setClientColorSynced(boolean synced) {
        this.clientStaticColorSynced = synced;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateColourClient(BlockPos blockPos) {
        if (this.field_70170_p.field_72995_K) {
            if ((this.func_184207_aI() || this.getHoverMode() && !this.field_70170_p.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_185904_a().func_76220_a() || this.getShield() || this.field_70170_p.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockDocker) && this.hasPower()) {
                this.hue += 0.001f;
                if (this.hue >= 1.0f) {
                    this.hue = 0.0f;
                }
                this.saturation = this.saturation >= 0.99f ? 1.0f : (this.saturation += 0.01f);
                this.brightness = this.forward > 0.5f ? (this.brightness >= 0.99f ? (this.brightness -= 0.01f) : (this.brightness += 0.01f)) : (this.brightness >= 0.6f ? (this.brightness -= 0.01f) : (this.brightness += 0.02f));
            } else {
                if (this.saturation > 0.0f) {
                    this.saturation -= 0.01f;
                }
                if (this.saturation < 0.0f) {
                    this.saturation = 0.0f;
                }
                if (this.brightness > 0.3f) {
                    this.brightness -= 0.01f;
                }
                if (this.brightness < 0.3f) {
                    this.brightness = 0.3f;
                }
            }
            this.colorIntensity = !this.getShieldBounce() ? (this.colorIntensity > 0.25f ? (this.colorIntensity -= 0.01f) : 0.25f) : 0.5f;
            this.color = Color.getHSBColor(this.hue, this.saturation, this.brightness);
            this.clientStaticColorSynced = false;
        }
    }

    private void updateShield() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.isBeingRiddenByPlayer()) {
                EntityPlayer rider = this.getPlayerRiding();
                if (!rider.field_71075_bZ.field_75098_d) {
                    this.powerUsage += 52;
                    this.heatGenerated += 25;
                }
            } else {
                this.powerUsage += 52;
                this.heatGenerated += 25;
            }
        }
        AxisAlignedBB alignedBB = new AxisAlignedBB(this.func_70046_E().field_72340_a, this.func_70046_E().field_72338_b, this.func_70046_E().field_72339_c, this.func_70046_E().field_72336_d, this.func_70046_E().field_72337_e + 1.0, this.func_70046_E().field_72334_f);
        alignedBB = alignedBB.func_186662_g((double)SHIELD_SIZE);
        List entities = this.field_70170_p.func_72839_b((Entity)this, alignedBB);
        for (int iNeedARewrite = 0; iNeedARewrite < entities.size(); ++iNeedARewrite) {
            Entity ent = (Entity)entities.get(iNeedARewrite);
            if (!entityBlacklist.contains(ent.getClass())) {
                Vec3i r;
                double distance;
                Vec3i t;
                Vec3i p;
                if (ent instanceof EntityLiving || ent instanceof IProjectile) {
                    if (!(ent instanceof IMob) && !(ent instanceof IProjectile) || ent instanceof EntityArrow && ((EntityArrow)ent).field_70254_i) continue;
                    if (this.isBeingRiddenByPlayer()) {
                        EntityPlayer rider = this.getPlayerRiding();
                        if (ent instanceof EntityArrow && ((EntityArrow)ent).field_70250_c == rider || ent instanceof EntityThrowable && !(ent instanceof EntityRocket) && ((EntityThrowable)ent).func_85052_h() == rider || this.thrower == rider) continue;
                        if (ent instanceof EntityRocket && ((EntityRocket)ent).getShooterIDHoverboard() == this.func_145782_y()) {
                            PacketDispatcher.sendTo(new PacketThrower(((EntityRocket)ent).getShooterIDPlayer(), 0), (EntityPlayerMP)rider);
                            continue;
                        }
                        if (this.shooter == rider) continue;
                    }
                    this.setShieldBouncePacket(true);
                    if (!this.field_70170_p.field_72995_K) {
                        p = new Vec3i(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        t = new Vec3i(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                        distance = p.func_185332_f(t.func_177958_n(), t.func_177956_o(), t.func_177952_p()) + 0.1;
                        r = new Vec3i(t.func_177958_n() - p.func_177958_n(), t.func_177956_o() - p.func_177956_o(), t.func_177952_p() - p.func_177952_p());
                        ent.field_70159_w += (double)r.func_177958_n() / 0.5 / distance;
                        ent.field_70181_x += (double)r.func_177956_o() / 0.5 / distance;
                        ent.field_70179_y += (double)r.func_177952_p() / 0.5 / distance;
                        PacketDispatcher.sendToAllAround(new PacketShieldSync(this.func_145782_y(), ent.func_145782_y()), this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0);
                    }
                    if (!(ent instanceof IProjectile) || this.field_70170_p.field_72995_K) continue;
                    PacketDispatcher.sendToAllAround(new PacketParticle(this.func_145782_y(), 2, false), this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
                    continue;
                }
                if (ent instanceof EntityFireball) {
                    this.setShieldBouncePacket(true);
                    if (!this.field_70170_p.field_72995_K) {
                        p = new Vec3i(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        t = new Vec3i(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                        distance = p.func_185332_f(t.func_177958_n(), t.func_177956_o(), t.func_177952_p()) + 0.1;
                        r = new Vec3i(t.func_177958_n() - p.func_177958_n(), t.func_177956_o() - p.func_177956_o(), t.func_177952_p() - p.func_177952_p());
                        ent.field_70159_w += (double)r.func_177958_n() / 0.5 / distance;
                        ent.field_70181_x += (double)r.func_177956_o() / 0.5 / distance;
                        ent.field_70179_y += (double)r.func_177952_p() / 0.5 / distance;
                        PacketDispatcher.sendToAllAround(new PacketShieldSync(this.func_145782_y(), ent.func_145782_y()), this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0);
                    }
                    if (this.field_70170_p.field_72995_K) continue;
                    PacketDispatcher.sendToAllAround(new PacketParticle(this.func_145782_y(), 2, false), this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
                    continue;
                }
                if (!this.getShieldBounce()) continue;
                this.setShieldBouncePacket(false);
                continue;
            }
            if (!this.getShieldBounce()) continue;
            this.setShieldBouncePacket(false);
        }
        if (entities.isEmpty() && this.getShieldBounce()) {
            this.setShieldBouncePacket(false);
        }
    }

    public boolean getShield() {
        return (this.getOptions() & HoverboardOptions.shield.value) == HoverboardOptions.shield.value;
    }

    public void setShield(boolean bool) {
        if (bool) {
            this.setOptions(this.getOptions() | HoverboardOptions.shield.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.shield.value);
        }
    }

    private void setShieldBouncePacket(boolean bool) {
        if (!this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToAllAround(new PacketShieldBounce(this.func_145782_y(), bool), this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        } else {
            PacketDispatcher.sendToServer(new PacketShieldBounce(this.func_145782_y(), bool));
        }
    }

    public void setShieldBounce(boolean bool) {
        this.shieldBounce = bool;
    }

    public boolean getShieldBounce() {
        return this.shieldBounce;
    }

    public void setThrower(int entityID) {
        this.thrower = (EntityLivingBase)this.field_70170_p.func_73045_a(entityID);
    }

    public void setShooter(int entityID) {
        this.shooter = (EntityLivingBase)this.field_70170_p.func_73045_a(entityID);
    }

    private void handleMiningMode(EntityPlayer rider) {
        if (this.getMiningMode() && Config.ALLOW_MINING && this.hasPower() && !this.getOverheated() && this.hasUpgrade(HoverboardUpgrades.mining)) {
            int mineSize = 1;
            int id = 0;
            for (int iX = -mineSize; iX <= mineSize; ++iX) {
                for (int iY = -mineSize; iY <= mineSize + 1; ++iY) {
                    for (int iZ = -mineSize; iZ <= mineSize; ++iZ) {
                        --id;
                        int x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)iX));
                        int y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)iY));
                        int z = MathHelper.func_76128_c((double)(this.field_70161_v + (double)iZ));
                        BlockPos blockPos = new BlockPos(x, y, z);
                        IBlockState iBlockHit = this.field_70170_p.func_180495_p(blockPos);
                        Block blockHit = this.field_70170_p.func_180495_p(blockPos).func_177230_c();
                        if (blockHit == Blocks.field_150357_h || blockHit == Blocks.field_150407_cf || blockHit == Blocks.field_150474_ac || blockHit == Blocks.field_150378_br || blockHit instanceof BlockContainer || iBlockHit.func_185904_a() != Material.field_151576_e && iBlockHit.func_185904_a() != Material.field_151578_c && iBlockHit.func_185904_a() != Material.field_151571_B && iBlockHit.func_185904_a() != Material.field_151595_p && iBlockHit.func_185904_a() != Material.field_151577_b) continue;
                        if (this.field_70170_p.field_72995_K) {
                            this.pickaxeDegrees = this.field_70170_p.field_73012_v.nextFloat() * 45.0f;
                            continue;
                        }
                        boolean prevId = true;
                        int breakAmount = 1;
                        for (int j = 0; j < this.miningBlocks.size(); ++j) {
                            if (this.miningBlocks.get((int)j).x != x || this.miningBlocks.get((int)j).y != y || this.miningBlocks.get((int)j).z != z) continue;
                            id = this.miningBlocks.get((int)j).id;
                            ++this.miningBlocks.get((int)j).breakAmount;
                            prevId = false;
                            if (breakAmount <= 9) continue;
                            this.field_70170_p.func_180498_a((EntityPlayer)null, 2001, blockPos, Block.func_149682_b((Block)blockHit) + (blockHit.func_176201_c(iBlockHit) << 12));
                            blockHit.func_176226_b(this.field_70170_p, blockPos, iBlockHit, 0);
                            this.field_70170_p.func_175698_g(blockPos);
                            if (!rider.field_71075_bZ.field_75098_d) {
                                this.powerUsage += 209;
                                this.heatGenerated += 40;
                            }
                            this.miningBlocks.remove(j);
                        }
                        if (prevId) {
                            this.miningBlocks.add(new MiningBlock(id, x, y, z, breakAmount));
                        }
                        ((EntityPlayerMP)rider).field_71135_a.func_147359_a((Packet)new SPacketBlockBreakAnim(-5000 + id, blockPos, breakAmount));
                    }
                }
            }
        }
    }

    public boolean getMiningMode() {
        return (this.getOptions() & HoverboardOptions.miningMode.value) == HoverboardOptions.miningMode.value;
    }

    public void setMiningMode(boolean bool) {
        if (bool) {
            this.setOptions(this.getOptions() | HoverboardOptions.miningMode.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.miningMode.value);
        }
    }

    public boolean getHoverMode() {
        return (this.getOptions() & HoverboardOptions.hoverMode.value) == HoverboardOptions.hoverMode.value;
    }

    public void setHoverMode(boolean bool) {
        if (bool) {
            this.setOptions(this.getOptions() | HoverboardOptions.hoverMode.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.hoverMode.value);
        }
    }

    public boolean getPrivatePilot() {
        return (this.getOptions() & HoverboardOptions.privatePilot.value) == HoverboardOptions.privatePilot.value;
    }

    public void setPrivatePilot(boolean bool) {
        if (bool) {
            this.setOptions(this.getOptions() | HoverboardOptions.privatePilot.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.privatePilot.value);
        }
    }

    public boolean getPrivateStorage() {
        return (this.getOptions() & HoverboardOptions.privateStorage.value) == HoverboardOptions.privateStorage.value;
    }

    public void setPrivateStorage(boolean bool) {
        if (bool) {
            this.setOptions(this.getOptions() | HoverboardOptions.privateStorage.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.privateStorage.value);
        }
    }

    public boolean getPrivateDock() {
        return (this.getOptions() & HoverboardOptions.privateDock.value) == HoverboardOptions.privateDock.value;
    }

    public void setPrivateDock(boolean bool) {
        if (bool) {
            this.setOptions(this.getOptions() | HoverboardOptions.privateDock.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.privateDock.value);
        }
    }

    private void handleLightSource(BlockPos blockPos) {
        float f;
        if (this.getLightSource() && Config.ALLOW_LIGHT_SOURCE && !this.field_70170_p.field_72995_K && this.hasPower() && this.hasUpgrade(HoverboardUpgrades.light) && (f = this.func_70013_c()) < Config.CAVE_LIGHT_BRIGHTNESS && this.field_70170_p.func_180495_p(blockPos).func_185904_a() == Material.field_151579_a && this.field_70163_u > 0.0 && !this.field_70170_p.func_175710_j(blockPos)) {
            this.field_70170_p.func_175656_a(blockPos, HoverboardModBlocks.light_source.func_176223_P());
        }
    }

    public void setLightSource(boolean light) {
        if (light) {
            this.setOptions(this.getOptions() | HoverboardOptions.lightSource.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.lightSource.value);
        }
    }

    public boolean getLightSource() {
        return (this.getOptions() & HoverboardOptions.lightSource.value) == HoverboardOptions.lightSource.value;
    }

    public void setCanMove(boolean move) {
        if (move) {
            this.setOptions(this.getOptions() | HoverboardOptions.canMove.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.canMove.value);
        }
    }

    public boolean getCanMove() {
        return (this.getOptions() & HoverboardOptions.canMove.value) == HoverboardOptions.canMove.value;
    }

    public final void addPower(int amount) {
        this.setCurrentPower(this.getCurrentPower() + amount);
    }

    public final int getMaxPower() {
        return this.hasUpgrade(HoverboardUpgrades.energy_capacity) ? 0x800000 : 0x100000;
    }

    public final int getMaxPowerTransfer() {
        return this.hasUpgrade(HoverboardUpgrades.energy_capacity) ? 4096 : 32768;
    }

    public final int getCurrentPower() {
        return (Integer)this.field_70180_af.func_187225_a(POWER_COUNT);
    }

    public final void setCurrentPower(int amount) {
        this.field_70180_af.func_187227_b(POWER_COUNT, (Object)(amount > 0 ? (amount < this.getMaxPower() ? amount : this.getMaxPower()) : 0));
    }

    public final boolean hasPower() {
        return this.getCurrentPower() > 0;
    }

    public int getPowerUsage() {
        return this.powerUsage;
    }

    public int getSpaceForPower(int maxReceive) {
        return Math.min(this.getMaxPower() - this.getCurrentPower(), Math.min(this.getMaxPowerTransfer(), maxReceive));
    }

    public int getExtractPower(int maxExtract) {
        return Math.min(this.getCurrentPower(), Math.min(this.getMaxPowerTransfer(), maxExtract));
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public final void removeHeat(int amount) {
        this.setCurrentHeat(this.getCurrentHeat() - amount);
    }

    public final int getCurrentHeat() {
        return (Integer)this.field_70180_af.func_187225_a(HEAT_COUNT);
    }

    public final void setCurrentHeat(int amount) {
        this.field_70180_af.func_187227_b(HEAT_COUNT, (Object)(amount > 0 ? (amount < 50000 ? amount : 50000) : 0));
    }

    public void setOverheated(boolean overheated) {
        if (overheated) {
            this.setOptions(this.getOptions() | HoverboardOptions.overheated.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.overheated.value);
        }
    }

    public final boolean getOverheated() {
        return (this.getOptions() & HoverboardOptions.overheated.value) == HoverboardOptions.overheated.value;
    }

    public int getHeatGenerated() {
        return this.heatGenerated;
    }

    private void handleRockets(EntityPlayer rider, BlockPos blockPos) {
        if (this.hasUpgrade(HoverboardUpgrades.rocket)) {
            if ((this.field_70170_p.field_72995_K && this.getCurrentRocketsToShoot() <= this.getCurrentRockets() && this.getCurrentRocketsToShoot() > 0 && this.hasPower() && !this.getOverheated() || rider.field_71075_bZ.field_75098_d && this.getCurrentRocketsToShoot() > 0) && Main.KEY_ROCKET_PRESSED && this.getCanPressRocketKey() && rider == Minecraft.func_71410_x().field_71439_g) {
                PacketDispatcher.sendToServer(new PacketKeyRocketPress(this.func_145782_y(), false, 0, 1));
                this.setCanPressRocketKey(false);
                this.rocketReloadTimer = 0;
                this.rocketShootTimer = 0;
            }
            if (!this.field_70170_p.field_72995_K && !this.getCanPressRocketKey()) {
                float f = 10.0f;
                float f1 = 5.0f;
                double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - (double)f), (double)(this.field_70165_t + (double)f));
                double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - (double)f1), (double)(this.field_70163_u + (double)f1));
                double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - (double)f), (double)(this.field_70161_v + (double)f));
                for (int i = 0; i != this.getCurrentRocketsToShoot(); ++i) {
                    boolean even = (i & 1) == 0;
                    if (this.rocketShootTimer != i * 3 + 1) continue;
                    this.spawnRockets((even ? 1 : 0) + 1, d0, d1, d2, rider);
                    PacketDispatcher.sendToAllAround(new PacketParticle(this.func_145782_y(), 1, even), rider, 64.0);
                    if (rider.field_71075_bZ.field_75098_d) continue;
                    this.setCurrentRockets(this.getCurrentRockets() == 0 ? 0 : this.getCurrentRockets() - 1);
                    this.powerUsage += 2097;
                    this.heatGenerated += 100;
                }
                ++this.rocketShootTimer;
                ++this.rocketReloadTimer;
                if (this.rocketReloadTimer >= this.getCurrentRocketsToShoot() * 20) {
                    PacketDispatcher.sendTo(new PacketKeyRocketPress(this.func_145782_y(), true, 0, 1), (EntityPlayerMP)rider);
                    this.setCanPressRocketKey(true);
                    if (this.getCurrentRocketsToShoot() <= this.getCurrentRockets() && this.field_70170_p.func_73045_a(this.func_145782_y()) != null || rider.field_71075_bZ.field_75098_d) {
                        this.field_70170_p.func_184133_a((EntityPlayer)null, blockPos, SoundEvents.HOVERBOARD_READY, SoundCategory.NEUTRAL, 1.0f, this.field_70146_Z.nextFloat() * 0.3f + 0.85f);
                    }
                }
            }
        }
    }

    public final int getCurrentRocketsToShoot() {
        return (Integer)this.field_70180_af.func_187225_a(ROCKET_TO_SHOOT_COUNT);
    }

    public final void setCurrentRocketsToShoot(int amount) {
        this.field_70180_af.func_187227_b(ROCKET_TO_SHOOT_COUNT, (Object)(amount > 0 ? (amount < 8 ? amount : 8) : 0));
    }

    public final void addRockets(int amount) {
        this.setCurrentRockets(this.getCurrentRockets() + amount);
    }

    public final void removeRockets(int amount) {
        this.setCurrentRockets(this.getCurrentRockets() - amount);
    }

    public final int getCurrentRockets() {
        return (Integer)this.field_70180_af.func_187225_a(ROCKET_COUNT);
    }

    public final void setCurrentRockets(int amount) {
        this.field_70180_af.func_187227_b(ROCKET_COUNT, (Object)(amount > 0 ? (amount < 256 ? amount : 256) : 0));
    }

    private void spawnRockets(int side, double positionX, double positionY, double positionZ, EntityPlayer rider) {
        if (!this.field_70170_p.field_72995_K) {
            double d3 = this.getRocketX(side);
            double d4 = this.getRocketY();
            double d5 = this.getRocketZ(side);
            EntityRocket entityRocket = new EntityRocket(this.field_70170_p, rider, this.func_145782_y());
            entityRocket.field_70163_u = d4;
            entityRocket.field_70165_t = d3;
            entityRocket.field_70161_v = d5;
            entityRocket.field_70159_w += this.field_70159_w * 0.75;
            entityRocket.field_70181_x += this.field_70181_x * 0.75;
            entityRocket.field_70179_y += this.field_70179_y * 0.75;
            this.field_70170_p.func_72838_d((Entity)entityRocket);
        }
    }

    public double getRocketX(int side) {
        if (side <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (side - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 0.75;
    }

    public double getRocketY() {
        return this.field_70163_u + 0.1;
    }

    public double getRocketZ(int side) {
        if (side <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (side - 1))) / 180.0f * (float)Math.PI;
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 0.75;
    }

    public void setCanPressRocketKey(boolean canPressKey) {
        if (canPressKey) {
            this.setOptions(this.getOptions() | HoverboardOptions.canPressRocketKey.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.canPressRocketKey.value);
        }
    }

    public final boolean getCanPressRocketKey() {
        return (this.getOptions() & HoverboardOptions.canPressRocketKey.value) == HoverboardOptions.canPressRocketKey.value;
    }

    public void setTimerReload(int i) {
        this.rocketReloadTimer = i;
    }

    public void setTimerShoot(int i) {
        this.rocketShootTimer = i;
    }

    private void handleBoost() {
        if (this.hasUpgrade(HoverboardUpgrades.thruster)) {
            if (this.field_70170_p.field_72995_K && this.isBeingRiddenByPlayer()) {
                EntityPlayer rider = this.getPlayerRiding();
                if ((this.hasPower() && !this.getOverheated() || rider.field_71075_bZ.field_75098_d) && Main.KEY_BOOST_PRESSED && this.getCanPressBoostKey() && rider == Minecraft.func_71410_x().field_71439_g) {
                    PacketDispatcher.sendToServer(new PacketKeyBoostPress(this.func_145782_y(), false, 200, 40));
                    this.hoverboardAudio.playBoostSounds(rider);
                    this.setCanPressBoostKey(false);
                    this.boostAvailableTimer = 200;
                    this.boostDurationTimer = 40;
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                if (!this.getCanPressBoostKey()) {
                    if (this.boostDurationTimer > 0) {
                        --this.boostDurationTimer;
                        float motionXCalc = MathHelper.func_76126_a((float)((float)Math.toRadians(MathHelper.func_76135_e((float)this.field_70177_z))));
                        float motionZCalc = 180.0f - MathHelper.func_76134_b((float)((float)Math.toRadians(MathHelper.func_76135_e((float)this.field_70177_z))));
                        super.func_191958_b(motionXCalc, 0.0f, motionZCalc, 0.25f);
                        if (this.isBeingRiddenByPlayer()) {
                            EntityPlayer rider = this.getPlayerRiding();
                            if (!rider.field_71075_bZ.field_75098_d) {
                                this.heatGenerated += 625;
                                this.powerUsage += 209;
                            }
                        } else {
                            this.heatGenerated += 625;
                            this.powerUsage += 209;
                        }
                        if (this.getOverheated() || !this.hasPower()) {
                            this.boostDurationTimer = 0;
                            PacketDispatcher.sendToAll(new PacketKeyBoostPress(this.func_145782_y(), false, 160, 0));
                            --this.boostDurationTimer;
                        }
                    } else if (this.boostDurationTimer == 0) {
                        PacketDispatcher.sendToAll(new PacketKeyBoostPress(this.func_145782_y(), false, 160, 0));
                        --this.boostDurationTimer;
                    }
                    if (this.boostAvailableTimer > 0) {
                        --this.boostAvailableTimer;
                    } else {
                        this.setCanPressBoostKey(true);
                        this.boostAvailableTimer = 0;
                        this.boostDurationTimer = 0;
                        PacketDispatcher.sendToAll(new PacketKeyBoostPress(this.func_145782_y(), true, 0, 0));
                    }
                }
            } else {
                this.spawnBoostParticles();
            }
        }
    }

    public void setCanPressBoostKey(boolean canPressKey) {
        if (canPressKey) {
            this.setOptions(this.getOptions() | HoverboardOptions.canPressBoostKey.value);
        } else {
            this.setOptions(this.getOptions() & ~HoverboardOptions.canPressBoostKey.value);
        }
    }

    public final boolean getCanPressBoostKey() {
        return (this.getOptions() & HoverboardOptions.canPressBoostKey.value) == HoverboardOptions.canPressBoostKey.value;
    }

    public void setBoostAvailable(int i) {
        this.boostAvailableTimer = i;
    }

    public void setBoostDuration(int i) {
        this.boostDurationTimer = i;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.HOVERBOARD_MISC;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.HOVERBOARD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.HOVERBOARD_DEAD;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    public int func_70627_aG() {
        return 700;
    }

    protected Item func_146068_u() {
        return null;
    }

    public void openGUI(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getPrivateStorage()) {
                if (this.getOwnerUUID().equals(player.func_110124_au())) {
                    FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Main.INSTANCE, (int)1, (World)this.field_70170_p, (int)this.func_145782_y(), (int)this.func_145782_y(), (int)this.func_145782_y());
                }
            } else {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Main.INSTANCE, (int)1, (World)this.field_70170_p, (int)this.func_145782_y(), (int)this.func_145782_y(), (int)this.func_145782_y());
            }
        }
    }

    public void dropChestItems() {
        if (this.items != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack itemstack = this.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                int x = (int)this.field_70165_t;
                int y = (int)this.field_70163_u;
                int z = (int)this.field_70161_v;
                float f = this.field_70170_p.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = this.field_70170_p.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = this.field_70170_p.field_73012_v.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(this.field_70170_p, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), itemstack);
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)this.field_70170_p.field_73012_v.nextGaussian() * 0.05f;
                entityitem.field_70181_x = (float)this.field_70170_p.field_73012_v.nextGaussian() * 0.05f + 0.2f;
                entityitem.field_70179_y = (float)this.field_70170_p.field_73012_v.nextGaussian() * 0.05f;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p().func_74737_b());
                }
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    public void dropDeathItems() {
        this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(HoverboardModItems.carbon_fibre, 6)));
        this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(HoverboardModItems.thruster, 1)));
        this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(HoverboardModItems.power_module, 2)));
        this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Items.field_151137_ax, 8)));
    }

    public final void setUpgrades(int upgrades) {
        this.field_70180_af.func_187227_b(UPGRADES, (Object)upgrades);
    }

    public final int getUpgrades() {
        return (Integer)this.field_70180_af.func_187225_a(UPGRADES);
    }

    public final void setOptions(HoverboardOptions hoverboardOptions, boolean active) {
        if (active) {
            this.setOptions(this.getOptions() | hoverboardOptions.value);
        } else {
            this.setOptions(this.getOptions() & ~hoverboardOptions.value);
        }
    }

    public final void setOptions(int options) {
        this.field_70180_af.func_187227_b(OPTIONS, (Object)options);
    }

    public final boolean getOption(HoverboardOptions hoverboardOptions) {
        return (this.getOptions() & hoverboardOptions.value) == hoverboardOptions.value;
    }

    public final int getOptions() {
        return (Integer)this.field_70180_af.func_187225_a(OPTIONS);
    }

    public List<HoverboardUpgrades> getAllUpgrades() {
        ArrayList<HoverboardUpgrades> list = new ArrayList<HoverboardUpgrades>();
        for (HoverboardUpgrades hoverboardUpgrades : HoverboardUpgrades.values()) {
            if ((this.getUpgrades() & hoverboardUpgrades.value) != hoverboardUpgrades.value) continue;
            list.add(hoverboardUpgrades);
        }
        return list;
    }

    public void setUpgrade(HoverboardUpgrades hoverboardUpgrades, boolean bool) {
        if (bool) {
            this.setUpgrades((short)(this.getUpgrades() | hoverboardUpgrades.value));
        } else {
            this.setUpgrades((short)(this.getUpgrades() & ~hoverboardUpgrades.value));
        }
    }

    public boolean hasUpgrade(HoverboardUpgrades hoverboardUpgrades) {
        return (this.getUpgrades() & hoverboardUpgrades.value) == hoverboardUpgrades.value;
    }

    public EntityLivingBase getOwnerEntity() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public UUID getOwnerUUID() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).orNull();
    }

    public void setOwner(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, (Object)Optional.fromNullable((Object)uuid));
    }

    public void setOwnerName(String name) {
        this.field_70180_af.func_187227_b(OWNER_NAME, (Object)name);
    }

    public String getOwnerName() {
        return (String)this.field_70180_af.func_187225_a(OWNER_NAME);
    }

    public ArrayList<TexturedModel> getModels() {
        return this.models;
    }

    public ArrayList<TexturedModel> getModelsRenderPass() {
        return this.modelsRenderPass;
    }

    @SideOnly(value=Side.CLIENT)
    private void calculateRotations() {
        if (this.forward > 0.0f) {
            this.isMovingForward = true;
            this.isMovingBackward = false;
        } else if (this.forward < 0.0f) {
            this.isMovingForward = false;
            this.isMovingBackward = true;
        } else {
            this.isMovingForward = false;
            this.isMovingBackward = false;
        }
        if (this.strafe > 0.0f) {
            this.isMovingLeft = true;
            this.isMovingRight = false;
        } else if (this.strafe < 0.0f) {
            this.isMovingLeft = false;
            this.isMovingRight = true;
        } else {
            this.isMovingLeft = false;
            this.isMovingRight = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getLongitudinalRotationDegrees() {
        return this.longitudinalRotationDegrees;
    }

    @SideOnly(value=Side.CLIENT)
    public void setLongitudinalRotationDegrees(float value) {
        if (value > 10.0f) {
            value = 10.0f;
        } else if (value < -5.0f) {
            value = -5.0f;
        }
        this.longitudinalRotationDegrees = value;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSidewaysRotationDegrees() {
        return this.sidewaysRotationDegrees;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSidewaysRotationDegrees(float value) {
        if (value > 5.0f) {
            value = 5.0f;
        } else if (value < -5.0f) {
            value = -5.0f;
        }
        this.sidewaysRotationDegrees = value;
    }

    @SideOnly(value=Side.CLIENT)
    public float getRightVentMovement() {
        return this.rightVentMovement;
    }

    @SideOnly(value=Side.CLIENT)
    public float getLeftVentMovement() {
        return this.leftVentMovement;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRightVentMovement(float value) {
        this.rightVentMovement = value > 0.2f ? 0.2f : (value < 0.0f ? 0.0f : value);
    }

    @SideOnly(value=Side.CLIENT)
    public void setLeftVentMovement(float value) {
        this.leftVentMovement = value > 0.0f ? 0.0f : (value < -0.2f ? -0.2f : value);
    }

    public String getStatusHeat() {
        String status = "";
        if (this.getCurrentHeat() < 10000) {
            status = "cold";
        } else if ((double)this.getCurrentHeat() < 20000.0) {
            status = "cool";
        } else if ((float)this.getCurrentHeat() < 40000.0f) {
            status = "warm";
        } else if ((float)this.getCurrentHeat() > 40000.0f) {
            status = "hot";
        }
        return I18n.func_135052_a((String)("container.hoverboard.information.status.heat." + status), (Object[])new Object[0]);
    }

    public String getStatusBoost() {
        if (this.hasUpgrade(HoverboardUpgrades.thruster)) {
            if (!this.hasPower()) {
                return I18n.func_135052_a((String)"container.hoverboard.information.status.any.noPower", (Object[])new Object[0]);
            }
            if (this.isBeingRiddenByPlayer()) {
                EntityPlayer player = this.getPlayerRiding();
                if (player.field_71075_bZ.field_75098_d) {
                    if (this.getCanPressBoostKey()) {
                        return I18n.func_135052_a((String)"container.hoverboard.information.status.any.ready", (Object[])new Object[0]);
                    }
                    return I18n.func_135052_a((String)"container.hoverboard.information.status.any.notReady", (Object[])new Object[0]);
                }
                if (this.getCurrentPower() > 0) {
                    if (this.getCanPressBoostKey()) {
                        return I18n.func_135052_a((String)"container.hoverboard.information.status.any.ready", (Object[])new Object[0]);
                    }
                    return I18n.func_135052_a((String)"container.hoverboard.information.status.any.notReady", (Object[])new Object[0]);
                }
                return I18n.func_135052_a((String)"container.hoverboard.information.status.boost.noPower", (Object[])new Object[0]);
            }
            return I18n.func_135052_a((String)"container.hoverboard.information.status.any.noPilot", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"container.hoverboard.information.status.any.notInstalled", (Object[])new Object[0]);
    }

    public String getStatusRocket() {
        if (this.hasUpgrade(HoverboardUpgrades.rocket)) {
            if (this.getCurrentRocketsToShoot() == 0) {
                return I18n.func_135052_a((String)"container.hoverboard.information.status.rocket.disarmed", (Object[])new Object[0]);
            }
            if (!this.hasPower()) {
                return I18n.func_135052_a((String)"container.hoverboard.information.status.any.noPower", (Object[])new Object[0]);
            }
            if (this.isBeingRiddenByPlayer()) {
                EntityPlayer player = this.getPlayerRiding();
                if (player.field_71075_bZ.field_75098_d) {
                    if (this.getCanPressRocketKey()) {
                        return I18n.func_135052_a((String)"container.hoverboard.information.status.any.ready", (Object[])new Object[0]);
                    }
                    return I18n.func_135052_a((String)"container.hoverboard.information.status.any.notReady", (Object[])new Object[0]);
                }
                if (this.getCurrentRockets() > 0) {
                    if (this.getCanPressRocketKey()) {
                        return I18n.func_135052_a((String)"container.hoverboard.information.status.any.ready", (Object[])new Object[0]);
                    }
                    return I18n.func_135052_a((String)"container.hoverboard.information.status.any.notReady", (Object[])new Object[0]);
                }
                return I18n.func_135052_a((String)"container.hoverboard.information.status.rocket.noAmmo", (Object[])new Object[0]);
            }
            return I18n.func_135052_a((String)"container.hoverboard.information.status.any.noPilot", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"container.hoverboard.information.status.any.notInstalled", (Object[])new Object[0]);
    }

    public void func_76316_a(IInventory invBasic) {
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    private final class MiningBlock {
        public final int id;
        public final int x;
        public final int y;
        public final int z;
        public int breakAmount;

        public MiningBlock(int id, int x, int y, int z, int breakAmount) {
            this.id = id;
            this.x = x;
            this.y = y;
            this.z = z;
            this.breakAmount = breakAmount;
        }
    }
}

