/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.entities;

import com.arkifgames.hoverboardmod.client.audio.SoundEvents;
import com.arkifgames.hoverboardmod.main.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityRocket
extends EntityThrowable {
    private static final float Speed = 1.75f;
    private static final float explosionRadius = 4.0f;
    private int hoverboardID;
    private int playerID;

    public EntityRocket(World par2World) {
        super(par2World);
    }

    public EntityRocket(World par1World, EntityPlayer par2EntityPlayer, int hoverboardID) {
        super(par1World, (EntityLivingBase)par2EntityPlayer);
        this.func_70012_b(par2EntityPlayer.field_70165_t, par2EntityPlayer.field_70163_u + (double)par2EntityPlayer.func_70047_e(), par2EntityPlayer.field_70161_v, par2EntityPlayer.field_70177_z, par2EntityPlayer.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)((this.field_70125_A + 0.0f) / 180.0f * (float)Math.PI)) * f;
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, 1.0f);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70159_w *= 1.75;
        this.field_70181_x *= 1.75;
        this.field_70179_y *= 1.75;
        this.hoverboardID = hoverboardID;
        this.playerID = par2EntityPlayer.func_145782_y();
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.ROCKET_LAUNCH, SoundCategory.NEUTRAL, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void setThrowableHeading(double x, double y, double z, float velocity, float inaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
    }

    protected float func_70185_h() {
        return 0.01f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 16; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w * (double)-0.1f, this.field_70181_x * (double)-0.1f, this.field_70179_y * (double)-0.1f, new int[0]);
            }
        }
    }

    protected void func_70184_a(RayTraceResult movingObjectPosition) {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa < 2) {
            return;
        }
        if (movingObjectPosition.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (movingObjectPosition.field_72308_g.func_145782_y() != this.getShooterIDHoverboard() && movingObjectPosition.field_72308_g.func_145782_y() != this.getShooterIDPlayer()) {
                this.onHit();
            }
        } else {
            this.onHit();
        }
    }

    private void onHit() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 32; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + this.field_70170_p.field_73012_v.nextGaussian() * 3.0, this.field_70163_u + this.field_70170_p.field_73012_v.nextGaussian() * 3.0, this.field_70161_v + this.field_70170_p.field_73012_v.nextGaussian() * 3.0, 0.0, 0.25, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, this.field_70165_t + this.field_70170_p.field_73012_v.nextGaussian() * 3.0, this.field_70163_u + this.field_70170_p.field_73012_v.nextGaussian() * 3.0, this.field_70161_v + this.field_70170_p.field_73012_v.nextGaussian() * 3.0, 0.0, 0.25, 0.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            com.arkifgames.hoverboardmod.world.Explosion explosion = new com.arkifgames.hoverboardmod.world.Explosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 4.0f, false, Config.ROCKET_TERRAIN_DAMAGE);
            if (ForgeEventFactory.onExplosionStart((World)this.field_70170_p, (Explosion)explosion)) {
                return;
            }
            explosion.func_77278_a();
            explosion.func_77279_a(true);
            this.func_70106_y();
        }
    }

    public int getShooterIDHoverboard() {
        return this.hoverboardID;
    }

    public int getShooterIDPlayer() {
        return this.playerID;
    }
}

