/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.itemblocks;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.arkifgames.hoverboardmod.util.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemBlockMachine
extends ItemBlock
implements IEnergyContainerItem {
    public static final String ENERGY = "Energy";
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public ItemBlockMachine(Block block, Integer capacity, Integer maxReceive, Integer maxExtract) {
        super(block);
        this.func_77627_a(true);
        this.func_77656_e(1);
        this.func_77625_d(1);
        this.setNoRepair();
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.func_77942_o()) {
            Util.setDefaultEnergyTag(stack, 0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e(ENERGY) / (double)this.capacity;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            tooltip.add(I18n.func_135052_a((String)"info.hoverboardmod.energy", (Object[])new Object[]{stack.func_77978_p().func_74762_e(ENERGY), this.capacity}));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return this.capacity;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public void setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        int stored = Math.min(container.func_77978_p().func_74762_e(ENERGY), this.getMaxEnergyStored(container));
        int energyReceived = Math.min(this.capacity - stored, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a(ENERGY, stored += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b(ENERGY)) {
            return 0;
        }
        int stored = Math.min(container.func_77978_p().func_74762_e(ENERGY), this.getMaxEnergyStored(container));
        int energyExtracted = Math.min(stored, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74768_a(ENERGY, stored -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b(ENERGY)) {
            return 0;
        }
        return Math.min(container.func_77978_p().func_74762_e(ENERGY), this.getMaxEnergyStored(container));
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_190940_C);
    }
}

