/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.items;

import cofh.redstoneflux.impl.ItemEnergyContainer;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardUpgrades;
import com.arkifgames.hoverboardmod.util.Util;
import java.util.List;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemHoverboard
extends ItemEnergyContainer {
    public ItemHoverboard(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.field_77777_bU = 1;
        this.func_77655_b("hoverboard");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return super.initCapabilities(stack, nbt);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos blockPos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Entity created;
        NBTTagCompound tag;
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        IBlockState blockClicked = world.func_180495_p(blockPos);
        BlockPos pos = new BlockPos(blockPos.func_177958_n() + facing.func_82601_c() * 1, blockPos.func_177956_o() + facing.func_96559_d() * 1, blockPos.func_177952_p() + facing.func_82599_e() * 1);
        double spawnOffsetY = 0.0;
        if (facing == EnumFacing.UP && blockClicked.func_177230_c() instanceof BlockFence) {
            spawnOffsetY = 0.5;
        }
        int offsetX = facing.func_82601_c();
        int offsetY = facing == EnumFacing.DOWN ? -1 : 0;
        int offsetZ = facing.func_82599_e();
        if (ItemHoverboard.getEntityData(itemStack) == null) {
            EntityHoverboard entityHoverboardNew = new EntityHoverboard(world);
            AxisAlignedBB boundingBox = entityHoverboardNew.func_174813_aQ();
            entityHoverboardNew.func_70012_b((double)pos.func_177958_n() + 0.5 + (boundingBox.field_72336_d - boundingBox.field_72340_a) * 0.5 * (double)offsetX, (double)pos.func_177956_o() + spawnOffsetY + (boundingBox.field_72337_e - boundingBox.field_72338_b) * 0.5 * (double)offsetY, (double)pos.func_177952_p() + 0.5 + (boundingBox.field_72334_f - boundingBox.field_72339_c) * 0.5 * (double)offsetZ, 0.0f, 0.0f);
            entityHoverboardNew.setOwner(player.func_110124_au());
            entityHoverboardNew.setOwnerName(player.func_70005_c_());
            world.func_72838_d((Entity)entityHoverboardNew);
            if (itemStack.func_77958_k() > 0x100000) {
                entityHoverboardNew.setUpgrade(HoverboardUpgrades.energy_capacity, true);
            }
            itemStack.func_190918_g(1);
            entityHoverboardNew.setCurrentPower(this.getEnergyStored(itemStack));
            return EnumActionResult.SUCCESS;
        }
        if (player.field_71075_bZ.field_75098_d && (tag = ItemHoverboard.getEntityData(itemStack = itemStack.func_77946_l())) != null) {
            tag.func_82580_o("UUID");
            tag.func_82580_o("UUIDMost");
            tag.func_82580_o("UUIDLeast");
        }
        if (!((created = EntityList.func_75615_a((NBTTagCompound)ItemHoverboard.getEntityData(itemStack), (World)world)) instanceof EntityHoverboard)) {
            return EnumActionResult.SUCCESS;
        }
        EntityHoverboard hoverboard = (EntityHoverboard)created;
        if (hoverboard != null) {
            AxisAlignedBB boundingBox = hoverboard.func_174813_aQ();
            hoverboard.func_70012_b((double)pos.func_177958_n() + 0.5 + (boundingBox.field_72336_d - boundingBox.field_72340_a) * 0.5 * (double)offsetX, (double)pos.func_177956_o() + spawnOffsetY + (boundingBox.field_72337_e - boundingBox.field_72338_b) * 0.5 * (double)offsetY, (double)pos.func_177952_p() + 0.5 + (boundingBox.field_72334_f - boundingBox.field_72339_c) * 0.5 * (double)offsetZ, 0.0f, 0.0f);
            world.func_72838_d((Entity)hoverboard);
            hoverboard.func_70642_aH();
            hoverboard.setCurrentPower(itemStack.func_77978_p().func_74762_e("Energy"));
            hoverboard.field_71093_bK = player.field_71093_bK;
            if (itemStack.func_82837_s()) {
                hoverboard.func_96094_a(itemStack.func_82833_r());
            }
            itemStack.func_190918_g(1);
            itemStack.func_77982_d(null);
        }
        return hoverboard != null ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public static NBTTagCompound getEntityData(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("EntityData", 10) ? itemStack.func_77978_p().func_74775_l("EntityData") : null;
    }

    public void func_77624_a(ItemStack itemStack, World world, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(itemStack, world, tooltip, flagIn);
        if (itemStack.func_77942_o()) {
            tooltip.add(I18n.func_135052_a((String)"info.hoverboardmod.energy", (Object[])new Object[]{itemStack.func_77978_p().func_74762_e("Energy"), this.capacity}));
        }
        if (!GuiScreen.func_146272_n()) {
            tooltip.add(Util.shiftForDetails());
        } else if (itemStack.func_77942_o() && !itemStack.func_77978_p().func_82582_d()) {
            NBTTagCompound extendedHoverbard;
            NBTTagCompound entityData = (NBTTagCompound)itemStack.func_77978_p().func_74781_a("EntityData");
            byte upgradeCount = 0;
            String ownerName = null;
            if (entityData != null && (extendedHoverbard = (NBTTagCompound)entityData.func_74781_a("ExtendedHoverboard")) != null) {
                short upgrades = extendedHoverbard.func_74765_d("Upgrades");
                for (HoverboardUpgrades hoverboardUpgrades : HoverboardUpgrades.values()) {
                    if ((upgrades & hoverboardUpgrades.value) != hoverboardUpgrades.value) continue;
                    upgradeCount = (byte)(upgradeCount + 1);
                }
                if (extendedHoverbard.func_74764_b("OwnerName")) {
                    ownerName = extendedHoverbard.func_74779_i("OwnerName");
                }
            }
            tooltip.add(I18n.func_135052_a((String)"info.hoverboardmod.item.hoverboard", (Object[])new Object[]{upgradeCount}));
            if (ownerName != null) {
                tooltip.add(I18n.func_135052_a((String)"info.hoverboardmod.item.owner", (Object[])new Object[]{ownerName}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"info.hoverboardmod.item.owner.none", (Object[])new Object[0]));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"info.hoverboardmod.item.owner.none", (Object[])new Object[0]));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)Util.setDefaultEnergyTag(new ItemStack((Item)this, 1, 0), 0));
            items.add((Object)Util.setDefaultEnergyTag(new ItemStack((Item)this, 1, 0), this.capacity));
        }
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.func_77942_o()) {
            Util.setDefaultEnergyTag(stack, 0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.capacity;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.capacity;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_190940_C);
    }
}

