/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.items;

import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardUpgrades;
import com.arkifgames.hoverboardmod.items.HoverboardModItems;
import com.arkifgames.hoverboardmod.util.Util;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWrench
extends Item {
    private float damageVsEntity;
    private static TextComponentTranslation NOT_OWNER = new TextComponentTranslation("info.hoverboardmod.not.owner", new Object[0]);

    public ItemWrench() {
        this.func_77625_d(1);
        this.func_77656_e(256);
        this.damageVsEntity = 6.0f;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target instanceof EntityHoverboard) {
            EntityHoverboard target1 = (EntityHoverboard)target;
            ItemStack itemStack = player.func_184586_b(hand);
            if (target.field_70170_p.field_72995_K) {
                return false;
            }
            if (!target1.getOwnerUUID().equals(player.func_110124_au())) {
                player.func_146105_b((ITextComponent)NOT_OWNER, true);
                return false;
            }
            if (target1.func_184207_aI()) {
                if (target1.func_184188_bt().get(0) instanceof EntityLivingBase) {
                    EntityLivingBase rider = (EntityLivingBase)target1.func_184188_bt().get(0);
                    rider.func_110145_l((Entity)target1);
                } else {
                    target1.func_110145_l((Entity)target1.func_184188_bt().get(0));
                }
            }
            NBTTagCompound entityTagCompound = new NBTTagCompound();
            target1.func_189511_e(entityTagCompound);
            entityTagCompound.func_74778_a("id", EntityList.func_191301_a((Entity)target).toString());
            itemStack.func_77972_a(1, (EntityLivingBase)player);
            ItemStack newItem = new ItemStack(target1.hasUpgrade(HoverboardUpgrades.energy_capacity) ? HoverboardModItems.hoverboard_capacity_upgrade : HoverboardModItems.hoverboard);
            newItem.func_77983_a("EntityData", (NBTBase)entityTagCompound);
            newItem.func_77978_p().func_74768_a("Energy", target1.getCurrentPower());
            EntityItem entityItem = target1.func_70099_a(newItem, 1.0f);
            double deltaX = player.field_70165_t - target1.field_70165_t;
            double deltaY = player.field_70163_u + (double)player.func_70047_e() - target1.field_70163_u;
            double deltaZ = player.field_70161_v - target1.field_70161_v;
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double absY = Math.abs(deltaY);
            if (distance > 1.0) {
                deltaX /= distance;
                deltaZ /= distance;
            }
            if (absY > 1.0) {
                deltaY /= absY;
            }
            entityItem.field_70159_w = deltaX * (Math.abs(distance) * (double)0.1f);
            entityItem.field_70181_x = deltaY * (Math.abs(absY) * (double)0.1f);
            entityItem.field_70179_y = deltaZ * (Math.abs(distance) * (double)0.1f);
            target1.func_70106_y();
            return true;
        }
        return false;
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase attacked, EntityLivingBase attacker) {
        attacked.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 1));
        itemstack.func_77972_a(2, attacker);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.damageVsEntity, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.0, 0));
        }
        return multimap;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!GuiScreen.func_146272_n()) {
            tooltip.add(Util.shiftForDetails());
        } else {
            tooltip.add(I18n.func_135052_a((String)"info.hoverboardmod.item.wrench", (Object[])new Object[0]));
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185307_s) || EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_180312_n) || EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_77334_n) || EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_180313_o) || EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185304_p) || EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185296_A) || EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185302_k) || EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185303_l) || EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_191530_r) || EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_190940_C);
    }
}

