/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.main;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Config {
    public static boolean ALLOW_COLLECT_ITEMS;
    public static boolean ALLOW_LIGHT_SOURCE;
    public static float CAVE_LIGHT_BRIGHTNESS;
    public static boolean ALLOW_SHIELD;
    public static boolean ALLOW_MINING;
    public static boolean ROCKET_TERRAIN_DAMAGE;
    public static boolean HOVERBOARD_TERRAIN_DAMAGE;
    public static boolean HOVERBOARD_OLD_SOUNDS;
    public static boolean RECIPES_INDUSTRIAL_CRAFT_2;
    public static boolean RECIPES_BUILDCRAFT;
    public static boolean RECIPES_ACTUALLY_ADDITIONS;
    public static boolean RECIPES_THERMAL_FOUNDATION;
    public static boolean RECIPES_THERMAL_EXPANSION;
    public static boolean JUMP_ASCEND;
    public static boolean SPRINT_DESCEND;
    public static boolean HOVERBOARD_HOVER_MODE;
    public static float HOVERBOARD_HOVER_HEIGHT;
    public static Configuration CONFIG;
    public static boolean IC2_INSTALLED;
    public static boolean BUILDCRAFT_INSTALLED;
    public static boolean THERMAL_EXPANSION_INSTALLED;
    public static boolean THERMAL_FOUNDATION_INSTALLED;
    public static boolean THERMAL_DYNAMICS_INSTALLED;
    public static boolean MEKANISM_INSTALLED;
    public static boolean ACTUALLY_ADDITIONS_INSTALLED;
    public static boolean INTEGRATED_TUNNELS_INSTALLED;
    public static boolean INTEGRATED_DYNAMICS_INSTALLED;
    public static boolean EXTRA_UTILITIES_2_INSTALLED;
    public static boolean ENDER_IO_INSTALLED;

    public static void loadConfig(FMLPreInitializationEvent event) {
        CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        CONFIG.load();
        ALLOW_COLLECT_ITEMS = CONFIG.getBoolean("Enable Hoverboard Collect Items Upgrade", "Hoverboard", true, "Set true to enable the hoverboard to have the option to collect nearby items.");
        ALLOW_LIGHT_SOURCE = CONFIG.getBoolean("Enable Hoverboard Cave Light Upgrade", "Hoverboard", true, "Set true to enable the hoverboard to have the option to provide light in caves.");
        CAVE_LIGHT_BRIGHTNESS = CONFIG.getFloat("Lowest Cave Light Brightness", "Hoverboard", 1.0f, 0.017543858f, 1.0f, "Set a lower number to reduce cave light smoothness. A higher number looks nicer, but requires more computing resources. This can help reduce server lag.");
        ALLOW_SHIELD = CONFIG.getBoolean("Enable Hoverboard Shield Upgrade", "Hoverboard", true, "Set true to enable the hoverboard to use the shield option to reflect projectiles and push away mobs.");
        ALLOW_MINING = CONFIG.getBoolean("Enable Hoverboard Mining Mode Upgrade", "Hoverboard", true, "Set true to enable the hoverboard to use the mining option to mine blocks. (Set false on public servers to stop griefers.)");
        ROCKET_TERRAIN_DAMAGE = CONFIG.getBoolean("Enable Hoverboard Rocket Terrain Damage", "Hoverboard", false, "Set true to enable the hoverboard rockets to damage the terrain. (Set false on public servers to stop griefers.)");
        HOVERBOARD_TERRAIN_DAMAGE = CONFIG.getBoolean("Enable Hoverboard Terrain Damage", "Hoverboard", false, "Set true to enable the hoverboard to destroy blocks such as tall grass and flowers when in contact.");
        HOVERBOARD_OLD_SOUNDS = CONFIG.getBoolean("Use 1.7.10 Hoverboard Sounds", "Hoverboard", false, "Set true to use the hoverboard sounds from mod version 0.3 if you prefer them. (Client only.)");
        JUMP_ASCEND = CONFIG.getBoolean("Jump Key Ascend", "Keys", true, "Use the jump key to ascend on the hoverboard. Ignores the ascend key binding.");
        SPRINT_DESCEND = CONFIG.getBoolean("Sprint Key Descend", "Keys", true, "Use the sprint key to descend on the hoverboard. Ignores the descend key binding.");
        RECIPES_INDUSTRIAL_CRAFT_2 = CONFIG.getBoolean("Use IC2 Recipes", "Recipes", true, "Set true to use the crafting recipes containing Industrial Craft 2 items.");
        RECIPES_BUILDCRAFT = CONFIG.getBoolean("Use BuildCraft Recipes", "Recipes", true, "Set true to use the crafting recipes containing BuildCraft items.");
        RECIPES_ACTUALLY_ADDITIONS = CONFIG.getBoolean("Use Actually Additions Recipes", "Recipes", true, "Set true to use the crafting recipes containing Actually Additions items.");
        RECIPES_THERMAL_FOUNDATION = CONFIG.getBoolean("Use Thermal Foundation Recipes", "Recipes", true, "Set true to use the crafting recipes containing Thermal Foundation items.");
        RECIPES_THERMAL_EXPANSION = CONFIG.getBoolean("Use Thermal Expansion Recipes", "Recipes", true, "Set true to use the crafting recipes containing Thermal Expansion items.");
        HOVERBOARD_HOVER_MODE = CONFIG.getBoolean("Enabled Hover Mode", "Hoverboard", false, "Set true to use the hover mode, you can still fly up and down but it will target the set hover height.");
        HOVERBOARD_HOVER_HEIGHT = CONFIG.getFloat("Target Hover Height", "Hoverboard", 1.5f, 1.0f, 10.0f, "Set the target hover height for the hoverboard when hover mode is enabled.");
        CONFIG.save();
    }

    public static void getModsLoaded(FMLInitializationEvent event) {
        IC2_INSTALLED = Loader.isModLoaded((String)"ic2");
        BUILDCRAFT_INSTALLED = Loader.isModLoaded((String)"buildcraftcore");
        THERMAL_FOUNDATION_INSTALLED = Loader.isModLoaded((String)"thermalfoundation");
        THERMAL_EXPANSION_INSTALLED = Loader.isModLoaded((String)"thermalexpansion");
        THERMAL_DYNAMICS_INSTALLED = Loader.isModLoaded((String)"thermaldynamics");
        MEKANISM_INSTALLED = Loader.isModLoaded((String)"mekanism");
        ACTUALLY_ADDITIONS_INSTALLED = Loader.isModLoaded((String)"actuallyadditions");
        INTEGRATED_TUNNELS_INSTALLED = Loader.isModLoaded((String)"integratedtunnels");
        INTEGRATED_DYNAMICS_INSTALLED = Loader.isModLoaded((String)"integrateddynamics");
        EXTRA_UTILITIES_2_INSTALLED = Loader.isModLoaded((String)"extrautils2");
        ENDER_IO_INSTALLED = Loader.isModLoaded((String)"enderio");
    }
}

