/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.main;

import com.arkifgames.hoverboardmod.blocks.HoverboardModBlocks;
import com.arkifgames.hoverboardmod.crafting.CraftingRecipes;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.entities.EntityRocket;
import com.arkifgames.hoverboardmod.inventory.GuiHandler;
import com.arkifgames.hoverboardmod.items.HoverboardModItems;
import com.arkifgames.hoverboardmod.main.Config;
import com.arkifgames.hoverboardmod.main.HoverboardEventHandler;
import com.arkifgames.hoverboardmod.main.HoverboardModTab;
import com.arkifgames.hoverboardmod.main.ModInfo;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import com.arkifgames.hoverboardmod.proxy.IProxy;
import com.arkifgames.hoverboardmod.tileentity.TileEntityHoverboardBuilder;
import com.arkifgames.hoverboardmod.tileentity.TileEntityHoverboardCharger;
import com.arkifgames.hoverboardmod.tileentity.TileEntityHoverboardDocker;
import com.arkifgames.hoverboardmod.tileentity.TileEntityMeltSpinner;
import com.arkifgames.hoverboardmod.tileentity.TileEntitySolarPanel;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="hoverboardmod", name="Arkif's Hoverboard Mod", version="0.4.2", acceptedMinecraftVersions="[1.12.2]", useMetadata=false, updateJSON="https://gist.githubusercontent.com/Arkif100/e5f85a11cfa65987fc8e84144b3ee3f0/raw/Arkif'sHoverboardMod.json", dependencies="required-after:redstoneflux;required-after:RenderPlayerAPI;")
@Mod.EventBusSubscriber
public class Main {
    @Mod.Instance(value="hoverboardmod")
    public static Main INSTANCE;
    @SidedProxy(clientSide="com.arkifgames.hoverboardmod.proxy.ClientProxy", serverSide="com.arkifgames.hoverboardmod.proxy.ServerProxy")
    public static IProxy PROXY;
    public static CreativeTabs TAB_HOVERBOARD;
    public static boolean KEY_UP_PRESSED;
    public static boolean KEY_DOWN_PRESSED;
    public static boolean KEY_ROCKET_PRESSED;
    public static boolean KEY_INV_PRESSED;
    public static boolean KEY_BOOST_PRESSED;
    public static final int GUI_ID_HOVERBOARD_BUILDER = 0;
    public static final int GUI_ID_HOVERBOARD = 1;
    public static final int GUI_ID_HOVERBOARD_STORAGE_PAGE_2 = 2;
    public static final int GUI_ID_HOVERBOARD_STORAGE_PAGE_3 = 3;
    public static final int GUI_ID_HOVERBOARD_STORAGE_PAGE_4 = 4;
    public static final int GUI_ID_HOVERBOARD_STORAGE_PAGE_5 = 5;
    public static final int GUI_ID_HOVERBOARD_STORAGE_PAGE_6 = 6;
    public static final int GUI_ID_HOVERBOARD_STORAGE_PAGE_7 = 7;
    public static final int GUI_ID_HOVERBOARD_STORAGE_PAGE_8 = 8;
    public static final int GUI_ID_HOVERBOARD_STORAGE_PAGE_9 = 9;
    public static final int GUI_ID_HOVERBOARD_DOCKER = 10;
    public static final int GUI_ID_MELT_SPINNER = 11;
    public static final int GUI_ID_SOLAR_PANEL = 12;
    public static final int GUI_ID_HOVERBOARD_CHARGER = 13;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModInfo.load(event);
        Config.loadConfig(event);
        PacketDispatcher.registerPackets();
        MinecraftForge.EVENT_BUS.register((Object)new HoverboardEventHandler());
        PROXY.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Config.getModsLoaded(event);
        this.registerTileEntities();
        PROXY.init(event);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CraftingRecipes.loadCraftingRecipes();
        PROXY.postInit(event);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        HoverboardModBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        HoverboardModItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
        HoverboardModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityHoverboardBuilder.class, (ResourceLocation)new ResourceLocation("hoverboardmod", "tileEntityHoverboardBuilder"));
        GameRegistry.registerTileEntity(TileEntityHoverboardDocker.class, (ResourceLocation)new ResourceLocation("hoverboardmod", "tileEntityHoverboardDocker"));
        GameRegistry.registerTileEntity(TileEntityHoverboardCharger.class, (ResourceLocation)new ResourceLocation("hoverboardmod", "tileEntityHoverboardCharger"));
        GameRegistry.registerTileEntity(TileEntityMeltSpinner.class, (ResourceLocation)new ResourceLocation("hoverboardmod", "tileEntityHoverboardMeltSpinner"));
        GameRegistry.registerTileEntity(TileEntitySolarPanel.class, (ResourceLocation)new ResourceLocation("hoverboardmod", "tileEntityHoverboardSolarPanel"));
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("hoverboardmod", "hoverboard"), EntityHoverboard.class, (String)"hoverboard", (int)0, (Object)INSTANCE, (int)128, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("hoverboardmod", "rocket"), EntityRocket.class, (String)"rocket", (int)1, (Object)INSTANCE, (int)512, (int)2, (boolean)true);
    }

    static {
        TAB_HOVERBOARD = new HoverboardModTab(CreativeTabs.getNextID(), "hoverboard");
        KEY_UP_PRESSED = false;
        KEY_DOWN_PRESSED = false;
        KEY_ROCKET_PRESSED = false;
        KEY_INV_PRESSED = false;
        KEY_BOOST_PRESSED = false;
    }
}

