/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.network;

import com.arkifgames.hoverboardmod.network.AbstractMessage;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketCharger;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketColor;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketDataSync;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketKeyBoostPress;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketKeyRocketPress;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketParticle;
import com.arkifgames.hoverboardmod.network.bidirectional.PacketShieldBounce;
import com.arkifgames.hoverboardmod.network.client.PacketEntityUpdate;
import com.arkifgames.hoverboardmod.network.client.PacketShieldSync;
import com.arkifgames.hoverboardmod.network.client.PacketThrower;
import com.arkifgames.hoverboardmod.network.client.PacketTileEntityGui;
import com.arkifgames.hoverboardmod.network.client.PacketTileEntityUpdate;
import com.arkifgames.hoverboardmod.network.server.PacketGuiRocket;
import com.arkifgames.hoverboardmod.network.server.PacketHoverboardControl;
import com.arkifgames.hoverboardmod.network.server.PacketHoverboardInventory;
import com.arkifgames.hoverboardmod.network.server.PacketMachineAnimation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDispatcher {
    private static byte PACKET_ID = 0;
    private static final SimpleNetworkWrapper DISPATCHER = NetworkRegistry.INSTANCE.newSimpleChannel("hoverboardmod");

    public static final void registerPackets() {
        PacketDispatcher.registerMessage(PacketHoverboardControl.class);
        PacketDispatcher.registerMessage(PacketGuiRocket.class);
        PacketDispatcher.registerMessage(PacketThrower.class);
        PacketDispatcher.registerMessage(PacketDataSync.class);
        PacketDispatcher.registerMessage(PacketParticle.class);
        PacketDispatcher.registerMessage(PacketShieldBounce.class);
        PacketDispatcher.registerMessage(PacketShieldSync.class);
        PacketDispatcher.registerMessage(PacketKeyRocketPress.class);
        PacketDispatcher.registerMessage(PacketHoverboardInventory.class);
        PacketDispatcher.registerMessage(PacketKeyBoostPress.class);
        PacketDispatcher.registerMessage(PacketCharger.class);
        PacketDispatcher.registerMessage(PacketMachineAnimation.class);
        PacketDispatcher.registerMessage(PacketTileEntityGui.class);
        PacketDispatcher.registerMessage(PacketEntityUpdate.class);
        PacketDispatcher.registerMessage(PacketTileEntityUpdate.class);
        PacketDispatcher.registerMessage(PacketColor.class);
    }

    private static final <T extends AbstractMessage<T>> void registerMessage(Class<T> clazz) {
        if (AbstractMessage.AbstractClientMessage.class.isAssignableFrom(clazz)) {
            PacketDispatcher.registerMessage(clazz, clazz, Side.CLIENT);
        } else if (AbstractMessage.AbstractServerMessage.class.isAssignableFrom(clazz)) {
            PacketDispatcher.registerMessage(clazz, clazz, Side.SERVER);
        } else {
            DISPATCHER.registerMessage(clazz, clazz, (int)PACKET_ID, Side.CLIENT);
            byte by = PACKET_ID;
            PACKET_ID = (byte)(by + 1);
            DISPATCHER.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        }
    }

    private static final void registerMessage(Class handlerClass, Class messageClass, Side side) {
        byte by = PACKET_ID;
        PACKET_ID = (byte)(by + 1);
        DISPATCHER.registerMessage(handlerClass, messageClass, (int)by, side);
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        DISPATCHER.sendTo(message, player);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        DISPATCHER.sendToAllAround(message, point);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        DISPATCHER.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        DISPATCHER.sendToServer(message);
    }

    public static void sendToAll(IMessage message) {
        DISPATCHER.sendToAll(message);
    }
}

