/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.network.bidirectional;

import com.arkifgames.hoverboardmod.client.gui.inventory.ButtonData;
import com.arkifgames.hoverboardmod.client.gui.inventory.GuiHoverboard;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.network.AbstractMessage;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class PacketColor
extends AbstractMessage<PacketColor> {
    private int playerId;
    private int entityId;
    private int sliderId;
    private float value;

    public PacketColor() {
    }

    public PacketColor(int entityId, int dataId, float value) {
        this.playerId = -1;
        this.entityId = entityId;
        this.sliderId = dataId;
        this.value = value;
    }

    public PacketColor(int playerId, int entityId, int dataId, float value) {
        this.playerId = playerId;
        this.entityId = entityId;
        this.sliderId = dataId;
        this.value = value;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.playerId = buffer.readInt();
        this.entityId = buffer.readInt();
        this.sliderId = buffer.readInt();
        this.value = buffer.readFloat();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.playerId);
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.sliderId);
        buffer.writeFloat(this.value);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (player.field_70170_p.func_73045_a(this.entityId) instanceof EntityHoverboard) {
            EntityHoverboard hoverboard = (EntityHoverboard)player.field_70170_p.func_73045_a(this.entityId);
            if (this.sliderId == ButtonData.COLOR_HUE.value) {
                hoverboard.setColorHue(this.value);
            } else if (this.sliderId == ButtonData.COLOR_BRIGHTNESS.value) {
                hoverboard.setColorBrightness(this.value);
            } else if (this.sliderId == ButtonData.COLOR_SATURATION.value) {
                hoverboard.setColorSaturation(this.value);
            }
            if (side.isClient()) {
                hoverboard.setClientColorSynced(false);
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiHoverboard) {
                    GuiHoverboard guiHoverboard = (GuiHoverboard)Minecraft.func_71410_x().field_71462_r;
                    guiHoverboard.setSliderValue(this.sliderId, this.value);
                }
            } else {
                PacketDispatcher.sendToAll(this);
            }
        }
    }
}

